/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.clangd.internal.ui;

import org.eclipse.cdt.lsp.clangd.ClangdConfiguration;
import org.eclipse.cdt.lsp.clangd.ClangdMetadata;
import org.eclipse.cdt.lsp.clangd.ClangdOptions;
import org.eclipse.cdt.lsp.clangd.internal.ui.ClangdConfigurationArea;
import org.eclipse.cdt.lsp.ui.ConfigurationArea;
import org.eclipse.cdt.lsp.ui.ConfigurationPage;
import org.eclipse.cdt.lsp.util.LspUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;

public final class ClangdConfigurationPage
extends ConfigurationPage<ClangdConfiguration, ClangdOptions> {
    private final String id = "org.eclipse.cdt.lsp.clangd.editor.preferencePage";

    protected ClangdConfiguration getConfiguration(IWorkbench workbench) {
        return (ClangdConfiguration)workbench.getService(ClangdConfiguration.class);
    }

    protected ClangdOptions configurationDefaults() {
        return ((ClangdConfiguration)this.configuration).defaults();
    }

    protected ClangdOptions configurationOptions(IAdaptable element) {
        return ((ClangdConfiguration)this.configuration).options(element);
    }

    protected ConfigurationArea<ClangdOptions> getConfigurationArea(Composite composite, boolean isProjectScope) {
        return new ClangdConfigurationArea(composite, isProjectScope);
    }

    protected String getPreferenceId() {
        return "org.eclipse.cdt.lsp.clangd.editor.preferencePage";
    }

    public boolean performOk() {
        boolean configSettingsChanged = this.configurationSettingsChanged();
        boolean projectOptionsDifferFromWorkspace = this.projectOptionsDifferFromWorkspace();
        boolean done = super.performOk();
        if (done && LspUtils.isLsActive() && ((!this.projectScope().isPresent() || this.useProjectSettings()) && configSettingsChanged || projectOptionsDifferFromWorkspace)) {
            LspUtils.restartClangd();
        }
        return done;
    }

    private boolean configurationSettingsChanged() {
        return ((ClangdConfigurationArea)this.area).optionsChanged(((ClangdConfiguration)this.configuration).options(this.getElement()));
    }

    private boolean projectOptionsDifferFromWorkspace() {
        return this.hasProjectSpecificOptions() != this.useProjectSettings() && ((ClangdConfigurationArea)this.area).optionsChanged(((ClangdConfiguration)this.configuration).options(null));
    }

    protected boolean hasProjectSpecificOptions() {
        return this.projectScope().map(p -> p.getNode(((ClangdConfiguration)this.configuration).qualifier())).map(n -> n.get(ClangdMetadata.Predefined.clangdPath.identifer(), null)).isPresent();
    }
}

