/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.tracwiki.internal.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.Block;

public class TableBlock
extends Block {
    static final Pattern tableRowPattern = Pattern.compile("(\\|\\|(.*)?(\\|\\|\\s*$))");
    static final Pattern TABLE_ROW_PATTERN = Pattern.compile("\\|\\|\\s*([^\\|]*)\\s*(\\|\\|\\s*$)?");
    private int blockLineCount = 0;
    private Matcher matcher;

    public int processLineContent(String line, int offset) {
        int start;
        if (this.blockLineCount == 0) {
            Attributes attributes = new Attributes();
            this.builder.beginBlock(DocumentBuilder.BlockType.TABLE, attributes);
        } else {
            this.matcher = tableRowPattern.matcher(line);
            if (!this.matcher.matches()) {
                this.setClosed(true);
                return 0;
            }
        }
        ++this.blockLineCount;
        String textileLine = offset == 0 ? line : line.substring(offset);
        Matcher rowMatcher = TABLE_ROW_PATTERN.matcher(textileLine);
        if (!rowMatcher.find()) {
            this.setClosed(true);
            return 0;
        }
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_ROW, new Attributes());
        while ((start = rowMatcher.start()) != textileLine.length() - 1) {
            String text = rowMatcher.group(1);
            int textOffset = rowMatcher.start(1);
            Attributes attributes = new Attributes();
            this.state.setLineCharacterOffset(start);
            this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_CELL_NORMAL, attributes);
            this.markupLanguage.emitMarkupLine(this.getParser(), this.state, textOffset, text, 0);
            this.builder.endBlock();
            if (rowMatcher.find()) continue;
        }
        this.builder.endBlock();
        return -1;
    }

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        if (lineOffset == 0) {
            this.matcher = tableRowPattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

