/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.properties.ui.internal.page.propertylist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.properties.ui.api.IEEFTabItem;
import org.eclipse.eef.properties.ui.internal.Messages;
import org.eclipse.eef.properties.ui.internal.page.propertylist.EEFAccessibleControlAdapter;
import org.eclipse.eef.properties.ui.internal.page.propertylist.EEFBottomNavigationElement;
import org.eclipse.eef.properties.ui.internal.page.propertylist.EEFListElement;
import org.eclipse.eef.properties.ui.internal.page.propertylist.EEFPropertyListFocusListener;
import org.eclipse.eef.properties.ui.internal.page.propertylist.EEFTabbedPropertyListColorHolder;
import org.eclipse.eef.properties.ui.internal.page.propertylist.EEFTopNavigationElement;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class EEFTabbedPropertyList
extends Composite {
    public static final int NONE = -1;
    public static final int INDENT = 7;
    private EEFWidgetFactory widgetFactory;
    private EEFTopNavigationElement topNavigationElement;
    private EEFBottomNavigationElement bottomNavigationElement;
    private boolean focus;
    private int selectedElementIndex = -1;
    private int widestLabelIndex = -1;
    private int topVisibleIndex = -1;
    private int bottomVisibleIndex = -1;
    private List<EEFListElement> elements = new ArrayList<EEFListElement>();
    private EEFTabbedPropertyListColorHolder colorHolder;
    private int tabsThatFitInComposite;
    private Map<IEEFTabItem, Integer> tabToDynamicImageCountMap = new HashMap<IEEFTabItem, Integer>();

    public EEFTabbedPropertyList(Composite parent, EEFWidgetFactory widgetFactory) {
        super(parent, 524288);
        this.widgetFactory = widgetFactory;
        this.removeAll();
        this.setLayout((Layout)new FormLayout());
        this.initColors();
        this.initAccessible();
        this.topNavigationElement = new EEFTopNavigationElement(this);
        this.bottomNavigationElement = new EEFBottomNavigationElement(this);
        this.initListeners();
    }

    public void removeAll() {
        if (this.elements != null) {
            for (EEFListElement element : this.elements) {
                element.dispose();
            }
        }
        this.elements = new ArrayList<EEFListElement>();
        this.selectedElementIndex = -1;
        this.widestLabelIndex = -1;
        this.topVisibleIndex = -1;
        this.bottomVisibleIndex = -1;
    }

    private void initColors() {
        this.colorHolder = new EEFTabbedPropertyListColorHolder(this.widgetFactory);
    }

    protected void computeTabsThatFitInComposite() {
        this.tabsThatFitInComposite = Math.round((this.getSize().y - 22) / this.getTabHeight());
        if (this.tabsThatFitInComposite <= 0) {
            this.tabsThatFitInComposite = 1;
        }
    }

    private int getTabHeight() {
        int tabHeight = this.getTextDimension((String)"").y + 7;
        if (this.tabsThatFitInComposite == 1) {
            int ret;
            int result = ret = this.getBounds().height - 20;
            if (ret > tabHeight) {
                result = tabHeight;
            } else if (ret < 5) {
                result = 5;
            }
            return result;
        }
        return tabHeight;
    }

    private Point getTextDimension(String text) {
        GC gc = new GC((Drawable)this);
        gc.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        Point point = gc.textExtent(text);
        ++point.x;
        gc.dispose();
        return point;
    }

    public int getNumberOfElements() {
        return this.elements.size();
    }

    public EEFListElement getElementAt(int index) {
        if (index >= 0 && index < this.elements.size()) {
            return this.elements.get(index);
        }
        return null;
    }

    public int getSelectionIndex() {
        return this.selectedElementIndex;
    }

    public int getWidestLabelIndex() {
        return this.widestLabelIndex;
    }

    public void setDynamicImageCount(Map<IEEFTabItem, Integer> map) {
        this.tabToDynamicImageCountMap = map;
    }

    public void setElements(Object[] children) {
        if (this.elements.size() != 0) {
            this.removeAll();
        }
        this.elements = new ArrayList<EEFListElement>(children.length);
        if (children.length == 0) {
            this.widestLabelIndex = -1;
        } else {
            this.widestLabelIndex = 0;
            int i = 0;
            while (i < children.length) {
                int width;
                int dynamicImageCount = 0;
                if (this.tabToDynamicImageCountMap != null && this.tabToDynamicImageCountMap.containsKey(children[i])) {
                    dynamicImageCount = this.tabToDynamicImageCountMap.get(children[i]);
                }
                EEFListElement element = new EEFListElement(this, (IEEFTabItem)children[i], dynamicImageCount, i, this);
                element.setVisible(false);
                element.setLayoutData(null);
                this.elements.add(element);
                if (i != this.widestLabelIndex && (width = this.getTabWidth((IEEFTabItem)children[i])) > this.getTabWidth((IEEFTabItem)children[this.widestLabelIndex])) {
                    this.widestLabelIndex = i;
                }
                ++i;
            }
        }
        this.computeTopAndBottomTab();
    }

    private int getTabWidth(IEEFTabItem tabItem) {
        int width = this.getTextDimension((String)tabItem.getText()).x;
        if (tabItem.getImage() != null) {
            width = width + 16 + 4;
        }
        if (tabItem.isIndented()) {
            width += 7;
        }
        if (this.tabToDynamicImageCountMap != null) {
            int dynamicImageCount = 0;
            if (this.tabToDynamicImageCountMap.containsKey(tabItem)) {
                dynamicImageCount = this.tabToDynamicImageCountMap.get(tabItem);
            }
            if (dynamicImageCount > 0) {
                width += 4;
                width += dynamicImageCount * 16;
                width += (dynamicImageCount - 1) * 3;
            }
        }
        return width;
    }

    public void select(int index) {
        if (this.getSelectionIndex() == index) {
            return;
        }
        if (index >= 0 && index < this.elements.size()) {
            int lastSelected = this.getSelectionIndex();
            this.elements.get(index).setSelected(true);
            this.selectedElementIndex = index;
            if (lastSelected != -1) {
                this.elements.get(lastSelected).setSelected(false);
                if (this.getSelectionIndex() != this.elements.size() - 1) {
                    this.elements.get(this.getSelectionIndex() + 1).setSelected(false);
                }
            }
            this.topNavigationElement.redraw();
            this.bottomNavigationElement.redraw();
            if (this.selectedElementIndex < this.topVisibleIndex || this.selectedElementIndex > this.bottomVisibleIndex) {
                this.computeTopAndBottomTab();
            }
        }
        this.notifyListeners(13, new Event());
    }

    public void deselectAll() {
        if (this.getSelectionIndex() != -1) {
            this.elements.get(this.getSelectionIndex()).setSelected(false);
            this.selectedElementIndex = -1;
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point result = super.computeSize(hHint, wHint, changed);
        if (this.widestLabelIndex == -1) {
            String propertiesNotAvailable = Messages.EEFTabbedPropertyList_propertiesNotAvailable;
            result.x = this.getTextDimension((String)propertiesNotAvailable).x + 7;
        } else {
            int width = this.getTabWidth(this.elements.get(this.widestLabelIndex).getTabItem()) + 7;
            result.x = width + 10;
        }
        return result;
    }

    public boolean isDownScrollRequired() {
        return this.elements.size() > this.tabsThatFitInComposite && this.bottomVisibleIndex != this.elements.size() - 1;
    }

    public boolean isUpScrollRequired() {
        return this.elements.size() > this.tabsThatFitInComposite && this.topVisibleIndex != 0;
    }

    private void computeTopAndBottomTab() {
        this.computeTabsThatFitInComposite();
        if (this.elements.size() == 0) {
            this.topVisibleIndex = 0;
            this.bottomVisibleIndex = 0;
        } else if (this.tabsThatFitInComposite >= this.elements.size()) {
            this.topVisibleIndex = 0;
            this.bottomVisibleIndex = this.elements.size() - 1;
        } else if (this.getSelectionIndex() == -1) {
            this.topVisibleIndex = 0;
            this.bottomVisibleIndex = this.tabsThatFitInComposite - 1;
        } else if (this.getSelectionIndex() + this.tabsThatFitInComposite > this.elements.size()) {
            this.bottomVisibleIndex = this.elements.size() - 1;
            this.topVisibleIndex = this.bottomVisibleIndex - this.tabsThatFitInComposite + 1;
        } else {
            this.topVisibleIndex = this.selectedElementIndex;
            this.bottomVisibleIndex = this.selectedElementIndex + this.tabsThatFitInComposite - 1;
        }
        this.layoutTabs();
    }

    public void layoutTabs() {
        FormData formData;
        if (this.tabsThatFitInComposite == -1 || this.elements.size() == 0) {
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment(0, 0);
            formData.height = this.getTabHeight();
            this.topNavigationElement.setLayoutData(formData);
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)this.topNavigationElement, 0);
            formData.bottom = new FormAttachment(100, 0);
            this.bottomNavigationElement.setLayoutData(formData);
        } else {
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment(0, 0);
            formData.height = 10;
            this.topNavigationElement.setLayoutData(formData);
            EEFTopNavigationElement nextElement = this.topNavigationElement;
            int i = 0;
            while (i < this.elements.size()) {
                if (i < this.topVisibleIndex || i > this.bottomVisibleIndex) {
                    this.elements.get(i).setLayoutData(null);
                    this.elements.get(i).setVisible(false);
                } else {
                    formData = new FormData();
                    formData.height = this.getTabHeight();
                    formData.left = new FormAttachment(0, 0);
                    formData.right = new FormAttachment(100, 0);
                    formData.top = new FormAttachment((Control)nextElement, 0);
                    nextElement = this.elements.get(i);
                    this.elements.get(i).setLayoutData(formData);
                    this.elements.get(i).setVisible(true);
                }
                ++i;
            }
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)nextElement, 0);
            formData.bottom = new FormAttachment(100, 0);
            formData.height = 10;
            this.bottomNavigationElement.setLayoutData(formData);
        }
        Composite grandparent = this.getParent().getParent();
        grandparent.layout(true);
        this.layout(true);
    }

    public EEFTabbedPropertyListColorHolder getColorHolder() {
        return this.colorHolder;
    }

    public int getTopVisibleIndex() {
        return this.topVisibleIndex;
    }

    public void setTopVisibleIndex(int topVisibleIndex) {
        this.topVisibleIndex = topVisibleIndex;
    }

    public int getBottomVisibleIndex() {
        return this.bottomVisibleIndex;
    }

    public void setBottomVisibleIndex(int bottomVisibleIndex) {
        this.bottomVisibleIndex = bottomVisibleIndex;
    }

    public EEFTopNavigationElement getTopNavigationElement() {
        return this.topNavigationElement;
    }

    public EEFBottomNavigationElement getBottomNavigationElement() {
        return this.bottomNavigationElement;
    }

    public boolean getFocus() {
        return this.focus;
    }

    public void setFocus(boolean focus) {
        this.focus = focus;
    }

    private void initAccessible() {
        final Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                int index = EEFTabbedPropertyList.this.getSelectionIndex();
                if (index != -1) {
                    event.result = ((EEFListElement)((Object)EEFTabbedPropertyList.this.elements.get(index))).getTabItem().getText();
                }
            }

            public void getHelp(AccessibleEvent event) {
                int index = EEFTabbedPropertyList.this.getSelectionIndex();
                if (index != -1) {
                    event.result = ((EEFListElement)((Object)EEFTabbedPropertyList.this.elements.get(index))).getTabItem().getText();
                }
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new EEFAccessibleControlAdapter(this));
        this.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (EEFTabbedPropertyList.this.isFocusControl()) {
                    accessible.setFocus(-1);
                }
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                accessible.setFocus(-1);
            }
        });
    }

    private void initListeners() {
        this.addFocusListener(new EEFPropertyListFocusListener(this));
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                EEFTabbedPropertyList.this.computeTopAndBottomTab();
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.detail == 32 || event.detail == 64) {
                    int nMax = EEFTabbedPropertyList.this.elements.size() - 1;
                    int nCurrent = EEFTabbedPropertyList.this.getSelectionIndex();
                    if (event.detail == 32) {
                        --nCurrent;
                        nCurrent = Math.max(0, nCurrent);
                    } else if (event.detail == 64) {
                        ++nCurrent;
                        nCurrent = Math.min(nCurrent, nMax);
                    }
                    EEFTabbedPropertyList.this.select(nCurrent);
                    EEFTabbedPropertyList.this.redraw();
                } else {
                    event.doit = true;
                }
            }
        });
    }
}

