/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.format;

import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.core.util.ViewRefactorHelper;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.JumpLinkStatus;
import org.eclipse.gmf.runtime.notation.JumpLinkType;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.Smoothness;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.formatdata.AbstractFormatData;
import org.eclipse.sirius.diagram.formatdata.EdgeFormatData;
import org.eclipse.sirius.diagram.formatdata.FormatdataFactory;
import org.eclipse.sirius.diagram.formatdata.FormatdataPackage;
import org.eclipse.sirius.diagram.formatdata.NodeFormatData;
import org.eclipse.sirius.diagram.formatdata.Point;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.business.api.query.NodeQuery;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.operation.CenterEdgeEndModelChangeOperation;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.internal.refresh.borderednode.CanonicalDBorderItemLocator;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.format.FormatDataHelper;
import org.eclipse.sirius.diagram.ui.tools.api.format.FormatDataKey;
import org.eclipse.sirius.diagram.ui.tools.api.format.SiriusFormatDataManager;
import org.eclipse.sirius.diagram.ui.tools.api.format.SiriusStyleApplicator;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.ext.draw2d.figure.FigureUtilities;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public abstract class AbstractSiriusFormatDataManager
implements SiriusFormatDataManager,
SiriusStyleApplicator {
    private static final Class<?>[] CLASS_EXCEPTIONS = new Class[]{DNodeListElement.class};

    @Override
    public void storeFormatData(IGraphicalEditPart rootEditPart) {
        HashSet<FormatDataKey> discoveredKeys = new HashSet<FormatDataKey>();
        EObject semanticElement = rootEditPart.resolveSemanticElement();
        View toStoreView = (View)rootEditPart.getModel();
        if (toStoreView instanceof Edge && semanticElement instanceof DEdge) {
            this.addEdgeFormatData(null, (DEdge)semanticElement, rootEditPart.getRoot().getViewer());
        } else if (toStoreView instanceof Diagram && semanticElement instanceof DDiagram) {
            this.addChildFormat((DDiagram)semanticElement, rootEditPart, discoveredKeys);
        } else if (toStoreView instanceof Node && !(rootEditPart instanceof AbstractDiagramNameEditPart) && semanticElement instanceof DDiagramElement && semanticElement instanceof DSemanticDecorator) {
            this.addChildFormat(null, (DRepresentationElement)((DDiagramElement)semanticElement), (Node)toStoreView, rootEditPart, discoveredKeys);
        }
        discoveredKeys.clear();
    }

    @Override
    public void applyFormat(IGraphicalEditPart rootEditPart, boolean absoluteCoordinates) {
        this.applyFormat(rootEditPart, true, true, absoluteCoordinates);
    }

    @Override
    public void applyFormat(IGraphicalEditPart parentEditPart, List<IGraphicalEditPart> childrenSubpart, boolean absoluteCoordinates) {
        this.applyFormat(parentEditPart, childrenSubpart, true, true, absoluteCoordinates);
    }

    @Override
    public void applyLayout(IGraphicalEditPart rootEditPart, boolean absoluteCoordinates) {
        this.applyFormat(rootEditPart, true, false, absoluteCoordinates);
    }

    @Override
    public void applyLayout(IGraphicalEditPart parentEditPart, List<IGraphicalEditPart> childrenSubpart, boolean absoluteCoordinates) {
        this.applyFormat(parentEditPart, childrenSubpart, true, false, absoluteCoordinates);
    }

    @Override
    public void applyStyle(IGraphicalEditPart rootEditPart) {
        this.applyFormat(rootEditPart, false, true, true);
    }

    protected void applyFormat(IGraphicalEditPart parentEditPart, List<IGraphicalEditPart> childrenSubpart, boolean applyLayout, boolean applyStyle, boolean absoluteCoordinates) {
        if (absoluteCoordinates) {
            for (IGraphicalEditPart child : childrenSubpart) {
                this.applyFormat(child, applyLayout, applyStyle, absoluteCoordinates);
            }
        } else if (childrenSubpart.stream().filter(ConnectionEditPart.class::isInstance).findFirst().isEmpty()) {
            ArrayList<AbstractDNode> dNodeChildren = new ArrayList<AbstractDNode>();
            for (IGraphicalEditPart child : childrenSubpart) {
                View toStoreView = (View)child.getModel();
                EObject semanticElement = child.resolveSemanticElement();
                if (!(toStoreView instanceof Node) || !(semanticElement instanceof AbstractDNode) || !(semanticElement instanceof DSemanticDecorator)) continue;
                dNodeChildren.add((AbstractDNode)semanticElement);
            }
            this.applyFormatOnChildrenForBoundingBox(dNodeChildren, parentEditPart.getRoot().getViewer(), null, applyLayout, applyStyle, Optional.empty());
        }
    }

    protected void applyFormat(IGraphicalEditPart rootEditPart, boolean applyLayout, boolean applyStyle, boolean absoluteCoordinates) {
        EObject semanticElement = rootEditPart.resolveSemanticElement();
        View toStoreView = (View)rootEditPart.getModel();
        if (!(toStoreView instanceof Edge)) {
            if (toStoreView instanceof Diagram && semanticElement instanceof DDiagram) {
                if (absoluteCoordinates) {
                    this.applyFormatAbsoluteMode((DDiagram)semanticElement, rootEditPart.getRoot().getViewer(), applyLayout, applyStyle);
                } else {
                    this.applyFormatBoundingBoxMode((DDiagram)semanticElement, rootEditPart.getRoot().getViewer(), applyLayout, applyStyle);
                }
                this.centerEdgesEnds(toStoreView);
            } else if (toStoreView instanceof Node) {
                if (semanticElement instanceof AbstractDNode && semanticElement instanceof DSemanticDecorator) {
                    if (absoluteCoordinates) {
                        this.applyFormatAbsoluteMode((DRepresentationElement)((AbstractDNode)semanticElement), (Node)toStoreView, rootEditPart.getRoot().getViewer(), null, applyLayout, applyStyle);
                    } else {
                        this.applyFormatOnChildrenForBoundingBox(Arrays.asList((AbstractDNode)semanticElement), rootEditPart.getRoot().getViewer(), null, applyLayout, applyStyle, Optional.empty());
                    }
                }
                this.centerEdgesEnds(toStoreView);
            }
        }
    }

    private void centerEdgesEnds(View view) {
        HashSet edges = new HashSet();
        if (view instanceof Diagram) {
            edges.addAll(((Diagram)view).getEdges());
        } else {
            ViewUtil.getAllRelatedEdgesForView((View)view, edges);
        }
        for (Edge edge : edges) {
            CenterEdgeEndModelChangeOperation centerEdgeEndModelChangeOperation = new CenterEdgeEndModelChangeOperation(edge, false);
            centerEdgeEndModelChangeOperation.execute();
        }
    }

    private void applyFormatAbsoluteMode(DDiagram diagram, EditPartViewer editPartViewer, boolean applyLayout, boolean applyStyle) {
        for (AbstractDNode node : Iterables.filter((Iterable)diagram.getOwnedDiagramElements(), AbstractDNode.class)) {
            Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)node);
            if (gmfNode == null) continue;
            this.applyFormatAbsoluteMode((DRepresentationElement)node, gmfNode, editPartViewer, null, applyLayout, applyStyle);
        }
    }

    private void applyFormatBoundingBoxMode(DDiagram diagram, EditPartViewer editPartViewer, boolean applyLayout, boolean applyStyle) {
        this.applyFormatOnChildrenForBoundingBox(Iterables.filter((Iterable)diagram.getOwnedDiagramElements(), AbstractDNode.class), editPartViewer, null, applyLayout, applyStyle, Optional.empty());
    }

    private void applyFormatOnChildrenForBoundingBox(Iterable<AbstractDNode> children, EditPartViewer editPartViewer, NodeFormatData parentFormatData, boolean applyLayout, boolean applyStyle, Optional<PrecisionDimension> parentDeltaBoundingBox) {
        HashMap<AbstractDNode, Optional> childrenWithFormatMap = new HashMap<AbstractDNode, Optional>();
        for (AbstractDNode node : children) {
            Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)node);
            if (gmfNode == null) continue;
            Optional<NodeFormatData> optionalFormat = this.getFormatData((DRepresentationElement)node, gmfNode, editPartViewer, null);
            childrenWithFormatMap.put(node, optionalFormat);
        }
        PrecisionDimension deltaBewteenBoundingBoxes = new PrecisionDimension();
        if (applyLayout && parentDeltaBoundingBox.isEmpty()) {
            PrecisionPoint absoluteOriginOfToPasteElements = new PrecisionPoint(Double.MAX_VALUE, Double.MAX_VALUE);
            PrecisionPoint absoluteOriginOfCopiedLayout = new PrecisionPoint(Double.MAX_VALUE, Double.MAX_VALUE);
            childrenWithFormatMap.forEach((dNode, formatData) -> {
                if (formatData.isPresent()) {
                    Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)dNode);
                    Object editPartAsObject = editPartViewer.getEditPartRegistry().get(gmfNode);
                    if (editPartAsObject instanceof IGraphicalEditPart) {
                        IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)editPartAsObject;
                        org.eclipse.draw2d.geometry.Point absoluteLocation = graphicalEditPart.getFigure().getBounds().getTopLeft().getCopy();
                        FigureUtilities.translateToAbsoluteByIgnoringScrollbar((IFigure)graphicalEditPart.getFigure(), (org.eclipse.draw2d.geometry.Point)absoluteLocation);
                        this.computeBoundingBoxTopLeftCorner(absoluteOriginOfToPasteElements, absoluteLocation);
                        Point absoluteCopiedLocationToApply = FormatDataHelper.INSTANCE.getAbsoluteLocation((NodeFormatData)formatData.get());
                        this.computeBoundingBoxTopLeftCorner(absoluteOriginOfCopiedLayout, (org.eclipse.draw2d.geometry.Point)new PrecisionPoint(absoluteCopiedLocationToApply.getX(), absoluteCopiedLocationToApply.getY()));
                    }
                }
            });
            deltaBewteenBoundingBoxes.expand(absoluteOriginOfToPasteElements.preciseX(), absoluteOriginOfToPasteElements.preciseY()).shrink(absoluteOriginOfCopiedLayout.preciseX(), absoluteOriginOfCopiedLayout.preciseY());
        }
        childrenWithFormatMap.forEach((dNode, formatData) -> {
            Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)dNode);
            if (applyLayout && formatData.isPresent()) {
                if (parentDeltaBoundingBox.isPresent()) {
                    this.applyLayout((DRepresentationElement)dNode, gmfNode, editPartViewer, (NodeFormatData)formatData.get(), parentDeltaBoundingBox);
                } else {
                    this.applyLayout((DRepresentationElement)dNode, gmfNode, editPartViewer, (NodeFormatData)formatData.get(), Optional.of(deltaBewteenBoundingBoxes));
                }
            }
            if (applyStyle && formatData.isPresent()) {
                this.applyStyle((DRepresentationElement)dNode, gmfNode, (NodeFormatData)formatData.get());
            }
            if (formatData.isPresent()) {
                if (parentDeltaBoundingBox.isPresent()) {
                    this.applyFormatOnChildrenAndOutgoingEdgesBoundingBoxMode((DRepresentationElement)dNode, editPartViewer, (NodeFormatData)formatData.get(), applyLayout, applyStyle, parentDeltaBoundingBox);
                } else {
                    this.applyFormatOnChildrenAndOutgoingEdgesBoundingBoxMode((DRepresentationElement)dNode, editPartViewer, (NodeFormatData)formatData.get(), applyLayout, applyStyle, Optional.of(deltaBewteenBoundingBoxes));
                }
            } else {
                this.applyFormatOnChildrenAndOutgoingEdgesBoundingBoxMode((DRepresentationElement)dNode, editPartViewer, null, applyLayout, applyStyle, Optional.empty());
            }
        });
    }

    private void computeBoundingBoxTopLeftCorner(PrecisionPoint boundingBoxTopLeftCorner, org.eclipse.draw2d.geometry.Point topLeftCornerOfAnElement) {
        if (boundingBoxTopLeftCorner.preciseX() > topLeftCornerOfAnElement.preciseX()) {
            boundingBoxTopLeftCorner.setPreciseX(topLeftCornerOfAnElement.preciseX());
        }
        if (boundingBoxTopLeftCorner.preciseY() > topLeftCornerOfAnElement.preciseY()) {
            boundingBoxTopLeftCorner.setPreciseY(topLeftCornerOfAnElement.preciseY());
        }
    }

    private void applyLayout(DRepresentationElement dRepresentationElement, Node toRestoreView, EditPartViewer editPartViewer, NodeFormatData formatData, Optional<PrecisionDimension> deltaBewteenBoundingBoxes) {
        Object editPartAsObject = editPartViewer.getEditPartRegistry().get(toRestoreView);
        if (formatData != null && editPartAsObject != null) {
            Point locationToApply;
            Bounds bounds = NotationFactory.eINSTANCE.createBounds();
            IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)editPartAsObject;
            boolean isCollapsed = false;
            if (graphicalEditPart instanceof AbstractDiagramBorderNodeEditPart) {
                locationToApply = FormatDataHelper.INSTANCE.getAbsoluteLocation(formatData);
                Node parentNode = (Node)toRestoreView.eContainer();
                CanonicalDBorderItemLocator locator = new CanonicalDBorderItemLocator(parentNode, 29);
                if (dRepresentationElement instanceof DDiagramElement) {
                    if (new DDiagramElementQuery((DDiagramElement)dRepresentationElement).isIndirectlyCollapsed()) {
                        isCollapsed = true;
                        locator.setBorderItemOffset(IBorderItemOffsets.COLLAPSE_FILTER_OFFSET);
                    } else {
                        locator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
                    }
                } else {
                    locator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
                }
                Rectangle rect = new Rectangle(locationToApply.getX(), locationToApply.getY(), formatData.getWidth(), formatData.getHeight());
                org.eclipse.draw2d.geometry.Point realLocation = locator.getValidLocation(rect, toRestoreView, new ArrayList<Node>(Arrays.asList(toRestoreView)));
                org.eclipse.draw2d.geometry.Point parentAbsoluteLocation = ((IGraphicalEditPart)graphicalEditPart.getParent()).getFigure().getBounds().getTopLeft().getCopy();
                FigureUtilities.translateToAbsoluteByIgnoringScrollbar((IFigure)((IGraphicalEditPart)graphicalEditPart.getParent()).getFigure(), (org.eclipse.draw2d.geometry.Point)parentAbsoluteLocation);
                locationToApply.setX(realLocation.x);
                locationToApply.setY(realLocation.y);
                locationToApply = FormatDataHelper.INSTANCE.getTranslated(locationToApply, parentAbsoluteLocation.negate());
            } else {
                locationToApply = FormatDataHelper.INSTANCE.getAbsoluteLocation(formatData);
                PrecisionPoint newLoc = new PrecisionPoint(locationToApply.getX(), locationToApply.getY());
                if (deltaBewteenBoundingBoxes.isPresent()) {
                    newLoc.translate((Dimension)deltaBewteenBoundingBoxes.get());
                }
                FigureUtilities.translateToRelativeByIgnoringScrollbar((IFigure)graphicalEditPart.getFigure(), (org.eclipse.draw2d.geometry.Point)newLoc);
                locationToApply.setX(newLoc.x());
                locationToApply.setY(newLoc.y());
                graphicalEditPart.getFigure().setLocation((org.eclipse.draw2d.geometry.Point)newLoc);
            }
            bounds.setX(locationToApply.getX());
            bounds.setY(locationToApply.getY());
            if (isCollapsed) {
                Dimension dim = new NodeQuery(toRestoreView).getCollapsedSize();
                bounds.setHeight(dim.height);
                bounds.setWidth(dim.width);
            } else {
                bounds.setHeight(formatData.getHeight());
                bounds.setWidth(formatData.getWidth());
            }
            toRestoreView.setLayoutConstraint((LayoutConstraint)bounds);
        }
    }

    private void applyStyle(DRepresentationElement dRepresentationElement, Node toRestoreView, NodeFormatData formatData) {
        if (formatData != null) {
            this.applySiriusStyle((DSemanticDecorator)dRepresentationElement, (AbstractFormatData)formatData);
            this.applyGMFStyle((View)toRestoreView, (AbstractFormatData)formatData);
        }
    }

    private void applyFormatOnChildrenAndOutgoingEdgesBoundingBoxMode(DRepresentationElement dRepresentationElement, EditPartViewer editPartViewer, NodeFormatData formatData, boolean applyLayout, boolean applyStyle, Optional<PrecisionDimension> parentDeltaBoundingBox) {
        if (dRepresentationElement instanceof DNode) {
            this.applyFormatToNodeChildren((DNode)dRepresentationElement, editPartViewer, formatData, applyLayout, applyStyle, parentDeltaBoundingBox);
        } else if (dRepresentationElement instanceof DNodeContainer) {
            this.applyFormatToNodeContainerChildrenBoundingBoxMode((DNodeContainer)dRepresentationElement, editPartViewer, formatData, applyLayout, applyStyle, parentDeltaBoundingBox);
        } else if (dRepresentationElement instanceof DNodeList) {
            this.applyFormatToNodeListChildren((DNodeList)dRepresentationElement, editPartViewer, formatData, applyLayout, applyStyle);
        } else {
            AbstractSiriusFormatDataManager.logUnhandledDiagramElementKindMessage(dRepresentationElement);
        }
        if (dRepresentationElement instanceof EdgeTarget) {
            this.applyFormatToOutgoingEdge((EdgeTarget)dRepresentationElement, editPartViewer, applyLayout, applyStyle);
        }
    }

    private void applyFormatToOutgoingEdge(EdgeTarget sourceNode, EditPartViewer editPartViewer, boolean applyLayout, boolean applyStyle) {
        for (DEdge edge : sourceNode.getOutgoingEdges()) {
            Edge gmfEdge = SiriusGMFHelper.getGmfEdge((DDiagramElement)edge);
            if (gmfEdge == null) continue;
            this.applyFormat(edge, gmfEdge, editPartViewer, applyLayout, applyStyle);
        }
    }

    private void applyFormat(DEdge edge, Edge gmfEdge, EditPartViewer editPartViewer, boolean applyLayout, boolean applyStyle) {
        Optional<EdgeFormatData> formatData = this.getFormatData(edge);
        if (formatData.isPresent()) {
            if (applyLayout) {
                this.applyEdgeFormat(gmfEdge, formatData.get());
            }
            if (applyStyle) {
                this.applySiriusStyle((DSemanticDecorator)edge, (AbstractFormatData)formatData.get());
                this.applyGMFStyle((View)gmfEdge, (AbstractFormatData)formatData.get());
            }
            this.applyLabelFormat((View)gmfEdge, (AbstractFormatData)formatData.get(), applyLayout, applyStyle);
        }
    }

    private void applyEdgeFormat(Edge gmfEdge, EdgeFormatData formatData) {
        RoutingStyle routingStyle;
        Bendpoints newBendpoints = this.convertPointsToGMFBendpoint(formatData);
        Bendpoints oldBendpoints = gmfEdge.getBendpoints();
        if (oldBendpoints instanceof RelativeBendpoints && newBendpoints instanceof RelativeBendpoints) {
            ((RelativeBendpoints)oldBendpoints).setPoints(((RelativeBendpoints)newBendpoints).getPoints());
        } else {
            gmfEdge.setBendpoints(newBendpoints);
        }
        if (formatData.getSourceTerminal() != null) {
            if (gmfEdge.getSourceAnchor() == null) {
                gmfEdge.setSourceAnchor((Anchor)NotationFactory.eINSTANCE.createIdentityAnchor());
            }
            if (gmfEdge.getSourceAnchor() instanceof IdentityAnchor) {
                ((IdentityAnchor)gmfEdge.getSourceAnchor()).setId(formatData.getSourceTerminal());
            }
        } else if (gmfEdge.getSourceAnchor() instanceof IdentityAnchor) {
            gmfEdge.setSourceAnchor(null);
        }
        if (formatData.getTargetTerminal() != null) {
            if (gmfEdge.getTargetAnchor() == null) {
                gmfEdge.setTargetAnchor((Anchor)NotationFactory.eINSTANCE.createIdentityAnchor());
            }
            if (gmfEdge.getTargetAnchor() instanceof IdentityAnchor) {
                ((IdentityAnchor)gmfEdge.getTargetAnchor()).setId(formatData.getTargetTerminal());
            }
        } else if (gmfEdge.getTargetAnchor() instanceof IdentityAnchor) {
            gmfEdge.setTargetAnchor(null);
        }
        if ((routingStyle = (RoutingStyle)gmfEdge.getStyle(NotationPackage.eINSTANCE.getRoutingStyle())) != null) {
            routingStyle.setRouting(Routing.get((int)formatData.getRouting()));
            routingStyle.setJumpLinkStatus(JumpLinkStatus.get((int)formatData.getJumpLinkStatus()));
            routingStyle.setJumpLinkType(JumpLinkType.get((int)formatData.getJumpLinkType()));
            routingStyle.setJumpLinksReverse(formatData.isReverseJumpLink());
            routingStyle.setSmoothness(Smoothness.get((int)formatData.getSmoothness()));
        }
    }

    private void applyLabelFormat(View gmfView, AbstractFormatData parentFormatData, boolean applyLayout, boolean applyStyle) {
        if (parentFormatData != null) {
            Node labelNode = SiriusGMFHelper.getLabelNode(gmfView);
            if (parentFormatData.getLabel() != null && labelNode != null) {
                if (applyLayout) {
                    if (!parentFormatData.getLabel().eIsSet((EStructuralFeature)FormatdataPackage.eINSTANCE.getNodeFormatData_Width()) && !parentFormatData.getLabel().eIsSet((EStructuralFeature)FormatdataPackage.eINSTANCE.getNodeFormatData_Height())) {
                        Location location = NotationFactory.eINSTANCE.createLocation();
                        location.setX(parentFormatData.getLabel().getLocation().getX());
                        location.setY(parentFormatData.getLabel().getLocation().getY());
                        labelNode.setLayoutConstraint((LayoutConstraint)location);
                    } else {
                        Bounds bounds = NotationFactory.eINSTANCE.createBounds();
                        bounds.setX(parentFormatData.getLabel().getLocation().getX());
                        bounds.setY(parentFormatData.getLabel().getLocation().getY());
                        bounds.setWidth(parentFormatData.getLabel().getWidth());
                        bounds.setHeight(parentFormatData.getLabel().getHeight());
                        labelNode.setLayoutConstraint((LayoutConstraint)bounds);
                    }
                }
                if (applyStyle) {
                    this.applyGMFStyle((View)labelNode, (AbstractFormatData)parentFormatData.getLabel());
                }
            }
        }
    }

    private Bendpoints convertPointsToGMFBendpoint(EdgeFormatData edgeFormatData) {
        RelativeBendpoints result = NotationFactory.eINSTANCE.createRelativeBendpoints();
        LinkedList<RelativeBendpoint> relativeBendpoints = new LinkedList<RelativeBendpoint>();
        Point source = edgeFormatData.getSourceRefPoint();
        Point target = edgeFormatData.getTargetRefPoint();
        if (source != null && target != null) {
            org.eclipse.draw2d.geometry.Point sourceRefPoint = new org.eclipse.draw2d.geometry.Point(source.getX(), source.getY());
            org.eclipse.draw2d.geometry.Point targetRefPoint = new org.eclipse.draw2d.geometry.Point(target.getX(), target.getY());
            for (Point point : edgeFormatData.getPointList()) {
                org.eclipse.draw2d.geometry.Point tempPoint = new org.eclipse.draw2d.geometry.Point(point.getX(), point.getY());
                Dimension s = tempPoint.getDifference(sourceRefPoint);
                Dimension t = tempPoint.getDifference(targetRefPoint);
                relativeBendpoints.add(new RelativeBendpoint(s.width, s.height, t.width, t.height));
            }
        }
        result.setPoints(relativeBendpoints);
        return result;
    }

    private Optional<NodeFormatData> getFormatData(DRepresentationElement dRepresentationElement, Node toRestoreView, EditPartViewer editPartViewer, NodeFormatData parentFormatData) {
        FormatDataKey key = this.createKey((DSemanticDecorator)dRepresentationElement);
        NodeFormatData formatData = (NodeFormatData)this.getFormatData(key, dRepresentationElement.getMapping());
        if (parentFormatData != null && parentFormatData == formatData && !StringUtil.isEmpty((String)key.getId())) {
            formatData = null;
            for (NodeFormatData childFormatData : parentFormatData.getChildren()) {
                if (!key.getId().equals(childFormatData.getId())) continue;
                if (formatData == null) {
                    formatData = childFormatData;
                    continue;
                }
                formatData = null;
                break;
            }
        }
        return Optional.ofNullable(formatData);
    }

    private Optional<EdgeFormatData> getFormatData(DEdge edge) {
        return Optional.ofNullable((EdgeFormatData)this.getFormatData(this.createKey((DSemanticDecorator)edge), edge.getMapping()));
    }

    private void applyFormatAbsoluteMode(DRepresentationElement dRepresentationElement, Node toRestoreView, EditPartViewer editPartViewer, NodeFormatData parentFormatData, boolean applyLayout, boolean applyStyle) {
        FormatDataKey key = this.createKey((DSemanticDecorator)dRepresentationElement);
        NodeFormatData formatData = (NodeFormatData)this.getFormatData(key, dRepresentationElement.getMapping());
        if (parentFormatData != null && parentFormatData == formatData && !StringUtil.isEmpty((String)key.getId())) {
            formatData = null;
            for (NodeFormatData childFormatData : parentFormatData.getChildren()) {
                if (!key.getId().equals(childFormatData.getId())) continue;
                if (formatData == null) {
                    formatData = childFormatData;
                    continue;
                }
                formatData = null;
                break;
            }
        }
        Object editPartAsObject = editPartViewer.getEditPartRegistry().get(toRestoreView);
        if (formatData != null && applyLayout && editPartAsObject != null) {
            Point locationToApply;
            Bounds bounds = NotationFactory.eINSTANCE.createBounds();
            IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)editPartAsObject;
            boolean isCollapsed = false;
            if (graphicalEditPart instanceof AbstractDiagramBorderNodeEditPart) {
                locationToApply = FormatDataHelper.INSTANCE.getAbsoluteLocation(formatData);
                Node parentNode = (Node)toRestoreView.eContainer();
                CanonicalDBorderItemLocator locator = new CanonicalDBorderItemLocator(parentNode, 29);
                if (dRepresentationElement instanceof DDiagramElement) {
                    if (new DDiagramElementQuery((DDiagramElement)dRepresentationElement).isIndirectlyCollapsed()) {
                        isCollapsed = true;
                        locator.setBorderItemOffset(IBorderItemOffsets.COLLAPSE_FILTER_OFFSET);
                    } else {
                        locator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
                    }
                } else {
                    locator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
                }
                Rectangle rect = new Rectangle(locationToApply.getX(), locationToApply.getY(), formatData.getWidth(), formatData.getHeight());
                org.eclipse.draw2d.geometry.Point realLocation = locator.getValidLocation(rect, toRestoreView, new ArrayList<Node>(Arrays.asList(toRestoreView)));
                org.eclipse.draw2d.geometry.Point parentAbsoluteLocation = ((IGraphicalEditPart)graphicalEditPart.getParent()).getFigure().getBounds().getTopLeft().getCopy();
                FigureUtilities.translateToAbsoluteByIgnoringScrollbar((IFigure)((IGraphicalEditPart)graphicalEditPart.getParent()).getFigure(), (org.eclipse.draw2d.geometry.Point)parentAbsoluteLocation);
                locationToApply.setX(realLocation.x);
                locationToApply.setY(realLocation.y);
                locationToApply = FormatDataHelper.INSTANCE.getTranslated(locationToApply, parentAbsoluteLocation.negate());
            } else {
                locationToApply = FormatDataHelper.INSTANCE.getRelativeLocation(formatData, graphicalEditPart);
                graphicalEditPart.getFigure().setLocation(new org.eclipse.draw2d.geometry.Point(locationToApply.getX(), locationToApply.getY()));
            }
            bounds.setX(locationToApply.getX());
            bounds.setY(locationToApply.getY());
            if (isCollapsed) {
                Dimension dim = new NodeQuery(toRestoreView).getCollapsedSize();
                bounds.setHeight(dim.height);
                bounds.setWidth(dim.width);
            } else {
                bounds.setHeight(formatData.getHeight());
                bounds.setWidth(formatData.getWidth());
            }
            toRestoreView.setLayoutConstraint((LayoutConstraint)bounds);
        }
        if (formatData != null && applyStyle) {
            this.applySiriusStyle((DSemanticDecorator)dRepresentationElement, (AbstractFormatData)formatData);
            this.applyGMFStyle((View)toRestoreView, (AbstractFormatData)formatData);
        }
        if (dRepresentationElement instanceof DNode) {
            this.applyFormatToNodeChildren((DNode)dRepresentationElement, editPartViewer, formatData, applyLayout, applyStyle, Optional.empty());
        } else if (dRepresentationElement instanceof DNodeContainer) {
            this.applyFormatToNodeContainerChildrenAbsoluteMode((DNodeContainer)dRepresentationElement, editPartViewer, formatData, applyLayout, applyStyle);
        } else if (dRepresentationElement instanceof DNodeList) {
            this.applyFormatToNodeListChildren((DNodeList)dRepresentationElement, editPartViewer, formatData, applyLayout, applyStyle);
        } else {
            AbstractSiriusFormatDataManager.logUnhandledDiagramElementKindMessage(dRepresentationElement);
        }
        if (dRepresentationElement instanceof EdgeTarget) {
            this.applyFormatToOutgoingEdge((EdgeTarget)dRepresentationElement, editPartViewer, applyLayout, applyStyle);
        }
    }

    protected void applySiriusStyle(DSemanticDecorator semanticDecorator, AbstractFormatData formatData) {
        this.applySiriusStyle(semanticDecorator, formatData.getSiriusStyle());
    }

    protected void applyGMFStyle(View newView, AbstractFormatData formatData) {
        if (newView != null && formatData.getGmfView() != null && (!(formatData.getSiriusStyle() instanceof EdgeStyle) || newView.getElement() instanceof DEdge)) {
            ArrayList<EClass> excludedStyles = new ArrayList<EClass>();
            if (newView instanceof Edge) {
                excludedStyles.add(NotationPackage.eINSTANCE.getRoutingStyle());
            }
            new ViewRefactorHelper().copyViewAppearance(formatData.getGmfView(), newView, excludedStyles);
        }
    }

    public static void logUnhandledDiagramElementKindMessage(Object notManagedObject) {
        Class<?> clazz = notManagedObject.getClass();
        boolean logWarn = true;
        Class<?>[] classArray = CLASS_EXCEPTIONS;
        int n = CLASS_EXCEPTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> exceptionClass = classArray[n2];
            if (exceptionClass.isAssignableFrom(clazz)) {
                logWarn = false;
                break;
            }
            ++n2;
        }
        if (logWarn) {
            DiagramPlugin.getDefault().logWarning(MessageFormat.format(Messages.AbstractSiriusLayoutDataManager_unhandledDiagramElementKind, clazz.getName()));
        }
    }

    private void applyFormatToNodeChildren(DNode parentNode, EditPartViewer editPartViewer, NodeFormatData formatData, boolean applyLayout, boolean applyStyle, Optional<PrecisionDimension> parentDeltaBoundingBox) {
        this.applyFormatForBorderedNodes((EList<DNode>)parentNode.getOwnedBorderedNodes(), editPartViewer, formatData, applyLayout, applyStyle, parentDeltaBoundingBox);
        Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)parentNode);
        this.applyLabelFormat((View)gmfNode, (AbstractFormatData)formatData, applyLayout, applyStyle);
    }

    private void applyFormatToNodeContainerChildrenAbsoluteMode(DNodeContainer container, EditPartViewer editPartViewer, NodeFormatData formatData, boolean applyLayout, boolean applyStyle) {
        for (DDiagramElement child : container.getOwnedDiagramElements()) {
            Node gmfNode;
            if (!(child instanceof AbstractDNode) || (gmfNode = SiriusGMFHelper.getGmfNode(child)) == null) continue;
            this.applyFormatAbsoluteMode((DRepresentationElement)child, gmfNode, editPartViewer, formatData, applyLayout, applyStyle);
        }
        this.applyFormatForBorderedNodes((EList<DNode>)container.getOwnedBorderedNodes(), editPartViewer, formatData, applyLayout, applyStyle, Optional.empty());
        Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)container);
        this.applyLabelFormat((View)gmfNode, (AbstractFormatData)formatData, applyLayout, applyStyle);
    }

    private void applyFormatToNodeContainerChildrenBoundingBoxMode(DNodeContainer container, EditPartViewer editPartViewer, NodeFormatData formatData, boolean applyLayout, boolean applyStyle, Optional<PrecisionDimension> parentDeltaBoundingBox) {
        this.applyFormatOnChildrenForBoundingBox(Iterables.filter((Iterable)container.getOwnedDiagramElements(), AbstractDNode.class), editPartViewer, formatData, applyLayout, applyStyle, parentDeltaBoundingBox);
        this.applyFormatForBorderedNodes((EList<DNode>)container.getOwnedBorderedNodes(), editPartViewer, formatData, applyLayout, applyStyle, parentDeltaBoundingBox);
        Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)container);
        this.applyLabelFormat((View)gmfNode, (AbstractFormatData)formatData, applyLayout, applyStyle);
    }

    private void applyFormatForBorderedNodes(EList<DNode> borderedNodes, EditPartViewer editPartViewer, NodeFormatData parentFormatData, boolean applyLayout, boolean applyStyle, Optional<PrecisionDimension> parentShift) {
        HashMap<Node, NodeFormatData> nodesWithFormatDataToApply = new HashMap<Node, NodeFormatData>();
        HashMap<Node, DNode> nodesWithCoresspondingDSemanticDecorator = new HashMap<Node, DNode>();
        for (DNode child : borderedNodes) {
            Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)child);
            if (gmfNode == null) continue;
            FormatDataKey key = this.createKey((DSemanticDecorator)child);
            NodeFormatData formatData = (NodeFormatData)this.getFormatData(key, child.getMapping());
            if (parentFormatData != null && parentFormatData == formatData && !StringUtil.isEmpty((String)key.getId())) {
                formatData = null;
                for (NodeFormatData childFormatData : parentFormatData.getChildren()) {
                    if (!key.getId().equals(childFormatData.getId())) continue;
                    if (formatData == null) {
                        formatData = childFormatData;
                        continue;
                    }
                    formatData = null;
                    break;
                }
            }
            if (formatData == null) continue;
            nodesWithFormatDataToApply.put(gmfNode, formatData);
            nodesWithCoresspondingDSemanticDecorator.put(gmfNode, child);
        }
        Set<Node> toIgnore = nodesWithFormatDataToApply.keySet();
        for (Map.Entry entry : nodesWithFormatDataToApply.entrySet()) {
            Node node = (Node)entry.getKey();
            this.applyFormatForBorderedNode((DSemanticDecorator)nodesWithCoresspondingDSemanticDecorator.get(node), node, editPartViewer, (NodeFormatData)entry.getValue(), toIgnore, applyLayout, applyStyle, parentShift);
        }
    }

    private void applyFormatForBorderedNode(DSemanticDecorator semanticDecorator, Node toRestoreView, EditPartViewer editPartViewer, NodeFormatData formatData, Set<Node> portsNodesToIgnore, boolean applyLayout, boolean applyStyle, Optional<PrecisionDimension> parentShift) {
        if (applyLayout) {
            Point locationToApply;
            Bounds bounds = NotationFactory.eINSTANCE.createBounds();
            boolean isCollapsed = false;
            if (!(toRestoreView.eContainer() instanceof Node)) {
                return;
            }
            Node parentNode = (Node)toRestoreView.eContainer();
            Object parentGraphicalEditPart = editPartViewer.getEditPartRegistry().get(parentNode);
            NodeQuery nodeQuery = new NodeQuery(toRestoreView);
            if (nodeQuery.isBorderedNode() && parentGraphicalEditPart instanceof IGraphicalEditPart) {
                locationToApply = FormatDataHelper.INSTANCE.getAbsoluteLocation(formatData);
                CanonicalDBorderItemLocator locator = new CanonicalDBorderItemLocator(parentNode, 29);
                if (semanticDecorator instanceof DDiagramElement) {
                    if (new DDiagramElementQuery((DDiagramElement)semanticDecorator).isIndirectlyCollapsed()) {
                        isCollapsed = true;
                        locator.setBorderItemOffset(IBorderItemOffsets.COLLAPSE_FILTER_OFFSET);
                    } else {
                        locator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
                    }
                } else {
                    locator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
                }
                Rectangle rect = new Rectangle(locationToApply.getX(), locationToApply.getY(), formatData.getWidth(), formatData.getHeight());
                if (parentShift.isPresent()) {
                    rect.translate(parentShift.get().preciseWidth(), parentShift.get().preciseHeight());
                }
                org.eclipse.draw2d.geometry.Point realLocation = locator.getValidLocation(rect, toRestoreView, portsNodesToIgnore);
                org.eclipse.draw2d.geometry.Point parentAbsoluteLocation = GMFHelper.getAbsoluteBounds(parentNode, true, false, false, false).getTopLeft();
                locationToApply.setX(realLocation.x);
                locationToApply.setY(realLocation.y);
                locationToApply = FormatDataHelper.INSTANCE.getTranslated(locationToApply, parentAbsoluteLocation.negate());
            } else {
                Object graphicalEditPart = editPartViewer.getEditPartRegistry().get(toRestoreView);
                if (graphicalEditPart instanceof IGraphicalEditPart) {
                    locationToApply = FormatDataHelper.INSTANCE.getRelativeLocation(formatData, (IGraphicalEditPart)graphicalEditPart);
                    ((GraphicalEditPart)graphicalEditPart).getFigure().setLocation(new org.eclipse.draw2d.geometry.Point(locationToApply.getX(), locationToApply.getY()));
                } else {
                    locationToApply = FormatdataFactory.eINSTANCE.createPoint();
                }
            }
            bounds.setX(locationToApply.getX());
            bounds.setY(locationToApply.getY());
            if (isCollapsed) {
                Dimension dim = new NodeQuery(toRestoreView).getCollapsedSize();
                bounds.setHeight(dim.height);
                bounds.setWidth(dim.width);
            } else {
                bounds.setHeight(formatData.getHeight());
                bounds.setWidth(formatData.getWidth());
            }
            toRestoreView.setLayoutConstraint((LayoutConstraint)bounds);
        }
        if (applyStyle) {
            this.applySiriusStyle(semanticDecorator, (AbstractFormatData)formatData);
            this.applyGMFStyle((View)toRestoreView, (AbstractFormatData)formatData);
        }
        if (semanticDecorator instanceof DNode) {
            this.applyFormatToNodeChildren((DNode)semanticDecorator, editPartViewer, formatData, applyLayout, applyStyle, Optional.empty());
        } else {
            AbstractSiriusFormatDataManager.logUnhandledDiagramElementKindMessage(semanticDecorator);
        }
        if (semanticDecorator instanceof EdgeTarget) {
            this.applyFormatToOutgoingEdge((EdgeTarget)semanticDecorator, editPartViewer, applyLayout, applyStyle);
        }
    }

    private void applyFormatToNodeListChildren(DNodeList nodeList, EditPartViewer editPartViewer, NodeFormatData formatData, boolean applyLayout, boolean applyStyle) {
        this.applyFormatForBorderedNodes((EList<DNode>)nodeList.getOwnedBorderedNodes(), editPartViewer, formatData, applyLayout, applyStyle, Optional.empty());
        Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)nodeList);
        this.applyLabelFormat((View)gmfNode, (AbstractFormatData)formatData, applyLayout, applyStyle);
    }

    protected void addNodeChildren(DNode parentNode, NodeFormatData parentFormatData, IGraphicalEditPart parentEditPart, View gmfView, Collection<FormatDataKey> discoveredKeys) {
        for (DNode child : parentNode.getOwnedBorderedNodes()) {
            this.checkDataAndAddChildFormat(parentFormatData, (AbstractDNode)child, parentEditPart, discoveredKeys);
        }
        this.addLabelFormatData((AbstractFormatData)parentFormatData, gmfView);
    }

    protected void checkDataAndAddChildFormat(NodeFormatData parentFormatData, AbstractDNode child, IGraphicalEditPart parentSavedEditPart, Collection<FormatDataKey> discoveredKeys) {
        IGraphicalEditPart editPart;
        Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)child);
        if (gmfNode != null && (editPart = (IGraphicalEditPart)parentSavedEditPart.getRoot().getViewer().getEditPartRegistry().get(gmfNode)) != null) {
            this.addChildFormat(parentFormatData, (DRepresentationElement)child, gmfNode, editPart, discoveredKeys);
        }
    }

    protected void addNodeContainerChildren(DNodeContainer container, NodeFormatData parentFormatData, IGraphicalEditPart parentEditPart, Collection<FormatDataKey> discoveredKeys) {
        for (DDiagramElement child : container.getOwnedDiagramElements()) {
            if (!(child instanceof AbstractDNode)) continue;
            this.checkDataAndAddChildFormat(parentFormatData, (AbstractDNode)child, parentEditPart, discoveredKeys);
        }
        for (DDiagramElement child : container.getOwnedBorderedNodes()) {
            this.checkDataAndAddChildFormat(parentFormatData, (AbstractDNode)child, parentEditPart, discoveredKeys);
        }
    }

    protected void addNodeListChildren(DNodeList nodeList, NodeFormatData parentFormatData, IGraphicalEditPart parentEditPart, Collection<FormatDataKey> discoveredKeys) {
        for (DNode child : nodeList.getOwnedBorderedNodes()) {
            this.checkDataAndAddChildFormat(parentFormatData, (AbstractDNode)child, parentEditPart, discoveredKeys);
        }
    }

    private void addChildFormat(DDiagram diagram, IGraphicalEditPart diagramEditPart, Collection<FormatDataKey> discoveredKeys) {
        for (AbstractDNode child : Iterables.filter((Iterable)diagram.getOwnedDiagramElements(), AbstractDNode.class)) {
            IGraphicalEditPart editPart;
            Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)child);
            if (gmfNode == null || (editPart = (IGraphicalEditPart)diagramEditPart.getRoot().getViewer().getEditPartRegistry().get(gmfNode)) == null) continue;
            this.addChildFormat(null, (DRepresentationElement)child, gmfNode, editPart, discoveredKeys);
        }
    }

    private void addChildFormat(NodeFormatData parentFormatData, DRepresentationElement child, Node gmfNode, IGraphicalEditPart editPart, Collection<FormatDataKey> discoveredKeys) {
        NodeFormatData childFormatData = FormatDataHelper.INSTANCE.createNodeFormatData(gmfNode, editPart, parentFormatData);
        if (parentFormatData != null) {
            parentFormatData.getChildren().add((Object)childFormatData);
        }
        FormatDataKey childKey = this.createKey((DSemanticDecorator)child);
        childFormatData.setId(childKey.getId());
        if (!discoveredKeys.contains(childKey)) {
            this.addFormatData(childKey, child.getMapping(), (AbstractFormatData)childFormatData);
            discoveredKeys.add(childKey);
        } else if (parentFormatData == null) {
            this.addFormatData(childKey, child.getMapping(), (AbstractFormatData)childFormatData);
        }
        if (child instanceof DNode) {
            this.addNodeChildren((DNode)child, childFormatData, editPart, (View)gmfNode, discoveredKeys);
        } else if (child instanceof DNodeContainer) {
            this.addNodeContainerChildren((DNodeContainer)child, childFormatData, editPart, discoveredKeys);
        } else if (child instanceof DNodeList) {
            this.addNodeListChildren((DNodeList)child, childFormatData, editPart, discoveredKeys);
        } else {
            AbstractSiriusFormatDataManager.logUnhandledDiagramElementKindMessage(child);
        }
        if (child instanceof EdgeTarget) {
            this.addOutgoingEdge(childFormatData, (EdgeTarget)child, editPart.getRoot().getViewer());
        }
    }

    protected void addOutgoingEdge(NodeFormatData parentFormatData, EdgeTarget sourceOfEdge, EditPartViewer editPartViewer) {
        for (DEdge outgoingEdge : sourceOfEdge.getOutgoingEdges()) {
            this.addEdgeFormatData(parentFormatData, outgoingEdge, editPartViewer);
        }
    }

    protected void addEdgeFormatData(NodeFormatData parentFormatData, DEdge edge, EditPartViewer editPartViewer) {
        Edge gmfEdge = SiriusGMFHelper.getGmfEdge((DDiagramElement)edge);
        if (gmfEdge != null) {
            EdgeFormatData edgeFormatData = FormatDataHelper.INSTANCE.createEdgeFormatData(gmfEdge, (ConnectionEditPart)editPartViewer.getEditPartRegistry().get(gmfEdge));
            if (parentFormatData != null) {
                parentFormatData.getOutgoingEdges().add((Object)edgeFormatData);
            }
            FormatDataKey edgeKey = this.createKey((DSemanticDecorator)edge);
            edgeFormatData.setId(edgeKey.getId());
            this.addFormatData(edgeKey, edge.getMapping(), (AbstractFormatData)edgeFormatData);
            this.addLabelFormatData((AbstractFormatData)edgeFormatData, (View)gmfEdge);
        }
    }

    private void addLabelFormatData(AbstractFormatData parentFormatData, View gmfElement) {
        Node labelNode = SiriusGMFHelper.getLabelNode(gmfElement);
        if (labelNode != null && parentFormatData != null) {
            NodeFormatData labelFormatData = FormatDataHelper.INSTANCE.createLabelFormatData(labelNode);
            if (labelNode.getElement() instanceof DSemanticDecorator) {
                labelFormatData.setId(this.createKey((DSemanticDecorator)labelNode.getElement()).getId());
            }
            parentFormatData.setLabel(labelFormatData);
        }
    }
}

