/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions;

import java.util.List;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.CodeActionFactory;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DTDDeclParameter;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionRequest;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class OpenQuoteExpectedCodeAction
implements ICodeActionParticipant {
    @Override
    public void doCodeAction(ICodeActionRequest request, List<CodeAction> codeActions, CancelChecker cancelChecker) {
        int offset;
        Diagnostic diagnostic = request.getDiagnostic();
        DOMDocument document = request.getDocument();
        Range diagnosticRange = diagnostic.getRange();
        try {
            offset = document.offsetAt(diagnosticRange.getEnd());
        }
        catch (BadLocationException e) {
            return;
        }
        DOMAttr attr = document.findAttrAt(offset);
        if (attr != null && attr.isAttribute()) {
            OpenQuoteExpectedCodeAction.insertQuotationForAttr(attr, document, request, diagnostic, codeActions);
        } else {
            DTDDeclParameter parameter = document.findDTDDeclParameterAt(offset);
            if (parameter != null) {
                // empty if block
            }
        }
    }

    private static void insertQuotationForAttr(DOMNode attr, DOMDocument document, ICodeActionRequest request, Diagnostic diagnostic, List<CodeAction> codeActions) {
        Position codeactionPosition;
        SharedSettings sharedSettings = request.getSharedSettings();
        String q = sharedSettings.getPreferences().getQuotationAsString();
        Position possibleEndPosition = null;
        String possibleValue = null;
        try {
            DOMAttr nextAttr;
            codeactionPosition = document.positionAt(attr.getEnd());
            DOMNode next = attr.getNextSibling();
            if (next instanceof DOMAttr && !(nextAttr = (DOMAttr)next).hasDelimiter()) {
                possibleEndPosition = document.positionAt(nextAttr.getEnd());
                possibleValue = nextAttr.getName();
            }
        }
        catch (BadLocationException e) {
            return;
        }
        CodeAction removeContentAction = possibleEndPosition != null && possibleValue != null ? CodeActionFactory.replace("Insert quotations", new Range(codeactionPosition, possibleEndPosition), q + possibleValue + q, document.getTextDocument(), diagnostic) : CodeActionFactory.insert("Insert quotations", codeactionPosition, q + q, document.getTextDocument(), diagnostic);
        codeActions.add(removeContentAction);
    }

    private static void insertQuotationForParameter(DTDDeclParameter parameter, DOMDocument document, ICodeActionRequest request, Diagnostic diagnostic, List<CodeAction> codeActions) {
        SharedSettings sharedSettings = request.getSharedSettings();
        String q = sharedSettings.getPreferences().getQuotationAsString();
        CodeAction insertQuotationsAction = CodeActionFactory.replace("Insert quotations", parameter.getTargetRange(), q + parameter.getParameter() + q, document.getTextDocument(), diagnostic);
        codeActions.add(insertQuotationsAction);
    }
}

