/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ui.commands;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.internal.wikitext.ui.util.IOUtil;
import org.eclipse.mylyn.wikitext.parser.util.MarkupToDocbook;
import org.eclipse.mylyn.wikitext.ui.commands.AbstractMarkupResourceHandler;
import org.eclipse.mylyn.wikitext.ui.commands.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ConvertMarkupToDocbook
extends AbstractMarkupResourceHandler {
    @Override
    protected void handleFile(IFile file, String name) {
        IFile newFile = file.getParent().getFile((IPath)new Path(name + ".xml"));
        if (newFile.exists() && !MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ConvertMarkupToDocbook_overwrite, (String)NLS.bind((String)Messages.ConvertMarkupToDocbook_fileExistsOverwrite, (Object[])new Object[]{newFile.getFullPath()}))) {
            return;
        }
        MarkupToDocbook markupToDocbook = new MarkupToDocbook();
        markupToDocbook.setMarkupLanguage(this.markupLanguage);
        markupToDocbook.setBookTitle(name);
        try {
            IRunnableWithProgress runnable = monitor -> {
                try {
                    String content = IOUtil.readFully(file);
                    String docbook = markupToDocbook.parse(content);
                    if (newFile.exists()) {
                        newFile.setContents((InputStream)new ByteArrayInputStream(docbook.getBytes(StandardCharsets.UTF_8)), false, true, monitor);
                    } else {
                        newFile.create((InputStream)new ByteArrayInputStream(docbook.getBytes(StandardCharsets.UTF_8)), false, monitor);
                    }
                    newFile.setCharset("utf-8", monitor);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
            }
            catch (InterruptedException e) {
                return;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (Throwable e) {
            StringWriter message = new StringWriter();
            Throwable throwable = null;
            Object var8_12 = null;
            try (PrintWriter out = new PrintWriter(message);){
                out.println(Messages.ConvertMarkupToDocbook_cannotConvert + e.getMessage());
                out.println(Messages.ConvertMarkupToDocbook_detailsFollow);
                e.printStackTrace(out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ConvertMarkupToDocbook_cannotCompleteOperation, (String)message.toString());
        }
    }
}

