/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.Logger;

public enum PHPSymbolicLinksCache {
    INSTANCE;

    private final Set<IResource> cache = new HashSet<IResource>();

    void startup() {
        new StartupJob().schedule();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ResourceListener(), 1);
    }

    private synchronized void initialize() {
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    ResourceAttributes attributes = resource.getResourceAttributes();
                    if (attributes != null && attributes.isSymbolicLink()) {
                        PHPSymbolicLinksCache.this.cache.add(resource);
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
    }

    private synchronized void addResource(IResource resource) {
        this.cache.add(resource);
    }

    private synchronized void removeResource(IResource resource) {
        this.cache.remove(resource);
    }

    public synchronized boolean isSymbolicLink(IResource resource) {
        return this.cache.contains(resource);
    }

    private final class ResourceListener
    implements IResourceChangeListener {
        private ResourceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            final ArrayList<IResource> added = new ArrayList<IResource>();
            final ArrayList<IResource> removed = new ArrayList<IResource>();
            try {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        if (resource != null) {
                            if (delta.getKind() == 1) {
                                added.add(resource);
                            } else if (delta.getKind() == 2) {
                                removed.add(resource);
                            }
                        }
                        return true;
                    }
                }, 3);
                if (!added.isEmpty()) {
                    new UpdaterJob().perform(1, added);
                }
                if (!removed.isEmpty()) {
                    new UpdaterJob().perform(2, removed);
                }
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
    }

    private final class StartupJob
    extends Job {
        public StartupJob() {
            super(CoreMessages.getString("PHPSymbolicLinksCache_Initializing_symbolic_links_cache"));
            this.setSystem(true);
            this.setUser(false);
            this.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().refreshRule((IResource)ResourcesPlugin.getWorkspace().getRoot()));
        }

        protected IStatus run(IProgressMonitor monitor) {
            PHPSymbolicLinksCache.this.initialize();
            return Status.OK_STATUS;
        }
    }

    private final class UpdaterJob
    extends Job {
        static final int ADDITION = 1;
        static final int REMOVAL = 2;
        private int kind;
        private List<IResource> resources;

        public UpdaterJob() {
            super(CoreMessages.getString("PHPSymbolicLinksCache_Updating_symbolic_links_cache"));
            this.setSystem(true);
            this.setUser(false);
        }

        protected IStatus run(IProgressMonitor monitor) {
            switch (this.kind) {
                case 1: {
                    for (IResource resource : this.resources) {
                        ResourceAttributes attributes = resource.getResourceAttributes();
                        if (attributes == null || !attributes.isSymbolicLink()) continue;
                        PHPSymbolicLinksCache.this.addResource(resource);
                    }
                    break;
                }
                case 2: {
                    for (IResource resource : this.resources) {
                        if (!PHPSymbolicLinksCache.this.isSymbolicLink(resource)) continue;
                        PHPSymbolicLinksCache.this.removeResource(resource);
                    }
                    break;
                }
            }
            return Status.OK_STATUS;
        }

        void perform(int kind, List<IResource> resources) {
            this.kind = kind;
            this.resources = resources;
            this.schedule();
        }
    }
}

