/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hprof.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import jdk.test.lib.hprof.model.ReachableExcludes;

public class ReachableExcludesImpl
implements ReachableExcludes {
    private File excludesFile;
    private long lastModified;
    private Hashtable<String, String> methods;

    public ReachableExcludesImpl(File excludesFile) {
        this.excludesFile = excludesFile;
        this.readFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFileIfNeeded() {
        if (this.excludesFile.lastModified() != this.lastModified) {
            ReachableExcludesImpl reachableExcludesImpl = this;
            synchronized (reachableExcludesImpl) {
                if (this.excludesFile.lastModified() != this.lastModified) {
                    this.readFile();
                }
            }
        }
    }

    private void readFile() {
        long lm = this.excludesFile.lastModified();
        Hashtable<String, String> m = new Hashtable<String, String>();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(this.excludesFile)));){
            String method;
            while ((method = r.readLine()) != null) {
                m.put(method, method);
            }
            this.lastModified = lm;
            this.methods = m;
        }
        catch (IOException ex) {
            System.out.println("Error reading " + String.valueOf(this.excludesFile) + ":  " + String.valueOf(ex));
        }
    }

    @Override
    public boolean isExcluded(String fieldName) {
        this.readFileIfNeeded();
        return this.methods.get(fieldName) != null;
    }
}

