/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.internal.codeassist.DOMCompletionUtils;
import org.eclipse.jdt.internal.compiler.parser.JavadocTagConstants;

class DOMCompletionEngineJavadocUtil {
    private static final List<char[]> JAVA_8_BLOCK_TAGS;
    private static final List<char[]> JAVA_9_BLOCK_TAGS;
    private static final List<char[]> JAVA_8_INLINE_TAGS;
    private static final List<char[]> JAVA_9_INLINE_TAGS;
    private static final List<char[]> JAVA_10_INLINE_TAGS;
    private static final List<char[]> JAVA_12_INLINE_TAGS;
    private static final List<char[]> JAVA_16_INLINE_TAGS;
    private static final List<char[]> JAVA_18_INLINE_TAGS;
    private static final Set<char[]> FIELD_TAGS_SET;
    private static final Set<char[]> CLASS_TAGS_SET;
    private static final Set<char[]> METHOD_TAGS_SET;
    private static final Set<char[]> PACKAGE_TAGS_SET;

    DOMCompletionEngineJavadocUtil() {
    }

    public static List<char[]> getJavadocBlockTags(IJavaProject project, TagElement tagNode, ASTNode nodeSearchNode) {
        String projectVersion = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        List<char[]> tagsForVersion = projectVersion.contains(".") || Integer.parseInt(projectVersion) < 9 ? JAVA_8_BLOCK_TAGS : JAVA_9_BLOCK_TAGS;
        return DOMCompletionEngineJavadocUtil.tagsForNode(tagsForVersion, tagNode, nodeSearchNode);
    }

    public static List<char[]> getJavadocInlineTags(IJavaProject project, TagElement tagNode, ASTNode nodeSearchNode) {
        int versionNumber;
        String projectVersion = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        List<char[]> tagsForVersion = projectVersion.contains(".") ? JAVA_8_INLINE_TAGS : ((versionNumber = Integer.parseInt(projectVersion)) < 9 ? JAVA_8_INLINE_TAGS : (versionNumber < 10 ? JAVA_9_INLINE_TAGS : (versionNumber < 12 ? JAVA_10_INLINE_TAGS : (versionNumber < 16 ? JAVA_12_INLINE_TAGS : (versionNumber < 18 ? JAVA_16_INLINE_TAGS : JAVA_18_INLINE_TAGS)))));
        return DOMCompletionEngineJavadocUtil.tagsForNode(tagsForVersion, tagNode, nodeSearchNode);
    }

    private static List<char[]> tagsForNode(List<char[]> tagsForVersion, TagElement tagNode, ASTNode nodeSearchNode) {
        Javadoc javadoc;
        boolean isUnparented;
        boolean isPackage;
        boolean isType;
        boolean isMethod;
        boolean isField;
        boolean bl = isField = DOMCompletionUtils.findParent((ASTNode)tagNode, new int[]{23}) != null;
        if (isField) {
            return tagsForVersion.stream().filter(tag -> FIELD_TAGS_SET.contains(tag)).toList();
        }
        ASTNode astNode = DOMCompletionUtils.findParent((ASTNode)tagNode, new int[]{31, 55, 71, 103, 81, 56});
        boolean bl2 = isMethod = astNode != null && astNode.getNodeType() == 31;
        if (isMethod) {
            return tagsForVersion.stream().filter(tag -> METHOD_TAGS_SET.contains(tag)).toList();
        }
        boolean bl3 = isType = astNode != null;
        if (isType) {
            return tagsForVersion.stream().filter(tag -> CLASS_TAGS_SET.contains(tag)).filter(tag -> {
                if (JavadocTagConstants.TAG_PARAM.equals(tag)) {
                    return ((AbstractTypeDeclaration)astNode).resolveBinding().isGenericType();
                }
                return true;
            }).toList();
        }
        boolean bl4 = isPackage = DOMCompletionUtils.findParent((ASTNode)tagNode, new int[]{35}) != null;
        if (isPackage) {
            return tagsForVersion.stream().filter(tag -> PACKAGE_TAGS_SET.contains(tag)).toList();
        }
        ASTNode aSTNode = DOMCompletionUtils.findParent((ASTNode)tagNode, new int[]{29});
        boolean bl5 = isUnparented = aSTNode instanceof Javadoc && (javadoc = (Javadoc)aSTNode).getParent() == null;
        if (isUnparented) {
            boolean onlyClassTags = DOMCompletionUtils.findParentTypeDeclaration(nodeSearchNode) == null;
            return tagsForVersion.stream().filter(tag -> !onlyClassTags || CLASS_TAGS_SET.contains(tag)).toList();
        }
        throw new IllegalStateException("I was expecting one of the above nodes to be documented");
    }

    static {
        char[] entry;
        int n;
        JAVA_8_BLOCK_TAGS = new ArrayList<char[]>();
        for (int i = 0; i < 4; ++i) {
            char[][] cArray = JavadocTagConstants.BLOCK_TAGS_RAW[i].tags();
            n = cArray.length;
            for (int j = 0; j < n; ++j) {
                entry = cArray[j];
                JAVA_8_BLOCK_TAGS.add(entry);
            }
        }
        JAVA_9_BLOCK_TAGS = new ArrayList<char[]>();
        JAVA_9_BLOCK_TAGS.addAll(JAVA_8_BLOCK_TAGS);
        char[][] i = JavadocTagConstants.BLOCK_TAGS_RAW[4].tags();
        int n2 = i.length;
        for (n = 0; n < n2; ++n) {
            char[] entry2 = i[n];
            JAVA_9_BLOCK_TAGS.add(entry2);
        }
        JAVA_8_INLINE_TAGS = new ArrayList<char[]>();
        for (int i2 = 0; i2 < 4; ++i2) {
            char[][] cArray = JavadocTagConstants.INLINE_TAGS_RAW[i2].tags();
            n = cArray.length;
            for (int entry2 = 0; entry2 < n; ++entry2) {
                entry = cArray[entry2];
                JAVA_8_INLINE_TAGS.add(entry);
            }
        }
        JAVA_9_INLINE_TAGS = new ArrayList<char[]>();
        JAVA_9_INLINE_TAGS.addAll(JAVA_8_INLINE_TAGS);
        for (char[] entry3 : JavadocTagConstants.INLINE_TAGS_RAW[4].tags()) {
            JAVA_9_INLINE_TAGS.add(entry3);
        }
        JAVA_10_INLINE_TAGS = new ArrayList<char[]>();
        JAVA_10_INLINE_TAGS.addAll(JAVA_9_INLINE_TAGS);
        for (char[] entry4 : JavadocTagConstants.INLINE_TAGS_RAW[5].tags()) {
            JAVA_10_INLINE_TAGS.add(entry4);
        }
        JAVA_12_INLINE_TAGS = new ArrayList<char[]>();
        JAVA_12_INLINE_TAGS.addAll(JAVA_10_INLINE_TAGS);
        for (char[] entry5 : JavadocTagConstants.INLINE_TAGS_RAW[6].tags()) {
            JAVA_12_INLINE_TAGS.add(entry5);
        }
        JAVA_16_INLINE_TAGS = new ArrayList<char[]>();
        JAVA_16_INLINE_TAGS.addAll(JAVA_12_INLINE_TAGS);
        for (char[] entry6 : JavadocTagConstants.INLINE_TAGS_RAW[7].tags()) {
            JAVA_16_INLINE_TAGS.add(entry6);
        }
        JAVA_18_INLINE_TAGS = new ArrayList<char[]>();
        JAVA_18_INLINE_TAGS.addAll(JAVA_16_INLINE_TAGS);
        for (char[] entry7 : JavadocTagConstants.INLINE_TAGS_RAW[8].tags()) {
            JAVA_18_INLINE_TAGS.add(entry7);
        }
        FIELD_TAGS_SET = Stream.of(JavadocTagConstants.FIELD_TAGS).collect(Collectors.toSet());
        CLASS_TAGS_SET = Stream.of(JavadocTagConstants.CLASS_TAGS).collect(Collectors.toSet());
        METHOD_TAGS_SET = Stream.of(JavadocTagConstants.METHOD_TAGS).collect(Collectors.toSet());
        PACKAGE_TAGS_SET = Stream.of(JavadocTagConstants.PACKAGE_TAGS).collect(Collectors.toSet());
    }
}

