/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.junit.jupiter.api.AssertionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.opentest4j.AssertionFailedError;

@API(status=API.Status.STABLE, since="5.9")
public class AssertionFailureBuilder {
    private Object message;
    private Throwable cause;
    private boolean mismatch;
    private Object expected;
    private Object actual;
    private String reason;
    private boolean includeValuesInMessage = true;

    public static AssertionFailureBuilder assertionFailure() {
        return new AssertionFailureBuilder();
    }

    private AssertionFailureBuilder() {
    }

    public AssertionFailureBuilder message(Object message) {
        this.message = message;
        return this;
    }

    public AssertionFailureBuilder reason(String reason) {
        this.reason = reason;
        return this;
    }

    public AssertionFailureBuilder cause(Throwable cause) {
        this.cause = cause;
        return this;
    }

    public AssertionFailureBuilder expected(Object expected) {
        this.mismatch = true;
        this.expected = expected;
        return this;
    }

    public AssertionFailureBuilder actual(Object actual) {
        this.mismatch = true;
        this.actual = actual;
        return this;
    }

    public AssertionFailureBuilder includeValuesInMessage(boolean includeValuesInMessage) {
        this.includeValuesInMessage = includeValuesInMessage;
        return this;
    }

    public void buildAndThrow() throws AssertionFailedError {
        throw this.build();
    }

    public AssertionFailedError build() {
        String reason = AssertionFailureBuilder.nullSafeGet(this.reason);
        if (this.mismatch && this.includeValuesInMessage) {
            reason = (reason == null ? "" : reason + ", ") + AssertionFailureBuilder.formatValues(this.expected, this.actual);
        }
        String message = AssertionFailureBuilder.nullSafeGet(this.message);
        if (reason != null) {
            message = AssertionFailureBuilder.buildPrefix(message) + reason;
        }
        return this.mismatch ? new AssertionFailedError(message, this.expected, this.actual, this.cause) : new AssertionFailedError(message, this.cause);
    }

    private static String nullSafeGet(Object messageOrSupplier) {
        if (messageOrSupplier == null) {
            return null;
        }
        if (messageOrSupplier instanceof Supplier) {
            Object message = ((Supplier)messageOrSupplier).get();
            return StringUtils.nullSafeToString(message);
        }
        return StringUtils.nullSafeToString((Object)messageOrSupplier);
    }

    private static String buildPrefix(String message) {
        return StringUtils.isNotBlank((String)message) ? message + " ==> " : "";
    }

    private static String formatValues(Object expected, Object actual) {
        String actualString;
        String expectedString = AssertionFailureBuilder.toString(expected);
        if (expectedString.equals(actualString = AssertionFailureBuilder.toString(actual))) {
            return String.format("expected: %s but was: %s", AssertionFailureBuilder.formatClassAndValue(expected, expectedString), AssertionFailureBuilder.formatClassAndValue(actual, actualString));
        }
        return String.format("expected: <%s> but was: <%s>", expectedString, actualString);
    }

    private static String formatClassAndValue(Object value, String valueString) {
        if (value == null) {
            return "<null>";
        }
        String classAndHash = AssertionFailureBuilder.getClassName(value) + AssertionFailureBuilder.toHash(value);
        return value instanceof Class ? "<" + classAndHash + ">" : classAndHash + "<" + valueString + ">";
    }

    private static String toString(Object obj) {
        if (obj instanceof Class) {
            return AssertionUtils.getCanonicalName((Class)obj);
        }
        return StringUtils.nullSafeToString((Object)obj);
    }

    private static String toHash(Object obj) {
        return obj == null ? "" : "@" + Integer.toHexString(System.identityHashCode(obj));
    }

    private static String getClassName(Object obj) {
        return obj == null ? "null" : (obj instanceof Class ? AssertionUtils.getCanonicalName((Class)obj) : obj.getClass().getName());
    }
}

