/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.preferences.PersistentModel;
import org.eclipse.buildship.core.internal.util.gradle.GradleVersion;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.manipulation.ChangeCorrectionProposalCore;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.commands.ProjectCommand;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.ProposalKindWrapper;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;
import org.eclipse.jdt.ls.core.internal.managers.GradleUtils;
import org.eclipse.jdt.ls.core.internal.text.correction.CUCorrectionCommandProposal;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class GradleCompatibilityProcessor {
    private static String UPGRADE_GRADLE_COMMAND_ADVANCED = "java.project.upgradeGradle.command";
    private static String UPGRADE_GRADLE_COMMAND = "java.project.upgradeGradle";

    public static void getGradleCompatibilityProposals(IInvocationContext context, IProblemLocation problem, Collection<ProposalKindWrapper> proposals) {
        IJavaProject javaProject = context.getCompilationUnit().getJavaProject();
        if (javaProject == null) {
            return;
        }
        IProject project = javaProject.getProject();
        if (!ProjectUtils.isGradleProject(project)) {
            return;
        }
        PersistentModel model = CorePlugin.modelPersistence().loadModel(project);
        if (!model.isPresent()) {
            return;
        }
        GradleVersion gradleVersion = model.getGradleVersion();
        if (gradleVersion != null && gradleVersion.compareTo(GradleVersion.version((String)GradleUtils.JPMS_SUPPORTED_VERSION)) < 0) {
            IResource resource = javaProject.getResource();
            if (resource == null) {
                return;
            }
            URI uri = resource.getLocationURI();
            if (uri == null) {
                return;
            }
            try {
                ProjectCommand.ClasspathResult result = ProjectCommand.getClasspathsFromJavaProject(javaProject, new ProjectCommand.ClasspathOptions());
                IModuleDescription moduleDescription = javaProject.getModuleDescription();
                if (moduleDescription == null) {
                    GradleCompatibilityProcessor.addProposalForNonModulerProject(result, context, uri, proposals);
                } else {
                    GradleCompatibilityProcessor.addProposalForModulerProject(javaProject, result, context, uri, proposals);
                }
            }
            catch (URISyntaxException | CoreException e) {
                return;
            }
        }
    }

    private static void addProposalForNonModulerProject(ProjectCommand.ClasspathResult result, IInvocationContext context, URI uri, Collection<ProposalKindWrapper> proposals) {
        if (result.modulepaths.length > 0) {
            GradleCompatibilityProcessor.addProposal(context, uri, proposals);
        }
    }

    private static void addProposalForModulerProject(IJavaProject javaProject, ProjectCommand.ClasspathResult result, IInvocationContext context, URI uri, Collection<ProposalKindWrapper> proposals) {
        String[] stringArray = result.classpaths;
        int n = result.classpaths.length;
        int n2 = 0;
        while (n2 < n) {
            String classpath = stringArray[n2];
            try {
                IPackageFragmentRoot packageFragmentRoot = javaProject.findPackageFragmentRoot((IPath)new Path(classpath));
                if (packageFragmentRoot instanceof JarPackageFragmentRoot) {
                    IModuleDescription jarModuleDescription = ((JarPackageFragmentRoot)packageFragmentRoot).getModuleDescription();
                    if (jarModuleDescription == null) {
                        jarModuleDescription = ((JarPackageFragmentRoot)packageFragmentRoot).getAutomaticModuleDescription();
                    }
                    if (jarModuleDescription != null) {
                        GradleCompatibilityProcessor.addProposal(context, uri, proposals);
                        break;
                    }
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
    }

    private static void addProposal(IInvocationContext context, URI uri, Collection<ProposalKindWrapper> proposals) {
        String cmdId = JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isAdvancedUpgradeGradleSupport() ? UPGRADE_GRADLE_COMMAND_ADVANCED : UPGRADE_GRADLE_COMMAND;
        CUCorrectionCommandProposal c = new CUCorrectionCommandProposal(CorrectionMessages.NotAccessibleType_upgrade_Gradle_label, context.getCompilationUnit(), 5, cmdId, Arrays.asList(uri.toString(), GradleUtils.JPMS_SUPPORTED_VERSION));
        proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)c, "quickfix"));
    }
}

