/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.javadoc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreJavaDocLocations;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.javadoc.SourceJarLocations;

public class JavaDocHTMLPathHandler {
    public static final IPath EXTRACTED_JAR_IMAGES_FOLDER = JavaLanguageServerPlugin.getInstance().getStateLocation().append("extracted-jar-images/");
    public static final String[] tags = new String[]{"img"};
    public static final Pattern p = Pattern.compile("(src\\s*=\\s*['\"])");

    public static boolean containsHTMLTag(String text) {
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            if (text.contains("<" + tag)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getValidatedHTMLSrcAttribute(TextElement child, IJavaElement fElement) {
        String string;
        IPath absoluteFragmentPath;
        File absoluteFragmentFile;
        String text = child.getText();
        int[] offsets = JavaDocHTMLPathHandler.extractSourcePathFromHTMLTag(text);
        if (offsets == null) {
            return text;
        }
        String srcPath = text.substring(offsets[0], offsets[1]);
        if (JavaDocHTMLPathHandler.isPathAbsolute(srcPath)) {
            return text;
        }
        String fileName = Paths.get(srcPath, new String[0]).getFileName().toString();
        IPackageFragment internalJarFragment = (IPackageFragment)fElement.getAncestor(4);
        if (internalJarFragment == null) {
            return text;
        }
        IResource fragmentResource = internalJarFragment.getResource();
        if (fragmentResource != null && (absoluteFragmentFile = new File((absoluteFragmentPath = fragmentResource.getLocation()).toPortableString() + "/" + srcPath)).exists()) {
            String uriString = ResourceUtils.fixURI(absoluteFragmentFile.toURI()).toString();
            return text.substring(0, offsets[0]) + uriString + text.substring(offsets[1]);
        }
        String fragmentName = internalJarFragment.getElementName();
        if (fragmentName == null || fragmentName.length() < 1) {
            return text;
        }
        CharSequence[] names = fragmentName.split("\\.");
        String fragmentPath = String.join((CharSequence)"/", names) + "/";
        srcPath = srcPath.replace('\\', '/');
        String filePathRelativeToJar = fragmentPath + srcPath;
        InputStream is = null;
        ZipFile jar = null;
        try {
            URI javadocJarBaseLocationURI;
            File currentJarPath = null;
            ZipEntry currentZipEntry = null;
            URL javadocJarBaseLocationURL = CoreJavaDocLocations.getJavadocBaseLocation((IJavaElement)internalJarFragment);
            if (javadocJarBaseLocationURL != null && (currentJarPath = JavaDocHTMLPathHandler.getJarPathFromURI(javadocJarBaseLocationURI = javadocJarBaseLocationURL.toURI())) != null) {
                jar = new JarFile(currentJarPath);
                currentZipEntry = ((JarFile)jar).getEntry(filePathRelativeToJar);
            }
            if (currentZipEntry == null && (currentJarPath = SourceJarLocations.getSourceJarPath((IJavaElement)internalJarFragment)) != null) {
                jar = new JarFile(currentJarPath);
                currentZipEntry = ((JarFile)jar).getEntry(filePathRelativeToJar);
            }
            if (jar == null || currentZipEntry == null) {
                String string2 = text;
                return string2;
            }
            Object jarRootName = internalJarFragment.getAncestor(3).getElementName();
            if (((String)jarRootName).endsWith(".jar")) {
                jarRootName = ((String)jarRootName).substring(0, ((String)jarRootName).length() - 4);
            }
            jarRootName = (String)jarRootName + "/";
            IPath newOutputPath = EXTRACTED_JAR_IMAGES_FOLDER.append((String)jarRootName);
            File outputFile = (newOutputPath = newOutputPath.append(fileName)).toFile();
            if (!outputFile.exists()) {
                is = ((JarFile)jar).getInputStream(currentZipEntry);
                JavaDocHTMLPathHandler.extractFileTo(is, outputFile);
            } else {
                BasicFileAttributes existingOutputFileAttributes = Files.readAttributes(outputFile.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                FileTime existingFileCreationTime = existingOutputFileAttributes.creationTime();
                BasicFileAttributes jarOutputFileAttributes = Files.readAttributes(currentJarPath.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                FileTime jarFileCreationTime = jarOutputFileAttributes.creationTime();
                if (jarFileCreationTime.compareTo(existingFileCreationTime) > 0) {
                    is = ((JarFile)jar).getInputStream(currentZipEntry);
                    JavaDocHTMLPathHandler.extractFileTo(is, outputFile);
                }
            }
            string = text.substring(0, offsets[0]) + ResourceUtils.fixURI(outputFile.toURI()).toString() + text.substring(offsets[1]);
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException("Failed to extract path from embedded jar with error message:", e);
            String string3 = text;
            return string3;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string;
    }

    public static int[] extractSourcePathFromHTMLTag(String text) {
        Matcher m = p.matcher(text);
        if (m.find()) {
            int srcStartQuote = m.end();
            char quote = text.charAt(srcStartQuote - 1);
            int srcEndQuote = text.indexOf(quote, srcStartQuote);
            int[] offsets = new int[]{srcStartQuote, srcEndQuote};
            return offsets;
        }
        return null;
    }

    public static File getJarPathFromURI(URI uri) {
        String pathWithScheme = uri.getSchemeSpecificPart();
        String finalJarRootPath = pathWithScheme.substring(pathWithScheme.indexOf(58) + 1);
        int actualJarIndex = finalJarRootPath.lastIndexOf(".jar");
        if (actualJarIndex == -1) {
            return null;
        }
        return new File(finalJarRootPath.substring(0, actualJarIndex + 4));
    }

    public static boolean isPathAbsolute(String path) {
        block5: {
            block4: {
                try {
                    URI uri = new URI(path);
                    if (!uri.isAbsolute()) break block4;
                    return true;
                }
                catch (URISyntaxException e) {
                    return false;
                }
            }
            File f = new File(path);
            if (!f.isAbsolute()) break block5;
            return true;
        }
        return path.startsWith("/");
    }

    private static boolean extractFileTo(InputStream fileToExtract, File pathToExtractTo) {
        try {
            pathToExtractTo.getParentFile().mkdirs();
            Files.copy(fileToExtract, pathToExtractTo.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (IOException e) {
            JavaLanguageServerPlugin.logException("Failed to extract file with error message: ", e);
            return false;
        }
    }
}

