/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.gradle.model.impl;

import com.microsoft.java.bs.gradle.model.BuildTargetDependency;
import com.microsoft.java.bs.gradle.model.GradleModuleDependency;
import com.microsoft.java.bs.gradle.model.GradleSourceSet;
import com.microsoft.java.bs.gradle.model.LanguageExtension;
import com.microsoft.java.bs.gradle.model.impl.DefaultBuildTargetDependency;
import com.microsoft.java.bs.gradle.model.impl.DefaultGradleModuleDependency;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultGradleSourceSet
implements GradleSourceSet {
    private static final long serialVersionUID = 1L;
    private String gradleVersion;
    private String displayName;
    private String projectName;
    private String projectPath;
    private File projectDir;
    private File rootDir;
    private String sourceSetName;
    private String classesTaskName;
    private String cleanTaskName;
    private Set<String> taskNames;
    private Set<File> sourceDirs;
    private Set<File> generatedSourceDirs;
    private Set<File> sourceOutputDirs;
    private Set<File> resourceDirs;
    private Set<File> resourceOutputDirs;
    private Map<File, List<File>> archiveOutputFiles;
    private List<File> compileClasspath;
    private Set<GradleModuleDependency> moduleDependencies;
    private Set<BuildTargetDependency> buildTargetDependencies;
    private boolean hasTests;
    private Map<String, LanguageExtension> extensions;

    public DefaultGradleSourceSet() {
    }

    public DefaultGradleSourceSet(GradleSourceSet gradleSourceSet) {
        this.gradleVersion = gradleSourceSet.getGradleVersion();
        this.displayName = gradleSourceSet.getDisplayName();
        this.projectName = gradleSourceSet.getProjectName();
        this.projectPath = gradleSourceSet.getProjectPath();
        this.projectDir = gradleSourceSet.getProjectDir();
        this.rootDir = gradleSourceSet.getRootDir();
        this.sourceSetName = gradleSourceSet.getSourceSetName();
        this.classesTaskName = gradleSourceSet.getClassesTaskName();
        this.cleanTaskName = gradleSourceSet.getCleanTaskName();
        this.taskNames = gradleSourceSet.getTaskNames();
        this.sourceDirs = gradleSourceSet.getSourceDirs();
        this.generatedSourceDirs = gradleSourceSet.getGeneratedSourceDirs();
        this.sourceOutputDirs = gradleSourceSet.getSourceOutputDirs();
        this.resourceDirs = gradleSourceSet.getResourceDirs();
        this.resourceOutputDirs = gradleSourceSet.getResourceOutputDirs();
        this.archiveOutputFiles = gradleSourceSet.getArchiveOutputFiles();
        this.compileClasspath = gradleSourceSet.getCompileClasspath();
        this.moduleDependencies = gradleSourceSet.getModuleDependencies().stream().map(DefaultGradleModuleDependency::new).collect(Collectors.toSet());
        this.buildTargetDependencies = gradleSourceSet.getBuildTargetDependencies().stream().map(DefaultBuildTargetDependency::new).collect(Collectors.toSet());
        this.hasTests = gradleSourceSet.hasTests();
        this.extensions = gradleSourceSet.getExtensions().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.convertLanguageExtension((LanguageExtension)e.getValue())));
    }

    private LanguageExtension convertLanguageExtension(LanguageExtension object) {
        if (object.isJavaExtension()) {
            return object.getAsJavaExtension();
        }
        if (object.isScalaExtension()) {
            return object.getAsScalaExtension();
        }
        throw new IllegalArgumentException("No conversion methods defined for object: " + object);
    }

    @Override
    public String getGradleVersion() {
        return this.gradleVersion;
    }

    public void setGradleVersion(String gradleVersion) {
        this.gradleVersion = gradleVersion;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    @Override
    public File getProjectDir() {
        return this.projectDir;
    }

    public void setProjectDir(File projectDir) {
        this.projectDir = projectDir;
    }

    @Override
    public File getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(File rootDir) {
        this.rootDir = rootDir;
    }

    @Override
    public String getSourceSetName() {
        return this.sourceSetName;
    }

    public void setSourceSetName(String sourceSetName) {
        this.sourceSetName = sourceSetName;
    }

    @Override
    public String getClassesTaskName() {
        return this.classesTaskName;
    }

    public void setClassesTaskName(String classesTaskName) {
        this.classesTaskName = classesTaskName;
    }

    @Override
    public String getCleanTaskName() {
        return this.cleanTaskName;
    }

    public void setCleanTaskName(String cleanTaskName) {
        this.cleanTaskName = cleanTaskName;
    }

    public void setTaskNames(Set<String> taskNames) {
        this.taskNames = taskNames;
    }

    @Override
    public Set<String> getTaskNames() {
        return this.taskNames;
    }

    @Override
    public Set<File> getSourceDirs() {
        return this.sourceDirs;
    }

    public void setSourceDirs(Set<File> sourceDirs) {
        this.sourceDirs = sourceDirs;
    }

    @Override
    public Set<File> getGeneratedSourceDirs() {
        return this.generatedSourceDirs;
    }

    public void setGeneratedSourceDirs(Set<File> generatedSourceDirs) {
        this.generatedSourceDirs = generatedSourceDirs;
    }

    @Override
    public Set<File> getSourceOutputDirs() {
        return this.sourceOutputDirs;
    }

    public void setSourceOutputDirs(Set<File> sourceOutputDirs) {
        this.sourceOutputDirs = sourceOutputDirs;
    }

    @Override
    public Set<File> getResourceDirs() {
        return this.resourceDirs;
    }

    public void setResourceDirs(Set<File> resourceDirs) {
        this.resourceDirs = resourceDirs;
    }

    @Override
    public Set<File> getResourceOutputDirs() {
        return this.resourceOutputDirs;
    }

    public void setResourceOutputDirs(Set<File> resourceOutputDirs) {
        this.resourceOutputDirs = resourceOutputDirs;
    }

    @Override
    public Map<File, List<File>> getArchiveOutputFiles() {
        return this.archiveOutputFiles;
    }

    public void setArchiveOutputFiles(Map<File, List<File>> archiveOutputFiles) {
        this.archiveOutputFiles = archiveOutputFiles;
    }

    @Override
    public List<File> getCompileClasspath() {
        return this.compileClasspath;
    }

    public void setCompileClasspath(List<File> compileClasspath) {
        this.compileClasspath = compileClasspath;
    }

    @Override
    public Set<GradleModuleDependency> getModuleDependencies() {
        return this.moduleDependencies;
    }

    public void setModuleDependencies(Set<GradleModuleDependency> moduleDependencies) {
        this.moduleDependencies = moduleDependencies;
    }

    @Override
    public Set<BuildTargetDependency> getBuildTargetDependencies() {
        return this.buildTargetDependencies;
    }

    public void setBuildTargetDependencies(Set<BuildTargetDependency> buildTargetDependencies) {
        this.buildTargetDependencies = buildTargetDependencies;
    }

    @Override
    public boolean hasTests() {
        return this.hasTests;
    }

    public void setHasTests(boolean hasTests) {
        this.hasTests = hasTests;
    }

    @Override
    public Map<String, LanguageExtension> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map<String, LanguageExtension> extensions) {
        this.extensions = extensions;
    }

    public int hashCode() {
        return Objects.hash(this.gradleVersion, this.displayName, this.projectName, this.projectPath, this.projectDir, this.rootDir, this.sourceSetName, this.classesTaskName, this.cleanTaskName, this.taskNames, this.sourceDirs, this.generatedSourceDirs, this.sourceOutputDirs, this.resourceDirs, this.resourceOutputDirs, this.archiveOutputFiles, this.compileClasspath, this.moduleDependencies, this.buildTargetDependencies, this.hasTests, this.extensions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultGradleSourceSet other = (DefaultGradleSourceSet)obj;
        return Objects.equals(this.gradleVersion, other.gradleVersion) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.projectName, other.projectName) && Objects.equals(this.projectPath, other.projectPath) && Objects.equals(this.projectDir, other.projectDir) && Objects.equals(this.rootDir, other.rootDir) && Objects.equals(this.sourceSetName, other.sourceSetName) && Objects.equals(this.classesTaskName, other.classesTaskName) && Objects.equals(this.cleanTaskName, other.cleanTaskName) && Objects.equals(this.taskNames, other.taskNames) && Objects.equals(this.sourceDirs, other.sourceDirs) && Objects.equals(this.generatedSourceDirs, other.generatedSourceDirs) && Objects.equals(this.sourceOutputDirs, other.sourceOutputDirs) && Objects.equals(this.resourceDirs, other.resourceDirs) && Objects.equals(this.resourceOutputDirs, other.resourceOutputDirs) && Objects.equals(this.archiveOutputFiles, other.archiveOutputFiles) && Objects.equals(this.compileClasspath, other.compileClasspath) && Objects.equals(this.moduleDependencies, other.moduleDependencies) && Objects.equals(this.buildTargetDependencies, other.buildTargetDependencies) && this.hasTests == other.hasTests && Objects.equals(this.extensions, other.extensions);
    }
}

