/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

public class RefactoringScopeFactory {
    private static void addReferencingProjects(IJavaProject focus, Set<IJavaProject> projects) throws JavaModelException {
        IProject[] iProjectArray = focus.getProject().getReferencingProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry;
            IProject referencingProject = iProjectArray[n2];
            IJavaProject candidate = JavaCore.create((IProject)referencingProject);
            if (candidate != null && !projects.contains(candidate) && candidate.exists() && (entry = RefactoringScopeFactory.getReferencingClassPathEntry(candidate, focus)) != null) {
                projects.add(candidate);
                if (entry.isExported()) {
                    RefactoringScopeFactory.addReferencingProjects(candidate, projects);
                }
            }
            ++n2;
        }
    }

    private static void addRelatedReferencing(IJavaProject focus, Set<IJavaProject> projects) throws CoreException {
        IProject[] iProjectArray = focus.getProject().getReferencingProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry;
            IProject referencingProject = iProjectArray[n2];
            IJavaProject candidate = JavaCore.create((IProject)referencingProject);
            if (candidate != null && !projects.contains(candidate) && candidate.exists() && (entry = RefactoringScopeFactory.getReferencingClassPathEntry(candidate, focus)) != null) {
                projects.add(candidate);
                if (entry.isExported()) {
                    RefactoringScopeFactory.addRelatedReferencing(candidate, projects);
                    RefactoringScopeFactory.addRelatedReferenced(candidate, projects);
                }
            }
            ++n2;
        }
    }

    private static void addRelatedReferenced(IJavaProject focus, Set<IJavaProject> projects) throws CoreException {
        IProject[] iProjectArray = focus.getProject().getReferencedProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry;
            IProject referencedProject = iProjectArray[n2];
            IJavaProject candidate = JavaCore.create((IProject)referencedProject);
            if (candidate != null && !projects.contains(candidate) && candidate.exists() && (entry = RefactoringScopeFactory.getReferencingClassPathEntry(focus, candidate)) != null) {
                projects.add(candidate);
                if (entry.isExported()) {
                    RefactoringScopeFactory.addRelatedReferenced(candidate, projects);
                    RefactoringScopeFactory.addRelatedReferencing(candidate, projects);
                }
            }
            ++n2;
        }
    }

    public static IJavaSearchScope create(IJavaElement javaElement) throws JavaModelException {
        return RefactoringScopeFactory.create(javaElement, true, true);
    }

    public static IJavaSearchScope create(IJavaElement javaElement, boolean considerVisibility) throws JavaModelException {
        return RefactoringScopeFactory.create(javaElement, considerVisibility, true);
    }

    public static IJavaSearchScope create(IJavaElement javaElement, boolean considerVisibility, boolean sourceReferencesOnly) throws JavaModelException {
        IMember member;
        if (considerVisibility && javaElement instanceof IMember && JdtFlags.isPrivate(member = (IMember)javaElement)) {
            if (member.getCompilationUnit() != null) {
                return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{member.getCompilationUnit()});
            }
            return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{member});
        }
        IJavaProject javaProject = javaElement.getJavaProject();
        return SearchEngine.createJavaSearchScope((IJavaElement[])RefactoringScopeFactory.getAllScopeElements(javaProject, sourceReferencesOnly), (boolean)false);
    }

    public static IJavaSearchScope create(IMember[] members) throws JavaModelException {
        return RefactoringScopeFactory.create(members, true);
    }

    public static IJavaSearchScope create(IMember[] members, boolean sourceReferencesOnly) throws JavaModelException {
        Assert.isTrue((members != null && members.length > 0 ? 1 : 0) != 0);
        IMember candidate = members[0];
        int visibility = RefactoringScopeFactory.getVisibility(candidate);
        int i = 1;
        while (i < members.length) {
            int mv = RefactoringScopeFactory.getVisibility(members[i]);
            if (mv > visibility) {
                visibility = mv;
                candidate = members[i];
            }
            ++i;
        }
        return RefactoringScopeFactory.create((IJavaElement)candidate, true, sourceReferencesOnly);
    }

    public static IJavaSearchScope createProjectsScope(IMember[] members, boolean sourceReferencesOnly) throws JavaModelException {
        Assert.isTrue((members != null && members.length > 0 ? 1 : 0) != 0);
        LinkedHashSet<IPackageFragmentRoot> scopeElements = new LinkedHashSet<IPackageFragmentRoot>();
        IMember[] iMemberArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IMember member = iMemberArray[n2];
            IJavaProject javaProject = member.getJavaProject();
            IPackageFragmentRoot[] projectScopeElements = RefactoringScopeFactory.getAllScopeElements(javaProject, sourceReferencesOnly);
            scopeElements.addAll(Arrays.asList(projectScopeElements));
            ++n2;
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])((IJavaElement[])scopeElements.toArray(IJavaElement[]::new)), (boolean)false);
    }

    public static IJavaSearchScope createReferencedScope(IJavaElement[] javaElements) {
        HashSet<IJavaProject> projects = new HashSet<IJavaProject>();
        IJavaElement[] iJavaElementArray = javaElements;
        int n = javaElements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement javaElement = iJavaElementArray[n2];
            projects.add(javaElement.getJavaProject());
            ++n2;
        }
        IJavaProject[] prj = projects.toArray(new IJavaProject[projects.size()]);
        return SearchEngine.createJavaSearchScope((IJavaElement[])prj, (boolean)true);
    }

    public static IJavaSearchScope createReferencedScope(IJavaElement[] javaElements, int includeMask) {
        HashSet<IJavaProject> projects = new HashSet<IJavaProject>();
        IJavaElement[] iJavaElementArray = javaElements;
        int n = javaElements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement javaElement = iJavaElementArray[n2];
            projects.add(javaElement.getJavaProject());
            ++n2;
        }
        IJavaProject[] prj = projects.toArray(new IJavaProject[projects.size()]);
        return SearchEngine.createJavaSearchScope((IJavaElement[])prj, (int)includeMask);
    }

    public static IJavaSearchScope createRelatedProjectsScope(IJavaProject project, int includeMask) throws CoreException {
        IJavaProject[] projects = RefactoringScopeFactory.getRelatedProjects(project);
        return SearchEngine.createJavaSearchScope((IJavaElement[])projects, (int)includeMask);
    }

    private static IPackageFragmentRoot[] getAllScopeElements(IJavaProject project, boolean onlySourceRoots) throws JavaModelException {
        ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>();
        for (IJavaProject javaProject : RefactoringScopeFactory.getReferencingProjects(project)) {
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (!onlySourceRoots || root.getKind() == 1) {
                    result.add(root);
                }
                ++n2;
            }
        }
        return result.toArray(new IPackageFragmentRoot[result.size()]);
    }

    private static IClasspathEntry getReferencingClassPathEntry(IJavaProject referencingProject, IJavaProject referencedProject) throws JavaModelException {
        IClasspathEntry result = null;
        IPath path = referencedProject.getProject().getFullPath();
        IClasspathEntry[] iClasspathEntryArray = referencingProject.getResolvedClasspath(true);
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 2 && path.equals((Object)entry.getPath())) {
                if (entry.isExported()) {
                    return entry;
                }
                result = entry;
            }
            ++n2;
        }
        return result;
    }

    private static IJavaProject[] getRelatedProjects(IJavaProject focus) throws CoreException {
        HashSet<IJavaProject> projects = new HashSet<IJavaProject>();
        RefactoringScopeFactory.addRelatedReferencing(focus, projects);
        RefactoringScopeFactory.addRelatedReferenced(focus, projects);
        projects.add(focus);
        return projects.toArray(new IJavaProject[projects.size()]);
    }

    private static Collection<IJavaProject> getReferencingProjects(IJavaProject focus) throws JavaModelException {
        HashSet<IJavaProject> projects = new HashSet<IJavaProject>();
        RefactoringScopeFactory.addReferencingProjects(focus, projects);
        projects.add(focus);
        return projects;
    }

    private static int getVisibility(IMember member) throws JavaModelException {
        if (JdtFlags.isPrivate(member)) {
            return 0;
        }
        if (JdtFlags.isPackageVisible(member)) {
            return 1;
        }
        if (JdtFlags.isProtected(member)) {
            return 2;
        }
        return 4;
    }

    private RefactoringScopeFactory() {
    }
}

