/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.refresh;

import org.eclipse.core.internal.refresh.MonitorJob;
import org.eclipse.core.internal.refresh.MonitorManager;
import org.eclipse.core.internal.refresh.RefreshJob;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.refresh.IRefreshMonitor;
import org.eclipse.core.resources.refresh.IRefreshResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SubMonitor;

public class RefreshManager
implements IRefreshResult,
IManager,
Preferences.IPropertyChangeListener {
    public static final String DEBUG_PREFIX = "Auto-refresh: ";
    volatile MonitorManager monitors;
    private volatile RefreshJob refreshJob;
    private Workspace workspace;

    public RefreshManager(Workspace workspace) {
        this.workspace = workspace;
    }

    protected void manageAutoRefresh(boolean enabled, IProgressMonitor progressMonitor) {
        if (this.refreshJob == null) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert(progressMonitor, 1);
        if (enabled) {
            this.monitors.start(subMonitor.split(1));
        } else {
            this.refreshJob.cancel();
            this.monitors.stop();
        }
    }

    Workspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public void monitorFailed(IRefreshMonitor monitor, IResource resource) {
        if (this.monitors != null) {
            this.monitors.monitorFailed(monitor, resource);
        }
    }

    @Override
    @Deprecated
    public void propertyChange(Preferences.PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("refresh.enabled".equals(property)) {
            Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
            boolean autoRefresh = preferences.getBoolean("refresh.enabled");
            String jobName = autoRefresh ? Messages.refresh_installMonitorsOnWorkspace : Messages.refresh_uninstallMonitorsOnWorkspace;
            MonitorJob.createSystem(jobName, this.getWorkspace().getRoot(), monitor -> this.manageAutoRefresh(autoRefresh, monitor)).schedule();
        }
    }

    @Override
    public void refresh(IResource resource) {
        if (this.refreshJob != null) {
            this.refreshJob.refresh(resource);
        }
    }

    @Override
    public void shutdown(IProgressMonitor monitor) {
        if (this.refreshJob == null) {
            return;
        }
        ResourcesPlugin.getPlugin().getPluginPreferences().removePropertyChangeListener(this);
        if (this.monitors != null) {
            this.monitors.stop();
            this.monitors = null;
        }
        if (this.refreshJob != null) {
            this.refreshJob.stop();
            this.refreshJob = null;
        }
    }

    @Override
    public void startup(IProgressMonitor monitor) {
        this.refreshJob = new RefreshJob(this.workspace);
        this.monitors = new MonitorManager(this.workspace, this);
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        preferences.addPropertyChangeListener(this);
        boolean autoRefresh = preferences.getBoolean("refresh.enabled");
        if (autoRefresh) {
            SubMonitor subMonitor = SubMonitor.convert(monitor, 1);
            this.manageAutoRefresh(autoRefresh, subMonitor.split(1));
        }
    }
}

