/*
 * Decompiled with CFR 0.152.
 */
package com.github.badsyntax.gradle;

import com.github.badsyntax.gradle.GradleConfig;
import com.github.badsyntax.gradle.GradleProjectConnectionType;
import com.google.common.base.Strings;
import java.io.File;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import org.gradle.tooling.GradleConnector;

public class GradleProjectConnector {
    private static final String GRADLE_HOME = "GRADLE_HOME";
    public static final String TOOLING_API_VERSION = "9.2.0";
    private static GradleProjectConnectionType connectionType = GradleProjectConnectionType.WRAPPER;
    private static String localInstallation;

    private GradleProjectConnector() {
    }

    public static GradleConnector build(String projectDir, GradleConfig config) {
        GradleConnector connector = GradleConnector.newConnector().forProjectDirectory(new File(projectDir));
        GradleProjectConnector.setConnectorConfig(connector, projectDir, config);
        return connector;
    }

    private static void setConnectorConfig(GradleConnector gradleConnector, String projectDir, GradleConfig config) {
        if (!Strings.isNullOrEmpty((String)config.getUserHome())) {
            gradleConnector.useGradleUserHomeDir(GradleProjectConnector.buildGradleUserHomeFile(config.getUserHome(), projectDir));
        }
        if (!config.getWrapperEnabled()) {
            if (!Strings.isNullOrEmpty((String)config.getVersion())) {
                connectionType = GradleProjectConnectionType.SPECIFICVERSION;
                gradleConnector.useGradleVersion(config.getVersion());
            } else if (!Strings.isNullOrEmpty((String)config.getGradleHome())) {
                connectionType = GradleProjectConnectionType.LOCALINSTALLATION;
                localInstallation = config.getGradleHome();
                gradleConnector.useInstallation(new File(localInstallation));
            } else {
                File gradleHomeFile = GradleProjectConnector.getSystemGradleHome();
                if (gradleHomeFile != null) {
                    connectionType = GradleProjectConnectionType.LOCALINSTALLATION;
                    localInstallation = gradleHomeFile.toString();
                    gradleConnector.useInstallation(gradleHomeFile);
                    return;
                }
                connectionType = GradleProjectConnectionType.SPECIFICVERSION;
                gradleConnector.useGradleVersion(TOOLING_API_VERSION);
            }
        } else {
            connectionType = GradleProjectConnectionType.WRAPPER;
        }
    }

    private static File buildGradleUserHomeFile(String gradleUserHome, String projectDir) {
        String gradleUserHomePath = Paths.get(gradleUserHome, new String[0]).isAbsolute() ? gradleUserHome : Paths.get(projectDir, gradleUserHome).toAbsolutePath().toString();
        return new File(gradleUserHomePath);
    }

    public static GradleProjectConnectionType getConnectionType() {
        return connectionType;
    }

    public static String getLocalInstallation() {
        return localInstallation;
    }

    public static File getSystemGradleHome() {
        Map<String, String> env = System.getenv();
        Properties sysProperties = System.getProperties();
        String gradleHome = env.get(GRADLE_HOME);
        if (gradleHome == null) {
            gradleHome = sysProperties.getProperty(GRADLE_HOME);
        }
        return gradleHome == null ? null : new File(gradleHome);
    }
}

