/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac.problem;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ElementKind;
import javax.tools.JavaFileObject;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class UnusedProblemFactory {
    private Map<JavaFileObject, Map<String, List<CategorizedProblem>>> filesToUnusedImports = new HashMap<JavaFileObject, Map<String, List<CategorizedProblem>>>();
    private IProblemFactory problemFactory;
    private CompilerOptions compilerOptions;

    public UnusedProblemFactory(IProblemFactory problemFactory, CompilerOptions compilerOptions) {
        this.problemFactory = problemFactory;
        this.compilerOptions = compilerOptions;
    }

    public UnusedProblemFactory(IProblemFactory problemFactory, Map<String, String> compilerOptions) {
        this.problemFactory = problemFactory;
        this.compilerOptions = new CompilerOptions(compilerOptions);
    }

    public List<CategorizedProblem> addUnusedImports(CompilationUnitTree unit, Map<String, List<JCTree.JCImport>> unusedImports) {
        int severity = this.toSeverity(268435844);
        if (severity == 256 || severity == 32) {
            return null;
        }
        LinkedHashMap<String, List<CategorizedProblem>> unusedWarning = new LinkedHashMap<String, List<CategorizedProblem>>();
        char[] fileName = unit.getSourceFile().getName().toCharArray();
        for (Map.Entry<String, List<JCTree.JCImport>> unusedImport : unusedImports.entrySet()) {
            String importName = unusedImport.getKey();
            ArrayList<CategorizedProblem> unusedWarningList = (ArrayList<CategorizedProblem>)unusedWarning.get(importName);
            if (unusedWarningList == null) {
                unusedWarningList = new ArrayList<CategorizedProblem>();
            }
            for (JCTree.JCImport importNode : unusedImport.getValue()) {
                int pos = importNode.qualid.getStartPosition();
                int endPos = pos + importName.length() - 1;
                if (importName.endsWith(".*")) {
                    importName = importName.substring(0, importName.length() - 2);
                    endPos -= 2;
                }
                int line = (int)unit.getLineMap().getLineNumber(pos);
                int column = (int)unit.getLineMap().getColumnNumber(pos);
                String[] arguments = new String[]{importName};
                CategorizedProblem problem = this.problemFactory.createProblem(fileName, 268435844, arguments, arguments, severity, pos, endPos, line, column);
                unusedWarningList.add(problem);
            }
            unusedWarning.put(importName, unusedWarningList);
        }
        JavaFileObject file = unit.getSourceFile();
        Map<String, List<CategorizedProblem>> newUnusedImports = this.mergeUnusedImports(this.filesToUnusedImports.get(file), unusedWarning);
        this.filesToUnusedImports.put(file, newUnusedImports);
        ArrayList<CategorizedProblem> result = new ArrayList<CategorizedProblem>();
        for (List<CategorizedProblem> newUnusedImportList : newUnusedImports.values()) {
            result.addAll(newUnusedImportList);
        }
        return result;
    }

    public List<CategorizedProblem> addUnusedPrivateMembers(CompilationUnitTree unit, List<Tree> unusedPrivateDecls) {
        if (unit == null) {
            return Collections.emptyList();
        }
        char[] fileName = unit.getSourceFile().getName().toCharArray();
        ArrayList<CategorizedProblem> problems = new ArrayList<CategorizedProblem>();
        for (Tree decl : unusedPrivateDecls) {
            CategorizedProblem problem = null;
            if (decl instanceof JCTree.JCClassDecl) {
                int pos;
                JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)decl;
                int severity = this.toSeverity(553648135);
                if (severity == 256 || severity == 32) continue;
                int startPos = pos = classDecl.getPreferredPosition();
                int endPos = pos;
                String shortName = classDecl.name.toString();
                JavaFileObject fileObject = unit.getSourceFile();
                try {
                    String temp;
                    int index;
                    CharSequence charContent = fileObject.getCharContent(true);
                    String content = charContent.toString();
                    if (content != null && content.length() > pos && (index = (temp = content.substring(pos)).indexOf(shortName)) >= 0) {
                        startPos = pos + index;
                        endPos = startPos + shortName.length() - 1;
                    }
                }
                catch (IOException charContent) {
                    // empty catch block
                }
                int line = (int)unit.getLineMap().getLineNumber(startPos);
                int column = (int)unit.getLineMap().getColumnNumber(startPos);
                problem = this.problemFactory.createProblem(fileName, 553648135, new String[]{shortName}, new String[]{shortName}, severity, startPos, endPos, line, column);
            } else if (decl instanceof JCTree.JCMethodDecl) {
                JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)decl;
                int problemId = methodDecl.sym.isConstructor() ? 603979910 : 603979894;
                int severity = this.toSeverity(problemId);
                if (severity == 256 || severity == 32) continue;
                String selector = methodDecl.name.toString();
                String typeName = methodDecl.sym.owner.name.toString();
                CharSequence[] params = (String[])methodDecl.params.stream().map(variableDecl -> variableDecl.vartype.toString()).toArray(String[]::new);
                String[] arguments = new String[]{typeName, selector, String.join((CharSequence)", ", params)};
                int pos = methodDecl.getPreferredPosition();
                int endPos = pos + methodDecl.name.toString().length() - 1;
                int line = (int)unit.getLineMap().getLineNumber(pos);
                int column = (int)unit.getLineMap().getColumnNumber(pos);
                problem = this.problemFactory.createProblem(fileName, problemId, arguments, arguments, severity, pos, endPos, line, column);
            } else if (decl instanceof JCTree.JCVariableDecl) {
                int severity;
                ElementKind varKind;
                JCTree.JCVariableDecl variableDecl2 = (JCTree.JCVariableDecl)decl;
                int pos = variableDecl2.getPreferredPosition();
                int endPos = pos + variableDecl2.name.toString().length() - 1;
                int line = (int)unit.getLineMap().getLineNumber(pos);
                int column = (int)unit.getLineMap().getColumnNumber(pos);
                int problemId = 536870973;
                String name = variableDecl2.name.toString();
                String[] arguments = new String[]{name};
                Symbol.VarSymbol varSymbol = variableDecl2.sym;
                ElementKind elementKind = varKind = varSymbol == null ? null : varSymbol.getKind();
                if (varKind == ElementKind.FIELD) {
                    problemId = 570425421;
                    String typeName = varSymbol.owner.name.toString();
                    arguments = new String[]{typeName, name};
                } else if (varKind == ElementKind.PARAMETER) {
                    problemId = 536870974;
                } else if (varKind == ElementKind.EXCEPTION_PARAMETER) {
                    problemId = 0x20000055;
                }
                if ((severity = this.toSeverity(problemId)) == 256 || severity == 32) continue;
                problem = this.problemFactory.createProblem(fileName, problemId, arguments, arguments, severity, pos, endPos, line, column);
            }
            problems.add(problem);
        }
        return problems;
    }

    public List<CategorizedProblem> addUnnecessaryCasts(CompilationUnitTree unit, List<JCTree.JCTypeCast> unnecessaryCasts) {
        int severity = this.toSeverity(553648309);
        if (severity == 256 || severity == 32) {
            return Collections.emptyList();
        }
        char[] fileName = unit.getSourceFile().getName().toCharArray();
        ArrayList<CategorizedProblem> problems = new ArrayList<CategorizedProblem>();
        for (JCTree.JCTypeCast cast : unnecessaryCasts) {
            JCTree.JCExpression expr = cast.expr;
            int pos = cast.getStartPosition();
            int endPos = expr.getStartPosition() - 1;
            String castType = cast.clazz.type.toString();
            String exprType = expr.type.toString();
            String[] arguments = new String[]{exprType, castType};
            int line = (int)unit.getLineMap().getLineNumber(pos);
            int column = (int)unit.getLineMap().getColumnNumber(pos);
            CategorizedProblem problem = this.problemFactory.createProblem(fileName, 553648309, arguments, arguments, severity, pos, endPos, line, column);
            problems.add(problem);
        }
        return problems;
    }

    public List<CategorizedProblem> addNoEffectAssignments(CompilationUnitTree unit, List<JCTree.JCAssign> noEffectAssignments) {
        int severity = this.toSeverity(0x200000B2);
        if (severity == 256 || severity == 32) {
            return Collections.emptyList();
        }
        char[] fileName = unit.getSourceFile().getName().toCharArray();
        ArrayList<CategorizedProblem> problems = new ArrayList<CategorizedProblem>();
        for (JCTree.JCAssign assign : noEffectAssignments) {
            int pos = assign.getStartPosition();
            int endPos = assign.getEndPosition(((JCTree.JCCompilationUnit)unit).endPositions) - 1;
            String varName = assign.lhs.toString();
            String[] arguments = new String[]{varName};
            int line = (int)unit.getLineMap().getLineNumber(pos);
            int column = (int)unit.getLineMap().getColumnNumber(pos);
            CategorizedProblem problem = this.problemFactory.createProblem(fileName, 0x200000B2, arguments, arguments, severity, pos, endPos, line, column);
            problems.add(problem);
        }
        return problems;
    }

    private Map<String, List<CategorizedProblem>> mergeUnusedImports(Map<String, List<CategorizedProblem>> map1, Map<String, List<CategorizedProblem>> map2) {
        if (map1 == null) {
            return map2;
        }
        if (map2 == null) {
            return map2;
        }
        LinkedHashMap<String, List<CategorizedProblem>> mergedMap = new LinkedHashMap<String, List<CategorizedProblem>>();
        for (Map.Entry<String, List<CategorizedProblem>> entry : map1.entrySet()) {
            if (!map2.containsKey(entry.getKey())) continue;
            mergedMap.put(entry.getKey(), entry.getValue());
        }
        return mergedMap;
    }

    private int toSeverity(int jdtProblemId) {
        int irritant = ProblemReporter.getIrritant((int)jdtProblemId);
        if (irritant != 0) {
            int res = this.compilerOptions.getSeverity(irritant);
            return res &= 0xFFFFFFDF;
        }
        return 0;
    }
}

