/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.net.URI;
import java.util.Optional;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;

@API(status=API.Status.MAINTAINED, since="5.3")
public abstract class DynamicNode {
    private final String displayName;
    private final @Nullable URI testSourceUri;

    DynamicNode(String displayName, @Nullable URI testSourceUri) {
        this.displayName = Preconditions.notBlank((String)displayName, (String)"displayName must not be null or blank");
        this.testSourceUri = testSourceUri;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Optional<URI> getTestSourceUri() {
        return Optional.ofNullable(this.testSourceUri);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("displayName", (Object)this.displayName).append("testSourceUri", (Object)this.testSourceUri).toString();
    }
}

