/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.PreferencesOSGiUtils;
import org.eclipse.core.internal.runtime.MetaDataKeeper;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.service.datalocation.Location;

public class InstancePreferences
extends EclipsePreferences {
    private String qualifier;
    private int segmentCount;
    private IEclipsePreferences loadLevel;
    private IPath location;
    private static Set<String> loadedNodes = Collections.synchronizedSet(new HashSet());
    private static boolean initialized = false;
    private static IPath baseLocation;

    static IPath getBaseLocation() {
        Location instanceLocation;
        if (baseLocation == null && (instanceLocation = PreferencesOSGiUtils.getDefault().getInstanceLocation()) != null && (instanceLocation.isSet() || instanceLocation.allowsDefault())) {
            baseLocation = MetaDataKeeper.getMetaArea().getStateLocation("org.eclipse.core.runtime");
        }
        return baseLocation;
    }

    public InstancePreferences() {
        this(null, null);
    }

    private InstancePreferences(EclipsePreferences parent, String name) {
        super(parent, name);
        this.initializeChildren();
        String path = this.absolutePath();
        this.segmentCount = InstancePreferences.getSegmentCount(path);
        if (this.segmentCount < 2) {
            return;
        }
        this.qualifier = InstancePreferences.getSegment(path, 1);
    }

    @Override
    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return loadedNodes.contains(node.name());
    }

    @Override
    protected void loaded() {
        loadedNodes.add(this.name());
    }

    @Override
    protected IPath getLocation() {
        if (this.location == null) {
            this.location = this.computeLocation(InstancePreferences.getBaseLocation(), this.qualifier);
        }
        return this.location;
    }

    @Override
    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            IEclipsePreferences node = this;
            int i = 2;
            while (i < this.segmentCount) {
                node = (IEclipsePreferences)node.parent();
                ++i;
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeChildren() {
        if (initialized || this.parent == null) {
            return;
        }
        try {
            InstancePreferences instancePreferences = this;
            synchronized (instancePreferences) {
                for (String n : this.computeChildren(InstancePreferences.getBaseLocation())) {
                    this.addChild(n, null);
                }
            }
        }
        finally {
            initialized = true;
        }
    }

    @Override
    protected EclipsePreferences internalCreate(EclipsePreferences nodeParent, String nodeName, Object context) {
        return new InstancePreferences(nodeParent, nodeName);
    }
}

