/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;

class DOMCompletionEngineBuilder {
    private static final String EXTENDS = "extends";
    private static final String THROWS = "throws";
    private static final String SUPER = "super";
    private static final String JAVA_LANG_PKG = "java.lang.";

    DOMCompletionEngineBuilder() {
    }

    static void createMethod(IMethodBinding methodBinding, StringBuilder completion, ITypeBinding currentType, List<ITypeBinding> importedTypes, String currentPackage) {
        String[] parameterNames;
        ITypeBinding[] typeVariableBindings;
        int insertedModifiers = methodBinding.getModifiers() & 0xFFFFFAFF;
        if (insertedModifiers != 0) {
            ASTNode.printModifiers((int)insertedModifiers, (StringBuilder)completion);
        }
        if ((typeVariableBindings = methodBinding.getTypeParameters()) != null && typeVariableBindings.length != 0) {
            completion.append('<');
            for (int i = 0; i < typeVariableBindings.length; ++i) {
                if (i != 0) {
                    completion.append(',');
                    completion.append(' ');
                }
                DOMCompletionEngineBuilder.createTypeVariable(typeVariableBindings[i], completion, currentType, importedTypes, currentPackage);
            }
            completion.append('>');
            completion.append(' ');
        }
        DOMCompletionEngineBuilder.createType(methodBinding.getReturnType(), completion, currentType, importedTypes, currentPackage);
        completion.append(' ');
        completion.append(methodBinding.getName());
        completion.append('(');
        ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
        try {
            parameterNames = methodBinding.getJavaElement() != null ? ((IMethod)methodBinding.getJavaElement()).getParameterNames() : methodBinding.getParameterNames();
        }
        catch (JavaModelException e) {
            parameterNames = methodBinding.getParameterNames();
        }
        int length = parameterTypes.length;
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                completion.append(',');
                completion.append(' ');
            }
            DOMCompletionEngineBuilder.createType(parameterTypes[i], completion, currentType, importedTypes, currentPackage);
            completion.append(' ');
            if (parameterNames != null) {
                completion.append(parameterNames[i]);
                continue;
            }
            completion.append('%');
        }
        completion.append(')');
        ITypeBinding[] exceptions = methodBinding.getExceptionTypes();
        if (exceptions != null && exceptions.length > 0) {
            completion.append(' ');
            completion.append(THROWS);
            completion.append(' ');
            for (int i = 0; i < exceptions.length; ++i) {
                if (i != 0) {
                    completion.append(' ');
                    completion.append(',');
                }
                DOMCompletionEngineBuilder.createType(exceptions[i], completion, currentType, importedTypes, currentPackage);
            }
        }
    }

    static void createType(ITypeBinding type, StringBuilder completion, ITypeBinding currentType, List<ITypeBinding> importedTypes, String currentPackage) {
        if (type.isWildcardType() || type.isIntersectionType()) {
            completion.append('?');
            if (type.isUpperbound() && type.getBound() != null) {
                completion.append(' ');
                completion.append(EXTENDS);
                completion.append(' ');
                DOMCompletionEngineBuilder.createType(type.getBound(), completion, currentType, importedTypes, currentPackage);
                if (type.getTypeBounds() != null) {
                    for (ITypeBinding bound : type.getTypeBounds()) {
                        completion.append(' ');
                        completion.append('&');
                        completion.append(' ');
                        DOMCompletionEngineBuilder.createType(bound, completion, currentType, importedTypes, currentPackage);
                    }
                }
            } else if (type.getBound() != null) {
                completion.append(' ');
                completion.append(SUPER);
                completion.append(' ');
                DOMCompletionEngineBuilder.createType(type.getBound(), completion, currentType, importedTypes, currentPackage);
            }
        } else if (type.isArray()) {
            DOMCompletionEngineBuilder.createType(type.getElementType(), completion, currentType, importedTypes, currentPackage);
            int dim = type.getDimensions();
            for (int i = 0; i < dim; ++i) {
                completion.append("[]");
            }
        } else if (type.isParameterizedType()) {
            if (type.isMember()) {
                DOMCompletionEngineBuilder.createType(type.getDeclaringClass(), completion, currentType, importedTypes, currentPackage);
                completion.append('.');
                completion.append(type.getName());
            } else {
                completion.append(type.getQualifiedName());
            }
            ITypeBinding[] typeArguments = type.getTypeArguments();
            if (typeArguments != null) {
                completion.append('<');
                int length = typeArguments.length;
                for (int i = 0; i < length; ++i) {
                    if (i != 0) {
                        completion.append(',');
                    }
                    DOMCompletionEngineBuilder.createType(typeArguments[i], completion, currentType, importedTypes, currentPackage);
                }
                completion.append('>');
            }
        } else {
            ITypeBinding firstMatchingInheritedMemberType;
            boolean appended = false;
            for (ITypeBinding importedType : importedTypes) {
                if (!importedType.getKey().equals(type.getErasure().getKey())) continue;
                completion.append(type.getName());
                appended = true;
                break;
            }
            if ((firstMatchingInheritedMemberType = DOMCompletionEngineBuilder.getFirstMatchingInheritedMemberType(currentType, type.getName())) != null && firstMatchingInheritedMemberType.getKey().equals(type.getKey())) {
                completion.append(type.getName());
                appended = true;
            }
            if (!appended) {
                String packageName;
                String qualifiedName = type.getQualifiedName();
                String string = packageName = type.getPackage() != null ? type.getPackage().getName() : "";
                if (qualifiedName.startsWith(JAVA_LANG_PKG)) {
                    qualifiedName = qualifiedName.substring(JAVA_LANG_PKG.length());
                } else if (!packageName.isEmpty() && currentPackage.startsWith(packageName)) {
                    qualifiedName = qualifiedName.substring(packageName.length() + 1);
                }
                completion.append(qualifiedName);
            }
        }
    }

    static void createTypeVariable(ITypeBinding typeVariable, StringBuilder completion, ITypeBinding currentType, List<ITypeBinding> importedTypes, String currentPackage) {
        completion.append(typeVariable.getName());
        if (typeVariable.getSuperclass() != null && typeVariable.getTypeBounds()[0].getKey().equals(typeVariable.getSuperclass().getKey())) {
            completion.append(' ');
            completion.append(EXTENDS);
            completion.append(' ');
            DOMCompletionEngineBuilder.createType(typeVariable.getSuperclass(), completion, currentType, importedTypes, currentPackage);
        }
        if (typeVariable.getInterfaces() != null) {
            if (!typeVariable.getTypeBounds()[0].getKey().equals(typeVariable.getSuperclass().getKey())) {
                completion.append(' ');
                completion.append(EXTENDS);
                completion.append(' ');
            }
            int length = typeVariable.getInterfaces().length;
            for (int i = 0; i < length; ++i) {
                if (i > 0 || typeVariable.getTypeBounds()[0].getKey().equals(typeVariable.getSuperclass().getKey())) {
                    completion.append(' ');
                    completion.append(EXTENDS);
                    completion.append(' ');
                }
                DOMCompletionEngineBuilder.createType(typeVariable.getInterfaces()[i], completion, currentType, importedTypes, currentPackage);
            }
        }
    }

    static ITypeBinding getFirstMatchingInheritedMemberType(ITypeBinding typeBinding, String typeName) {
        return DOMCompletionEngineBuilder.getFirstMatchingInheritedMemberType(typeBinding, typeName, true);
    }

    static ITypeBinding getFirstMatchingInheritedMemberType(ITypeBinding typeBinding, String typeName, boolean canUsePrivate) {
        for (ITypeBinding memberType : typeBinding.getDeclaredTypes()) {
            if (!typeName.equals(memberType.getName()) || !canUsePrivate && Flags.isPrivate((int)memberType.getModifiers())) continue;
            return memberType;
        }
        if (typeBinding.getSuperclass() != null) {
            return DOMCompletionEngineBuilder.getFirstMatchingInheritedMemberType(typeBinding.getSuperclass(), typeName, false);
        }
        return null;
    }
}

