/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.core.SourceField;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.refactoring.structure.ExtractInterfaceProcessor;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.MoveHandler;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;

public class ExtractInterfaceHandler {
    public static CheckExtractInterfaceResponse checkExtractInterfaceStatus(CodeActionParams params) {
        IMember[] extractableMembers;
        ICompilationUnit cu = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
        if (cu == null) {
            return null;
        }
        IType type = cu.findPrimaryType();
        if (type == null) {
            return null;
        }
        CodeGenerationSettings settings = PreferenceManager.getCodeGenerationSettings(cu);
        ExtractInterfaceProcessor processor = new ExtractInterfaceProcessor(type, settings);
        try {
            extractableMembers = processor.getExtractableMembers();
        }
        catch (JavaModelException e) {
            return null;
        }
        Member[] members = (Member[])Arrays.stream(extractableMembers).map(member -> {
            try {
                if (member instanceof SourceMethod) {
                    SourceMethod method = (SourceMethod)member;
                    return new Member(method.getElementName(), Signature.getSignatureSimpleName((String)method.getReturnType()), (String[])Arrays.stream(method.getParameterTypes()).map(parameterType -> Signature.getSignatureSimpleName((String)parameterType)).toArray(String[]::new), member.getHandleIdentifier());
                }
                if (member instanceof SourceField) {
                    SourceField field = (SourceField)member;
                    return new Member(field.getElementName(), Signature.getSignatureSimpleName((String)field.getTypeSignature()), field.getHandleIdentifier());
                }
                return null;
            }
            catch (JavaModelException e) {
                return null;
            }
        }).filter(member -> member != null).toArray(Member[]::new);
        MoveHandler.MoveDestinationsResponse destinationResponse = MoveHandler.getPackageDestinations(new String[]{params.getTextDocument().getUri()});
        return new CheckExtractInterfaceResponse(members, type.getElementName(), destinationResponse);
    }

    public static Refactoring getExtractInterfaceRefactoring(CodeActionParams params, List<String> handleIdentifiers, String interfaceName, MoveHandler.PackageNode packageNode) {
        ICompilationUnit cu = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
        if (cu == null) {
            return null;
        }
        IType type = cu.findPrimaryType();
        if (type == null) {
            return null;
        }
        CodeGenerationSettings settings = PreferenceManager.getCodeGenerationSettings(cu);
        ExtractInterfaceProcessor processor = new ExtractInterfaceProcessor(type, settings);
        try {
            IMember[] selectedMembers = (IMember[])Arrays.stream(processor.getExtractableMembers()).filter(member -> handleIdentifiers.contains(member.getHandleIdentifier())).toArray(IMember[]::new);
            IPackageFragment fragment = JDTUtils.resolvePackage(packageNode.uri);
            if (fragment != null) {
                processor.setPackageFragment(fragment);
            }
            processor.setExtractedMembers(selectedMembers);
            processor.setTypeName(interfaceName);
            processor.setReplace(JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getExtractInterfaceReplaceEnabled());
            processor.setAnnotations(true);
            ProcessorBasedRefactoring refactoring = new ProcessorBasedRefactoring((RefactoringProcessor)processor);
            RefactoringStatus status = refactoring.checkFinalConditions((IProgressMonitor)new NullProgressMonitor());
            if (status.isOK()) {
                return refactoring;
            }
            if (status.hasError()) {
                String message = status.getMessageMatchingSeverity(4);
                if (message == null) {
                    message = status.getMessageMatchingSeverity(3);
                }
                JavaLanguageServerPlugin.getProjectsManager().getConnection().showMessage(new MessageParams(MessageType.Error, message));
            }
            JavaLanguageServerPlugin.logError(status.toString());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public static class CheckExtractInterfaceResponse {
        public Member[] members;
        public String subTypeName;
        public MoveHandler.MoveDestinationsResponse destinationResponse;

        public CheckExtractInterfaceResponse(Member[] members, String subTypeName, MoveHandler.MoveDestinationsResponse destinationResponse) {
            this.members = members;
            this.subTypeName = subTypeName;
            this.destinationResponse = destinationResponse;
        }
    }

    public static class Member {
        public String name;
        public String typeName;
        public String[] parameters;
        public String handleIdentifier;

        public Member(String name, String typeName, String handleIdentifier) {
            this.name = name;
            this.typeName = typeName;
            this.handleIdentifier = handleIdentifier;
        }

        public Member(String name, String typeName, String[] parameters, String handleIdentifier) {
            this.name = name;
            this.typeName = typeName;
            this.parameters = parameters;
            this.handleIdentifier = handleIdentifier;
        }
    }
}

