/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdtls.ext.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.microsoft.jdtls.ext.core.JdtlsExtActivator;
import com.microsoft.jdtls.ext.core.PackageCommand;
import com.microsoft.jdtls.ext.core.model.PackageNode;
import com.microsoft.jdtls.ext.core.parser.ContextResolver;
import com.microsoft.jdtls.ext.core.parser.ProjectResolver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.jarpackager.JarPackageUtil;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.managers.UpdateClasspathJob;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.jsonrpc.json.adapters.CollectionTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.json.adapters.EnumTypeAdapter;

public final class ProjectCommand {
    private static String COMMAND_EXPORT_JAR_REPORT = "java.view.package.exportJarReport";
    private static final Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new CollectionTypeAdapter.Factory()).registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapter.Factory()).create();

    public static List<PackageNode> listProjects(List<Object> arguments, IProgressMonitor monitor) {
        String workspaceUri = (String)arguments.get(0);
        IPath workspaceFolderPath = ResourceUtils.canonicalFilePathFromURI((String)workspaceUri);
        boolean filterNonJava = false;
        if (arguments.size() > 1) {
            filterNonJava = (Boolean)arguments.get(1);
        }
        IProject[] projects = !filterNonJava ? ProjectUtils.getAllProjects() : (IProject[])Arrays.stream(ProjectUtils.getJavaProjects()).map(IJavaProject::getProject).toArray(IProject[]::new);
        ArrayList<PackageNode> children = new ArrayList<PackageNode>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                PackageNode projectNode;
                block8: {
                    IProject project = iProjectArray[n2];
                    if (!project.isAccessible() || project.getLocation() == null || Objects.equals(project.getName(), "jdt.ls-java-project")) break block7;
                    projectNode = PackageNode.createNodeForProject((IJavaElement)JavaCore.create((IProject)project));
                    if (workspaceFolderPath.isPrefixOf(project.getLocation())) break block8;
                    LinkedFolderVisitor visitor = new LinkedFolderVisitor(workspaceFolderPath);
                    try {
                        project.accept((IResourceVisitor)visitor, 1, false);
                    }
                    catch (CoreException e) {
                        JdtlsExtActivator.log(e);
                        break block7;
                    }
                    if (!visitor.isBelongsToWorkspace()) break block7;
                    projectNode.setDisplayName(workspaceFolderPath.lastSegment());
                }
                children.add(projectNode);
            }
            ++n2;
        }
        return children;
    }

    public static boolean refreshLibraries(List<Object> arguments, IProgressMonitor monitor) {
        String workspaceUri = (String)arguments.get(0);
        IPath workspacePath = ResourceUtils.canonicalFilePathFromURI((String)workspaceUri);
        String projectName = ProjectUtils.getWorkspaceInvisibleProjectName((IPath)workspacePath);
        IProject project = ProjectCommand.getWorkspaceRoot().getProject(projectName);
        try {
            Preferences.ReferencedLibraries libraries = JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getReferencedLibraries();
            UpdateClasspathJob.getInstance().updateClasspath(JavaCore.create((IProject)project), libraries);
            return true;
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException((String)"Exception occurred during waiting for classpath to be updated", (Throwable)e);
            return false;
        }
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static boolean exportJar(List<Object> arguments, IProgressMonitor monitor) {
        if (arguments.size() < 4) {
            return false;
        }
        String mainClass = (String)gson.fromJson(gson.toJson(arguments.get(0)), String.class);
        Classpath[] classpaths = (Classpath[])gson.fromJson(gson.toJson(arguments.get(1)), Classpath[].class);
        String destination = (String)gson.fromJson(gson.toJson(arguments.get(2)), String.class);
        String terminalId = (String)gson.fromJson(gson.toJson(arguments.get(3)), String.class);
        try {
            return ProjectCommand.exportJarExecution(mainClass, classpaths, destination, terminalId, monitor);
        }
        catch (OperationCanceledException e) {
            File jarFile = new File(destination);
            if (jarFile.exists()) {
                jarFile.delete();
            }
            return false;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean exportJarExecution(String mainClass, Classpath[] classpaths, String destination, String terminalId, IProgressMonitor monitor) throws OperationCanceledException {
        manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        if (mainClass.length() > 0) {
            manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, mainClass);
        }
        try {
            var6_6 = null;
            var7_9 = null;
            try {
                target = new JarOutputStream((OutputStream)new FileOutputStream(destination), manifest);
                try {
                    directories = new HashSet<String>();
                    var13_13 = classpaths;
                    var12_14 = classpaths.length;
                    var11_15 = 0;
                    while (true) {
                        block17: {
                            block15: {
                                block18: {
                                    block16: {
                                        classpath = var13_13[var11_15];
                                        if (monitor.isCanceled()) {
                                            return false;
                                        }
                                        if (!classpath.isArtifact) break block15;
                                        resultStatus = JarPackageUtil.writeArchive(new ZipFile(classpath.source), true, true, target, directories, monitor);
                                        severity = resultStatus.getSeverity();
                                        if (severity != 0) break block16;
                                        path = Paths.get(classpath.source, new String[0]);
                                        ProjectCommand.reportExportJarMessage(terminalId, 0, "Successfully extracted the file to the exported jar: " + path.getFileName().toString());
                                        break block17;
                                    }
                                    if (!resultStatus.isMultiStatus()) break block18;
                                    var19_23 = resultStatus.getChildren();
                                    var18_22 = var19_23.length;
                                    var17_21 = 0;
                                    if (true) ** GOTO lbl50
                                }
                                ProjectCommand.reportExportJarMessage(terminalId, severity, resultStatus.getMessage());
                                break block17;
                            }
                            try {
                                JarPackageUtil.writeFile(new File(classpath.source), (IPath)new Path(classpath.destination), true, true, target, directories);
                                ProjectCommand.reportExportJarMessage(terminalId, 0, "Successfully added the file to the exported jar: " + classpath.destination);
                            }
                            catch (CoreException e) {
                                ProjectCommand.reportExportJarMessage(terminalId, 4, e.getMessage());
                            }
                            break block17;
                            do {
                                childStatus = var19_23[var17_21];
                                ProjectCommand.reportExportJarMessage(terminalId, severity, childStatus.getMessage());
                                ++var17_21;
lbl50:
                                // 2 sources

                            } while (var17_21 < var18_22);
                        }
                        ++var11_15;
                        return (boolean)var11_15;
                    }
                }
                finally {
                    if (var11_15 < var12_14) ** continue;
                    return true;
                }
            }
            catch (Throwable var7_10) {
                if (var6_6 == null) {
                    var6_6 = var7_10;
                    throw var6_6;
                }
                if (var6_6 == var7_10) throw var6_6;
                var6_6.addSuppressed(var7_10);
                throw var6_6;
            }
        }
        catch (IOException e) {
            ProjectCommand.reportExportJarMessage(terminalId, 4, e.getMessage());
            return false;
        }
    }

    public static List<MainClassInfo> getMainClasses(List<Object> arguments, IProgressMonitor monitor) throws Exception {
        ArrayList<Object> args = new ArrayList<Object>(arguments);
        if (args.size() <= 1) {
            args.add(Boolean.TRUE);
        } else {
            args.set(1, Boolean.TRUE);
        }
        List<PackageNode> projectList = ProjectCommand.listProjects(args, monitor);
        if (projectList.size() == 0) {
            return Collections.emptyList();
        }
        final ArrayList<MainClassInfo> res = new ArrayList<MainClassInfo>();
        ArrayList<IJavaProject> javaProjects = new ArrayList<IJavaProject>();
        for (PackageNode project : projectList) {
            IJavaProject javaProject = PackageCommand.getJavaProject(project.getUri());
            if (javaProject == null || !javaProject.exists()) continue;
            javaProjects.add(javaProject);
        }
        int includeMask = 1;
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])((IJavaElement[])javaProjects.toArray(new IJavaProject[0])), (int)includeMask);
        SearchPattern pattern1 = SearchPattern.createPattern((String)"main(String[]) void", (int)1, (int)0, (int)8);
        SearchPattern pattern2 = SearchPattern.createPattern((String)"main() void", (int)1, (int)0, (int)8);
        SearchPattern pattern = SearchPattern.createOrPattern((SearchPattern)pattern1, (SearchPattern)pattern2);
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) {
                Object element = match.getElement();
                if (!(element instanceof IMethod)) {
                    return;
                }
                IMethod method = (IMethod)element;
                try {
                    if (!method.isMainMethod() || method.getResource() == null || method.getJavaProject() == null) {
                        return;
                    }
                    String mainClass = method.getDeclaringType().getFullyQualifiedName();
                    String filePath = "";
                    if (match.getResource() instanceof IFile) {
                        filePath = match.getResource().getLocation().toOSString();
                    }
                    res.add(new MainClassInfo(mainClass, filePath));
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        };
        SearchEngine searchEngine = new SearchEngine();
        try {
            searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, monitor);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return res;
    }

    public static String getModuleName(IJavaProject project) {
        if (project == null || !JavaRuntime.isModularProject((IJavaProject)project)) {
            return null;
        }
        try {
            IModuleDescription module = project.getModuleDescription();
            return module == null ? null : module.getElementName();
        }
        catch (CoreException e) {
            return null;
        }
    }

    public static boolean checkImportStatus() {
        IProject[] projects = ProjectUtils.getAllProjects();
        boolean hasError = false;
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!"jdt.ls-java-project".equals(project.getName())) {
                if (ProjectUtils.isJavaProject((IProject)project)) {
                    return false;
                }
                try {
                    int maxProblemSeverity = project.findMaxProblemSeverity(null, true, 1);
                    if (maxProblemSeverity == 2) {
                        hasError = true;
                        break;
                    }
                }
                catch (CoreException e) {
                    JdtlsExtActivator.log(e);
                }
            }
            ++n2;
        }
        return hasError;
    }

    public static ImportClassContentResult getImportClassContent(List<Object> arguments, IProgressMonitor monitor) {
        long startTime = System.currentTimeMillis();
        long TIMEOUT_MS = 80L;
        if (arguments == null || arguments.isEmpty()) {
            return new ImportClassContentResult(ImportClassContentErrorReason.NULL_ARGUMENTS);
        }
        try {
            String fileUri = (String)arguments.get(0);
            if (fileUri == null || fileUri.trim().isEmpty()) {
                return new ImportClassContentResult(ImportClassContentErrorReason.INVALID_URI, fileUri);
            }
            URI uri = JDTUtils.toURI((String)fileUri);
            ICompilationUnit compilationUnit = JDTUtils.resolveCompilationUnit((URI)uri);
            if (compilationUnit == null || !compilationUnit.exists()) {
                return new ImportClassContentResult(ImportClassContentErrorReason.FILE_NOT_FOUND, fileUri);
            }
            IJavaProject javaProject = compilationUnit.getJavaProject();
            if (javaProject == null || !javaProject.exists()) {
                String projectName = javaProject != null && javaProject.getProject() != null ? javaProject.getProject().getName() : "unknown";
                return new ImportClassContentResult(ImportClassContentErrorReason.PROJECT_NOT_EXISTS, projectName);
            }
            ArrayList<ContextResolver.ImportClassInfo> classInfoList = new ArrayList<ContextResolver.ImportClassInfo>();
            IImportDeclaration[] imports = compilationUnit.getImports();
            HashSet<String> processedTypes = new HashSet<String>();
            if (imports == null || imports.length == 0) {
                return new ImportClassContentResult(ImportClassContentErrorReason.NO_IMPORTS);
            }
            IImportDeclaration[] iImportDeclarationArray = imports;
            int n = imports.length;
            int n2 = 0;
            while (n2 < n) {
                boolean isStatic;
                IImportDeclaration importDecl = iImportDeclarationArray[n2];
                if (monitor.isCanceled()) {
                    return new ImportClassContentResult(ImportClassContentErrorReason.OPERATION_CANCELLED);
                }
                String importName = importDecl.getElementName();
                boolean bl = isStatic = (importDecl.getFlags() & 8) != 0;
                if (isStatic) {
                    ContextResolver.resolveStaticImport(javaProject, importName, classInfoList, processedTypes, monitor);
                } else if (importName.endsWith(".*")) {
                    String packageName = importName.substring(0, importName.length() - 2);
                    ContextResolver.resolvePackageTypes(javaProject, packageName, classInfoList, processedTypes, monitor);
                } else {
                    ContextResolver.resolveSingleType(javaProject, importName, classInfoList, processedTypes, monitor);
                }
                ++n2;
            }
            if (!monitor.isCanceled()) {
                long currentTime = System.currentTimeMillis();
                long elapsedTime = currentTime - startTime;
                if (elapsedTime >= 80L) {
                    if (classInfoList.isEmpty()) {
                        return new ImportClassContentResult(ImportClassContentErrorReason.TIME_LIMIT_EXCEEDED, String.valueOf(elapsedTime) + "ms");
                    }
                    return new ImportClassContentResult(classInfoList);
                }
                ArrayList<ContextResolver.ImportClassInfo> externalClasses = new ArrayList<ContextResolver.ImportClassInfo>();
                IImportDeclaration[] iImportDeclarationArray2 = imports;
                int n3 = imports.length;
                int n4 = 0;
                while (n4 < n3) {
                    boolean isStatic;
                    IImportDeclaration importDecl = iImportDeclarationArray2[n4];
                    if (monitor.isCanceled() || (elapsedTime = (currentTime = System.currentTimeMillis()) - startTime) >= 80L) break;
                    String importName = importDecl.getElementName();
                    boolean bl = isStatic = (importDecl.getFlags() & 8) != 0;
                    if (!importName.endsWith(".*") && !isStatic) {
                        ContextResolver.resolveBinaryType(javaProject, importName, externalClasses, processedTypes, Integer.MAX_VALUE, monitor);
                    }
                    ++n4;
                }
                classInfoList.addAll(externalClasses);
            }
            if (classInfoList.isEmpty()) {
                return new ImportClassContentResult(ImportClassContentErrorReason.NO_RESULTS);
            }
            return new ImportClassContentResult(classInfoList);
        }
        catch (Exception e) {
            JdtlsExtActivator.logException("Error in getImportClassContent", e);
            String errorUri = null;
            try {
                if (arguments != null && !arguments.isEmpty()) {
                    errorUri = (String)arguments.get(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new ImportClassContentResult(ImportClassContentErrorReason.PROCESSING_EXCEPTION, errorUri);
        }
    }

    private static void reportExportJarMessage(String terminalId, int severity, String message) {
        if (StringUtils.isNotBlank((CharSequence)message) && StringUtils.isNotBlank((CharSequence)terminalId)) {
            String readableSeverity = ProjectCommand.getSeverityString(severity);
            JavaLanguageServerPlugin.getInstance().getClientConnection().executeClientCommand(COMMAND_EXPORT_JAR_REPORT, new Object[]{terminalId, "[" + readableSeverity + "] " + message});
        }
    }

    private static String getSeverityString(int severity) {
        switch (severity) {
            case 1: {
                return "INFO";
            }
            case 2: {
                return "WARNING";
            }
            case 4: {
                return "ERROR";
            }
            case 8: {
                return "CANCEL";
            }
            case 0: {
                return "OK";
            }
        }
        return "UNKNOWN STATUS";
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProjectDependenciesResult getProjectDependencies(List<Object> arguments, IProgressMonitor monitor) {
        block12: {
            if (arguments == null) return new ProjectDependenciesResult(ProjectDependenciesErrorReason.NULL_ARGUMENTS);
            if (arguments.isEmpty()) {
                return new ProjectDependenciesResult(ProjectDependenciesErrorReason.NULL_ARGUMENTS);
            }
            fileUri = (String)arguments.get(0);
            if (fileUri == null) return new ProjectDependenciesResult(ProjectDependenciesErrorReason.INVALID_URI, fileUri);
            if (!fileUri.trim().isEmpty()) break block12;
            return new ProjectDependenciesResult(ProjectDependenciesErrorReason.INVALID_URI, fileUri);
            {
                catch (Exception e) {
                    JdtlsExtActivator.logException("Error in getProjectDependenciesWithReason", e);
                    errorUri = null;
                    try {
                        if (arguments == null) return new ProjectDependenciesResult(ProjectDependenciesErrorReason.PROCESSING_EXCEPTION, errorUri);
                        if (arguments.isEmpty() != false) return new ProjectDependenciesResult(ProjectDependenciesErrorReason.PROCESSING_EXCEPTION, errorUri);
                        errorUri = (String)arguments.get(0);
                        return new ProjectDependenciesResult(ProjectDependenciesErrorReason.PROCESSING_EXCEPTION, errorUri);
                    }
                    catch (Exception var4_8) {
                        // empty catch block
                    }
                    return new ProjectDependenciesResult(ProjectDependenciesErrorReason.PROCESSING_EXCEPTION, errorUri);
                }
            }
        }
        try {
            uri = JDTUtils.toURI((String)fileUri);
            if (uri == null) {
                return new ProjectDependenciesResult(ProjectDependenciesErrorReason.URI_PARSE_FAILED, fileUri);
            }
            ** GOTO lbl29
        }
        catch (Exception e) {
            return new ProjectDependenciesResult(ProjectDependenciesErrorReason.MALFORMED_URI, fileUri);
lbl29:
            // 1 sources

            if (monitor.isCanceled()) {
                return new ProjectDependenciesResult(ProjectDependenciesErrorReason.OPERATION_CANCELLED);
            }
            resolverResult = ProjectResolver.resolveProjectDependencies(fileUri, monitor);
            if (resolverResult == null) {
                return new ProjectDependenciesResult(ProjectDependenciesErrorReason.RESOLVER_NULL_RESULT);
            }
            result = new ArrayList<DependencyInfo>();
            var6_9 = resolverResult.iterator();
            if (true) ** GOTO lbl41
        }
        do {
            if ((info = var6_9.next()) == null) continue;
            result.add(new DependencyInfo(info.key, info.value));
lbl41:
            // 3 sources

        } while (var6_9.hasNext());
        if (result.isEmpty() == false) return new ProjectDependenciesResult(result);
        return new ProjectDependenciesResult(ProjectDependenciesErrorReason.NO_DEPENDENCIES);
    }

    private static class Classpath {
        public String source;
        public String destination;
        public boolean isArtifact;

        private Classpath() {
        }
    }

    private static class DependencyInfo {
        public String key;
        public String value;

        public DependencyInfo(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    public static class ErrorContext {
        public final String errorValue;

        public ErrorContext(String errorValue) {
            this.errorValue = errorValue;
        }
    }

    public static enum ImportClassContentErrorReason {
        NULL_ARGUMENTS("NullArgs"),
        INVALID_URI("InvalidURI"),
        URI_PARSE_FAILED("ParseFail"),
        FILE_NOT_FOUND("NotFound"),
        FILE_NOT_EXISTS("NotExists"),
        NOT_JAVA_PROJECT("NotJava"),
        PROJECT_NOT_EXISTS("ProjNotExists"),
        NOT_COMPILATION_UNIT("NotCU"),
        NO_IMPORTS("NoImports"),
        OPERATION_CANCELLED("Cancelled"),
        TIME_LIMIT_EXCEEDED("Timeout"),
        NO_RESULTS("NoResults"),
        PROCESSING_EXCEPTION("Error");

        private final String message;

        private ImportClassContentErrorReason(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class ImportClassContentResult {
        public List<ContextResolver.ImportClassInfo> classInfoList;
        public String emptyReason;
        public boolean isEmpty;
        public ErrorContext errorContext;

        public ImportClassContentResult(List<ContextResolver.ImportClassInfo> classInfoList) {
            this.classInfoList = classInfoList;
            this.emptyReason = null;
            this.isEmpty = false;
            this.errorContext = null;
        }

        public ImportClassContentResult(ImportClassContentErrorReason errorReason) {
            this.classInfoList = Collections.emptyList();
            this.emptyReason = errorReason.getMessage();
            this.isEmpty = true;
            this.errorContext = null;
        }

        public ImportClassContentResult(ImportClassContentErrorReason errorReason, String errorValue) {
            this.classInfoList = Collections.emptyList();
            this.emptyReason = errorReason.getMessage();
            this.isEmpty = true;
            this.errorContext = new ErrorContext(errorValue);
        }
    }

    private static final class LinkedFolderVisitor
    implements IResourceVisitor {
        private boolean belongsToWorkspace = false;
        private IPath workspaceFolderPath;

        public LinkedFolderVisitor(IPath workspaceFolderPath) {
            this.workspaceFolderPath = workspaceFolderPath;
        }

        public boolean visit(IResource resource) throws CoreException {
            IPath realPath;
            if (this.belongsToWorkspace) {
                return false;
            }
            if (!resource.exists()) {
                return false;
            }
            if (resource.isLinked() && this.workspaceFolderPath.isPrefixOf(realPath = resource.getLocation())) {
                this.belongsToWorkspace = true;
            }
            return true;
        }

        public boolean isBelongsToWorkspace() {
            return this.belongsToWorkspace;
        }
    }

    private static class MainClassInfo {
        public String name;
        public String path;

        public MainClassInfo(String name, String path) {
            this.name = name;
            this.path = path;
        }
    }

    public static enum ProjectDependenciesErrorReason {
        NULL_ARGUMENTS("NullArgs"),
        INVALID_URI("InvalidURI"),
        URI_PARSE_FAILED("ParseFail"),
        MALFORMED_URI("MalformedURI"),
        OPERATION_CANCELLED("Cancelled"),
        RESOLVER_NULL_RESULT("ResolverNull"),
        NO_DEPENDENCIES("NoDeps"),
        PROCESSING_EXCEPTION("Error");

        private final String message;

        private ProjectDependenciesErrorReason(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class ProjectDependenciesResult {
        public List<DependencyInfo> dependencyInfoList;
        public String emptyReason;
        public boolean isEmpty;
        public ErrorContext errorContext;

        public ProjectDependenciesResult(List<DependencyInfo> dependencyInfoList) {
            this.dependencyInfoList = dependencyInfoList;
            this.emptyReason = null;
            this.isEmpty = false;
            this.errorContext = null;
        }

        public ProjectDependenciesResult(ProjectDependenciesErrorReason errorReason) {
            this.dependencyInfoList = new ArrayList<DependencyInfo>();
            this.emptyReason = errorReason.getMessage();
            this.isEmpty = true;
            this.errorContext = null;
        }

        public ProjectDependenciesResult(ProjectDependenciesErrorReason errorReason, String errorValue) {
            this.dependencyInfoList = new ArrayList<DependencyInfo>();
            this.emptyReason = errorReason.getMessage();
            this.isEmpty = true;
            this.errorContext = new ErrorContext(errorValue);
        }
    }
}

