/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.model;

import com.microsoft.java.test.plugin.model.TestKind;
import com.microsoft.java.test.plugin.model.TestLevel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.Range;

public class JavaTestItem {
    private String id;
    private String label;
    private String fullName;
    private List<JavaTestItem> children;
    private TestLevel testLevel;
    private TestKind testKind;
    private String projectName;
    private String uri;
    private Range range;
    private String jdtHandler;
    private String[] natureIds;

    public JavaTestItem() {
    }

    public JavaTestItem(String displayName, String fullName, String project, String uri, Range range, TestLevel level, TestKind kind) {
        this.label = displayName;
        this.fullName = fullName;
        this.testLevel = level;
        this.testKind = kind;
        this.projectName = project;
        this.uri = uri;
        this.range = range;
        this.id = level.equals((Object)TestLevel.PROJECT) ? fullName : project + "@" + fullName;
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getJdtHandler() {
        return this.jdtHandler;
    }

    public void setJdtHandler(String jdtHandler) {
        this.jdtHandler = jdtHandler;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public List<JavaTestItem> getChildren() {
        return this.children;
    }

    public void setChildren(List<JavaTestItem> children) {
        this.children = children;
    }

    public TestLevel getTestLevel() {
        return this.testLevel;
    }

    public void setTestLevel(TestLevel testLevel) {
        this.testLevel = testLevel;
    }

    public TestKind getTestKind() {
        return this.testKind;
    }

    public void setTestKind(TestKind testKind) {
        this.testKind = testKind;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String[] getNatureIds() {
        return this.natureIds;
    }

    public void setNatureIds(String[] natureIds) {
        this.natureIds = natureIds;
    }

    public void addChild(JavaTestItem child) {
        if (this.children == null) {
            this.children = new ArrayList<JavaTestItem>();
        }
        this.children.add(child);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaTestItem other = (JavaTestItem)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

