/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gradle.transport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class NamedPipeStream {
    private String pipeName;
    private StreamProvider provider;

    public NamedPipeStream(String pipeName) {
        this.pipeName = pipeName;
    }

    public StreamProvider getSelectedStream() {
        if (this.provider == null) {
            this.provider = this.createProvider();
        }
        return this.provider;
    }

    private StreamProvider createProvider() {
        PipeStreamProvider pipeStreamProvider = new PipeStreamProvider();
        pipeStreamProvider.initializeNamedPipe();
        return pipeStreamProvider;
    }

    public InputStream getInputStream() throws IOException {
        return this.getSelectedStream().getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getSelectedStream().getOutputStream();
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    static interface StreamProvider {
        public InputStream getInputStream() throws IOException;

        public OutputStream getOutputStream() throws IOException;
    }

    protected final class PipeStreamProvider
    implements StreamProvider {
        private InputStream input;
        private OutputStream output;
        private String pipeName;

        protected PipeStreamProvider() {
            this.pipeName = NamedPipeStream.this.pipeName;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.input;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.output;
        }

        private void initializeNamedPipe() {
            File pipeFile = new File(this.pipeName);
            try {
                this.attemptConnection(pipeFile);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error initializing the named pipe", e);
            }
        }

        private void attemptConnection(File pipeFile) throws IOException {
            if (NamedPipeStream.isWindows()) {
                AsynchronousFileChannel channel = AsynchronousFileChannel.open(pipeFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
                this.input = new NamedPipeInputStream(channel);
                this.output = new NamedPipeOutputStream(channel);
            } else {
                UnixDomainSocketAddress socketAddress = UnixDomainSocketAddress.of(pipeFile.toPath());
                SocketChannel channel = SocketChannel.open(StandardProtocolFamily.UNIX);
                channel.connect(socketAddress);
                this.input = new NamedPipeInputStream(channel);
                this.output = new NamedPipeOutputStream(channel);
            }
        }
    }

    public class NamedPipeOutputStream
    extends OutputStream {
        private WritableByteChannel unixChannel;
        private AsynchronousFileChannel winChannel;
        private ByteBuffer buffer = ByteBuffer.allocate(1);

        public NamedPipeOutputStream(WritableByteChannel channel) {
            this.unixChannel = channel;
        }

        public NamedPipeOutputStream(AsynchronousFileChannel channel) {
            this.winChannel = channel;
        }

        @Override
        public void write(int b) throws IOException {
            this.buffer.clear();
            this.buffer.put((byte)b);
            this.buffer.position(0);
            if (this.winChannel != null) {
                Future<Integer> result = this.winChannel.write(this.buffer, 0L);
                try {
                    result.get();
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            } else {
                this.unixChannel.write(this.buffer);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            int buffer_size = 1024;
            int blocks = b.length / 1024;
            int writeBytes = 0;
            for (int i = 0; i <= blocks; ++i) {
                int offset = i * 1024;
                int length = Math.min(b.length - writeBytes, 1024);
                if (length <= 0) break;
                writeBytes += length;
                ByteBuffer buffer = ByteBuffer.wrap(b, offset, length);
                if (this.winChannel != null) {
                    Future<Integer> result = this.winChannel.write(buffer, 0L);
                    try {
                        result.get();
                        continue;
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
                this.unixChannel.write(buffer);
            }
        }
    }

    public class NamedPipeInputStream
    extends InputStream {
        private ReadableByteChannel unixChannel;
        private AsynchronousFileChannel winChannel;
        private ByteBuffer buffer = ByteBuffer.allocate(1024);
        private int readyBytes = 0;

        public NamedPipeInputStream(ReadableByteChannel channel) {
            this.unixChannel = channel;
        }

        public NamedPipeInputStream(AsynchronousFileChannel channel) {
            this.winChannel = channel;
        }

        @Override
        public int read() throws IOException {
            if (this.buffer.position() < this.readyBytes) {
                return this.buffer.get() & 0xFF;
            }
            try {
                this.buffer.clear();
                this.readyBytes = this.winChannel != null ? this.winChannel.read(this.buffer, 0L).get().intValue() : this.unixChannel.read(this.buffer);
                if (this.readyBytes == -1) {
                    return -1;
                }
                this.buffer.flip();
                return this.buffer.get() & 0xFF;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
        }
    }
}

