/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.junit.platform.engine.CancellationToken;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.LauncherExecutionRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;

final class DefaultLauncherExecutionRequest
implements LauncherExecutionRequest {
    private final @Nullable LauncherDiscoveryRequest discoveryRequest;
    private final @Nullable TestPlan testPlan;
    private final List<? extends TestExecutionListener> executionListeners;
    private final CancellationToken cancellationToken;

    DefaultLauncherExecutionRequest(@Nullable LauncherDiscoveryRequest discoveryRequest, @Nullable TestPlan testPlan, Collection<? extends TestExecutionListener> executionListeners, CancellationToken cancellationToken) {
        this.discoveryRequest = discoveryRequest;
        this.testPlan = testPlan;
        this.executionListeners = List.copyOf(executionListeners);
        this.cancellationToken = cancellationToken;
    }

    @Override
    public Optional<LauncherDiscoveryRequest> getDiscoveryRequest() {
        return Optional.ofNullable(this.discoveryRequest);
    }

    @Override
    public Optional<TestPlan> getTestPlan() {
        return Optional.ofNullable(this.testPlan);
    }

    @Override
    public Collection<? extends TestExecutionListener> getAdditionalTestExecutionListeners() {
        return this.executionListeners;
    }

    @Override
    public CancellationToken getCancellationToken() {
        return this.cancellationToken;
    }
}

