/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gradle.bs.importer.builder;

import ch.epfl.scala.bsp4j.BuildTarget;
import ch.epfl.scala.bsp4j.CompileParams;
import ch.epfl.scala.bsp4j.CompileResult;
import ch.epfl.scala.bsp4j.StatusCode;
import com.microsoft.gradle.bs.importer.BuildServerConnection;
import com.microsoft.gradle.bs.importer.ImporterPlugin;
import com.microsoft.gradle.bs.importer.Utils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;

public class BuildServerBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "com.microsoft.gradle.bs.importer.builder.BuildServerBuilder";

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        Preferences preferences = JavaLanguageServerPlugin.getPreferencesManager().getPreferences();
        if (!Utils.isBuildServerEnabled(preferences)) {
            return null;
        }
        IProject project = this.getProject();
        IPath rootPath = ProjectUtils.findBelongedWorkspaceRoot((IPath)project.getLocation());
        if (rootPath == null) {
            JavaLanguageServerPlugin.logError((String)("Cannot find workspace root for project: " + project.getName()));
            return null;
        }
        BuildServerConnection buildServer = ImporterPlugin.getBuildServerConnection(rootPath);
        if (buildServer == null) {
            JavaLanguageServerPlugin.logInfo((String)("Skip building project: " + project.getName() + " because build server is not available."));
            return null;
        }
        List<BuildTarget> targets = Utils.getBuildTargetsByProjectUri(buildServer, project.getLocationURI());
        List ids = targets.stream().map(BuildTarget::getId).collect(Collectors.toList());
        if (ids != null) {
            CompileResult result = (CompileResult)buildServer.buildTargetCompile(new CompileParams(ids)).join();
            if (Objects.equals(result.getStatusCode(), StatusCode.ERROR)) {
                throw new CoreException((IStatus)new Status(4, "com.microsoft.gradle.buildServer.importer", 75, "Build Failed.", null));
            }
            this.refreshOutputs(monitor);
        }
        return null;
    }

    private void refreshOutputs(IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = ProjectUtils.getJavaProject((IProject)this.getProject());
        if (javaProject == null) {
            return;
        }
        boolean needRefreshDefaultOutput = false;
        IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cp = iClasspathEntryArray[n2];
            if (cp.getEntryKind() == 3) {
                IPath output = cp.getOutputLocation();
                if (output != null) {
                    output = output.removeFirstSegments(1);
                    javaProject.getProject().getFolder(output).refreshLocal(2, monitor);
                } else {
                    needRefreshDefaultOutput = true;
                }
            }
            ++n2;
        }
        if (needRefreshDefaultOutput) {
            IPath relativeOutputPath = javaProject.getOutputLocation().removeFirstSegments(1);
            IFolder defaultOutput = javaProject.getProject().getFolder(relativeOutputPath);
            if (defaultOutput.exists()) {
                defaultOutput.refreshLocal(2, monitor);
            }
        }
    }
}

