/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.preferences;

import java.util.Calendar;
import java.util.Locale;
import org.eclipse.jface.text.templates.SimpleTemplateVariableResolver;
import org.eclipse.jface.text.templates.TemplateContext;

public class CodeTemplatePreferences {
    private static final String CODETEMPLATES_PREFIX = "org.eclipse.jdt.ui.text.codetemplates.";
    public static final String COMMENT_SUFFIX = "comment";
    public static final String BODY_SUFFIX = "body";
    private static final String BLOCK_SUFFIX = "block";
    public static final String CODETEMPLATE_NEWTYPE = "org.eclipse.jdt.ui.text.codetemplates.newtype";
    public static final String CODETEMPLATE_FILECOMMENT = "org.eclipse.jdt.ui.text.codetemplates.filecomment";
    public static final String CODETEMPLATE_FIELDCOMMENT = "org.eclipse.jdt.ui.text.codetemplates.fieldcomment";
    public static final String CODETEMPLATE_CONSTRUCTORCOMMENT = "org.eclipse.jdt.ui.text.codetemplates.constructorcomment";
    public static final String CODETEMPLATE_CONSTRUCTORBODY = "org.eclipse.jdt.ui.text.codetemplates.constructorbody";
    public static final String CODETEMPLATE_METHODBODY = "org.eclipse.jdt.ui.text.codetemplates.methodbody";
    public static final String CODETEMPLATE_METHODBODY_SUPER = "org.eclipse.jdt.ui.text.codetemplates.methodbodyalternative";
    public static final String CODETEMPLATE_DELEGATECOMMENT = "org.eclipse.jdt.ui.text.codetemplates.delegatecomment";
    public static final String CODETEMPLATE_OVERRIDECOMMENT = "org.eclipse.jdt.ui.text.codetemplates.overridecomment";
    public static final String CODETEMPLATE_METHODCOMMENT = "org.eclipse.jdt.ui.text.codetemplates.methodcomment";
    public static final String CODETEMPLATE_CODESNIPPET = "org.eclipse.jdt.ui.text.codetemplates.snippetbody";
    public static final String CODETEMPLATE_TYPECOMMENT = "org.eclipse.jdt.ui.text.codetemplates.typecomment";
    public static final String CODETEMPLATE_GETTERCOMMENT = "org.eclipse.jdt.ui.text.codetemplates.gettercomment";
    public static final String CODETEMPLATE_SETTERCOMMENT = "org.eclipse.jdt.ui.text.codetemplates.settercomment";
    public static final String CODETEMPLATE_GETTERBODY = "org.eclipse.jdt.ui.text.codetemplates.getterbody";
    public static final String CODETEMPLATE_SETTERBODY = "org.eclipse.jdt.ui.text.codetemplates.setterbody";
    public static final String CODETEMPLATE_CATCHBODY = "org.eclipse.jdt.ui.text.codetemplates.catchblock";
    public static final String CLASSSNIPPET_CONTEXTTYPE = "classsnippet_context";
    public static final String INTERFACESNIPPET_CONTEXTTYPE = "interfacesnippet_context";
    public static final String RECORDSNIPPET_CONTEXTTYPE = "recordsnippet_context";
    public static final String CODETEMPLATE_NEWTYPE_DEFAULT = "${filecomment}${package_declaration}\n\n${typecomment}\n${type_declaration}";
    public static final String CODETEMPLATE_FIELDCOMMENT_DEFAULT = "/**\n *\n */";
    public static final String CODETEMPLATE_CONSTRUCTORCOMMENT_DEFAULT = "/**\n * ${tags}\n */";
    public static final String CODETEMPLATE_DELEGATECOMMENT_DEFAULT = "/**\n * ${tags}\n * ${see_to_target}\n */\n";
    public static final String CODETEMPLATE_OVERRIDECOMMENT_DEFAULT = "";
    public static final String CODETEMPLATE_METHODCOMMENT_DEFAULT = "/**\n * ${tags}\n */\n";
    public static final String CODETEMPLATE_TYPECOMMENT_DEFAULT = "/**\n * ${type_name}\n * ${tags}\n */";
    public static final String CODETEMPLATE_GETTERCOMMENT_DEFAULT = "/**\n * @return the ${bare_field_name}\n */";
    public static final String CODETEMPLATE_SETTERCOMMENT_DEFAULT = "/**\n * @param ${param} the ${bare_field_name} to set\n */";
    public static final String CODETEMPLATE_GETTERBODY_DEFAULT = "return ${field};\n";
    public static final String CODETEMPLATE_SETTERBODY_DEFAULT = "${field} = ${param};\n";
    public static final String CODETEMPLATE_CONSTRUCTORBODY_DEFAULT = "${body_statement}\n//${todo} Auto-generated constructor stub";
    public static final String CODETEMPLATE_METHODBODY_DEFAULT = "// ${todo} Auto-generated method stub\nthrow new UnsupportedOperationException(\"Unimplemented method '${enclosing_method}'\");";
    public static final String CODETEMPLATE_METHODBODY_SUPER_DEFAULT = "// ${todo} Auto-generated method stub\n${body_statement}";
    public static final String CODETEMPLATE_CATCHBODY_DEFAULT = "// ${todo} Auto-generated catch block\n${exception_var}.printStackTrace();";
    public static final String CODETEMPLATE_CLASSSNIPPET_DEFAULT = "${filecomment}${package_header}class ${type_name} {\n\n\t${cursor}\n}";
    public static final String CODETEMPLATE_CLASSSNIPPET_PUBLIC = "${filecomment}${package_header}${typecomment}public class ${type_name} {\n\n\t${cursor}\n}";
    public static final String CODETEMPLATE_INTERFACESNIPPET_DEFAULT = "${filecomment}${package_header}interface ${type_name} {\n\n\t${cursor}\n}";
    public static final String CODETEMPLATE_INTERFACESNIPPET_PUBLIC = "${filecomment}${package_header}${typecomment}public interface ${type_name} {\n\n\t${cursor}\n}";
    public static final String CODETEMPLATE_RECORDSNIPPET_DEFAULT = "${filecomment}${package_header}record ${type_name}(${cursor}) {\n}";
    public static final String CODETEMPLATE_RECORDSNIPPET_PUBLIC = "${filecomment}${package_header}${typecomment}public record ${type_name}(${cursor}) {\n}";

    public static class Day
    extends SimpleTemplateVariableResolver {
        public Day() {
            super("day", "Current day of month");
        }

        protected String resolve(TemplateContext context) {
            return String.format("%02d", Calendar.getInstance().get(5));
        }
    }

    public static class Hour
    extends SimpleTemplateVariableResolver {
        public Hour() {
            super("hour", "Current hour of day");
        }

        protected String resolve(TemplateContext context) {
            return String.format("%02d", Calendar.getInstance().get(11));
        }
    }

    public static class Minute
    extends SimpleTemplateVariableResolver {
        public Minute() {
            super("minute", "Current minute");
        }

        protected String resolve(TemplateContext context) {
            return String.format("%02d", Calendar.getInstance().get(12));
        }
    }

    public static class Month
    extends SimpleTemplateVariableResolver {
        public Month() {
            super("month", "Current month");
        }

        protected String resolve(TemplateContext context) {
            return String.format("%02d", Calendar.getInstance().get(2) + 1);
        }
    }

    public static class ShortMonth
    extends SimpleTemplateVariableResolver {
        public ShortMonth() {
            super("shortmonth", "Short form representation of current month");
        }

        protected String resolve(TemplateContext context) {
            return Calendar.getInstance().getDisplayName(2, 1, Locale.getDefault());
        }
    }
}

