/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis;

import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ros.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.nodes.RosNodesStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public interface IRosStateProviderInstantiator {
    default public @NonNull ITmfStateProvider getNewRosStateProviderInstance(Class<?> stateProvider, ITmfTrace trace) {
        try {
            return Objects.requireNonNull((ITmfStateProvider)stateProvider.getConstructor(ITmfTrace.class).newInstance(trace));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
            Activator.getInstance().logError("Error instantiating state provider; using ROS Nodes state provider instead for: " + stateProvider.toString());
            return new RosNodesStateProvider(trace);
        }
    }
}

