/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messagelinks;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.AbstractRos2StateProvider;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messagelinks.Ros2MessageCausalLinksAnalysis;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messagelinks.Ros2MessageCausalLinkType;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messagelinks.Ros2MessageCausalLinksModel;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class Ros2MessageCausalLinksStateProvider
extends AbstractRos2StateProvider {
    private static final int VERSION_NUMBER = 0;
    private final ITmfStateSystem fObjectsSs;
    private final Ros2MessageCausalLinksModel fModel;

    public Ros2MessageCausalLinksStateProvider(ITmfTrace trace, ITmfStateSystem objectsSs, Ros2MessageCausalLinksModel model) {
        super(trace, Ros2MessageCausalLinksAnalysis.getFullAnalysisId());
        this.fObjectsSs = objectsSs;
        this.fModel = model;
    }

    public int getVersion() {
        return 0;
    }

    public @NonNull ITmfStateProvider getNewInstance() {
        return new Ros2MessageCausalLinksStateProvider(this.getTrace(), this.fObjectsSs, this.fModel);
    }

    protected void eventHandle(@NonNull ITmfEvent event) {
        if (!Ros2MessageCausalLinksStateProvider.considerEvent(event)) {
            return;
        }
        if (Ros2MessageCausalLinksStateProvider.isEvent(event, LAYOUT.eventMessageLinkPeriodicAsync())) {
            long[] subs = (long[])Ros2MessageCausalLinksStateProvider.getField(event, LAYOUT.fieldSubs());
            long[] pubs = (long[])Ros2MessageCausalLinksStateProvider.getField(event, LAYOUT.fieldPubs());
            this.fModel.addLink(Ros2MessageCausalLinksStateProvider.toHandles(event, subs), Ros2MessageCausalLinksStateProvider.toHandles(event, pubs), Ros2MessageCausalLinkType.PERIODIC_ASYNC);
        } else if (Ros2MessageCausalLinksStateProvider.isEvent(event, LAYOUT.eventMessageLinkPartialSync())) {
            long[] subs = (long[])Ros2MessageCausalLinksStateProvider.getField(event, LAYOUT.fieldSubs());
            long[] pubs = (long[])Ros2MessageCausalLinksStateProvider.getField(event, LAYOUT.fieldPubs());
            this.fModel.addLink(Ros2MessageCausalLinksStateProvider.toHandles(event, subs), Ros2MessageCausalLinksStateProvider.toHandles(event, pubs), Ros2MessageCausalLinkType.PARTIAL_SYNC);
        }
    }

    private static Collection<@NonNull Ros2ObjectHandle> toHandles(@NonNull ITmfEvent event, long[] handles) {
        return LongStream.of(handles).boxed().map(h -> Ros2MessageCausalLinksStateProvider.handleFrom(event, Objects.requireNonNull(h))).collect(Collectors.toUnmodifiableList());
    }
}

