/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.util.ResourceBundle;
import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.runtime.IStatus;

public class RegistrySupport {
    public static String translate(String key, ResourceBundle resources) {
        if (key == null) {
            return null;
        }
        if (resources == null) {
            return key;
        }
        String trimmedKey = key.trim();
        if (trimmedKey.length() == 0) {
            return key;
        }
        if (trimmedKey.charAt(0) != '%') {
            return key;
        }
        return resources.getString(trimmedKey.substring(1));
    }

    public static void log(IStatus status, String prefix) {
        String message = status.getMessage();
        int severity = status.getSeverity();
        Object statusMsg = switch (severity) {
            case 4 -> RegistryMessages.log_error;
            case 2 -> RegistryMessages.log_warning;
            default -> RegistryMessages.log_log;
        };
        statusMsg = (String)statusMsg + message;
        if (prefix != null) {
            statusMsg = prefix + (String)statusMsg;
        }
        System.out.println((String)statusMsg);
        IStatus[] children = status.getChildren();
        if (children.length != 0) {
            Object newPrefix = prefix == null ? "\t" : prefix + "\t";
            IStatus[] iStatusArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                RegistrySupport.log(child, (String)newPrefix);
                ++n2;
            }
        }
    }
}

