/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.perf.profiling.core.symbol;

import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class PerfMmapStateProvider
extends AbstractTmfStateProvider {
    private static final int VERSION = 1;
    private static final String MMAP_PREFIX = "perf_mmap";

    public PerfMmapStateProvider(ITmfTrace trace) {
        super(trace, "Perf MMap Symbol Resolution");
    }

    public int getVersion() {
        return 1;
    }

    public ITmfStateProvider getNewInstance() {
        return new PerfMmapStateProvider(this.getTrace());
    }

    protected void eventHandle(ITmfEvent event) {
        if (!event.getName().startsWith(MMAP_PREFIX)) {
            return;
        }
        ITmfStateSystemBuilder ss = this.getStateSystemBuilder();
        if (ss == null) {
            return;
        }
        Long pid = (Long)event.getContent().getFieldValue(Long.class, new String[]{"pid"});
        Long start = (Long)event.getContent().getFieldValue(Long.class, new String[]{"start"});
        String filename = (String)event.getContent().getFieldValue(String.class, new String[]{"filename"});
        if (pid == null || start == null || filename == null) {
            return;
        }
        int startQuark = ss.getQuarkAbsoluteAndAdd(new String[]{String.valueOf(pid), String.valueOf(start)});
        ss.modifyAttribute(event.getTimestamp().toNanos(), (Object)filename, startQuark);
    }
}

