/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.AbstractMultiView;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.IMultiViewer;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.Messages;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.SetProviderDialog;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class MultiView
extends AbstractMultiView {
    public static final String VIEW_ID = "org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.MultiView";
    private List<IDataProviderDescriptor> fDescriptors = new ArrayList<IDataProviderDescriptor>();

    public MultiView() {
        super(VIEW_ID);
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void resetStartFinishTime(boolean notify) {
        TmfWindowRangeUpdatedSignal signal = new TmfWindowRangeUpdatedSignal((Object)this, TmfTimeRange.ETERNITY, this.getTrace());
        this.broadcast((TmfSignal)signal);
    }

    @Override
    protected void partControlCreated(Composite mainComposite, SashForm sashForm) {
        this.hideTimeScales();
    }

    @Override
    protected void createMenuItems() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IAction)this.createSetLaneAction());
    }

    private Action createSetLaneAction() {
        return new Action(Messages.Action_Set, 1){

            public void run() {
                ITmfTrace trace = MultiView.this.getTrace();
                Shell shell = MultiView.this.getSite().getShell();
                SetProviderDialog dialog = new SetProviderDialog(shell, trace, MultiView.this.fDescriptors);
                dialog.setBlockOnOpen(true);
                if (dialog.open() == 0) {
                    for (IMultiViewer lane : MultiView.this.getLanes()) {
                        MultiView.this.removeLane(lane);
                    }
                    MultiView.this.fDescriptors = dialog.getDescriptors();
                    for (IDataProviderDescriptor descriptor : MultiView.this.fDescriptors) {
                        IDataProviderDescriptor.ProviderType type = descriptor.getType();
                        if (type == IDataProviderDescriptor.ProviderType.TREE_TIME_XY) {
                            MultiView.this.addChartViewer(descriptor.getId(), true);
                        }
                        if (type != IDataProviderDescriptor.ProviderType.TIME_GRAPH) continue;
                        MultiView.this.addTimeGraphViewer(descriptor.getId(), true);
                    }
                    MultiView.this.alignViewers(true);
                    if (MultiView.this.fDescriptors.isEmpty()) {
                        MultiView.this.hideTimeScales();
                    }
                }
            }
        };
    }
}

