/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.AbstractOtf2StateProvider;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.Otf2Type;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows.FlowsLocation;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows.FlowsLocationGroup;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows.FlowsNodeMap;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows.FlowsSystemTreeNode;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows.Otf2FlowsAnalysis;
import org.eclipse.tracecompass.incubator.internal.otf2.core.trace.AttributeDefinition;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class Otf2FlowsStateProvider
extends AbstractOtf2StateProvider {
    private static final int VERSION_NUMBER = 1;
    private final FlowsNodeMap<Long, FlowsLocation> fMapLocation = new FlowsNodeMap();
    private final FlowsNodeMap<Long, FlowsLocationGroup> fMapLocationGroup = new FlowsNodeMap();
    private final FlowsNodeMap<Long, FlowsSystemTreeNode> fMapSystemTreeNode = new FlowsNodeMap();
    private List<Pair<Integer, Object>> fEventAttributes = new ArrayList<Pair<Integer, Object>>();
    private Map<FlowsLocation, FlowsLocation> fRankToAcceleratorMap = new HashMap<FlowsLocation, FlowsLocation>();
    private boolean fInitialized = false;

    public Otf2FlowsStateProvider(ITmfTrace trace) {
        super(trace, Otf2FlowsAnalysis.getFullAnalysisId());
    }

    public int getVersion() {
        return 1;
    }

    @Override
    protected void processGlobalDefinition(ITmfEvent event, String name) {
        switch (name) {
            case "String": {
                this.processStringDefinition(event);
                break;
            }
            case "Region": {
                this.processRegionDefinition(event);
                break;
            }
            case "Location": {
                this.processLocationDefinition(event);
                break;
            }
            case "LocationGroup": {
                this.processLocationGroupDefinition(event);
                break;
            }
            case "Comm": {
                this.processCommunicatorDefinition(event);
                break;
            }
            case "Group": {
                this.processGroupDefinition(event);
                break;
            }
            case "GroupMember": {
                this.processGroupMemberDefinition(event);
                break;
            }
            case "SystemTreeNode": {
                this.processSystemTreeNodeDefinition(event);
                break;
            }
            case "Attribute": {
                this.processAttributeDefinition(event);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void processLocationDefinition(ITmfEvent event) {
        FlowsLocation location = new FlowsLocation(event);
        this.fMapLocation.put(location.getId(), location);
    }

    private void processLocationGroupDefinition(ITmfEvent event) {
        FlowsLocationGroup locationGroup = new FlowsLocationGroup(event);
        this.fMapLocationGroup.put(locationGroup.getId(), locationGroup);
    }

    private void processSystemTreeNodeDefinition(ITmfEvent event) {
        FlowsSystemTreeNode systemTreeNode = new FlowsSystemTreeNode(event);
        this.fMapSystemTreeNode.put(systemTreeNode.getId(), systemTreeNode);
    }

    private void initializeQuarks(ITmfStateSystemBuilder ssb) {
        for (FlowsSystemTreeNode systemTreeNode : this.fMapSystemTreeNode.values()) {
            if (systemTreeNode == null) continue;
            systemTreeNode.initializeQuarks(ssb, this.fMapSystemTreeNode, this.getStringId());
        }
        for (FlowsLocationGroup locationGroup : this.fMapLocationGroup.values()) {
            if (locationGroup == null) continue;
            locationGroup.initializeQuarks(ssb, this.fMapSystemTreeNode, this.getStringId());
        }
        for (FlowsLocation location : this.fMapLocation.values()) {
            if (location == null) continue;
            location.initializeQuarks(ssb, this.fMapLocationGroup, this.getStringId());
        }
        this.fInitialized = true;
    }

    @Override
    protected void processOtf2Event(ITmfEvent event, String name, ITmfStateSystemBuilder ssb) {
        if (!this.fInitialized) {
            this.initializeQuarks(ssb);
        }
        switch (name) {
            case "Enter": {
                this.processEnter(event);
                break;
            }
            case "Leave": {
                this.processLeave(ssb, event);
                break;
            }
            case "MpiSend": {
                this.processMpiSend(event);
                break;
            }
            case "MpiRecv": {
                this.processMpiRecv(event);
                break;
            }
            case "MpiCollectiveEnd": {
                this.processMpiCollectiveCommunication(event);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    protected void processOtf2EventAttribute(ITmfEvent event, String otf2EventName, ITmfStateSystemBuilder ssb) {
        Integer eventAttributeId = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{"attribute"});
        Object eventAttributeValue = event.getContent().getFieldValue(Object.class, new String[]{"value"});
        if (eventAttributeId != null && eventAttributeValue != null) {
            this.fEventAttributes.add((Pair<Integer, Object>)new Pair((Object)eventAttributeId, eventAttributeValue));
        }
    }

    private void processEnter(ITmfEvent event) {
        Long locationId = this.getLocationId(event);
        FlowsLocation location = (FlowsLocation)this.fMapLocation.get(locationId);
        if (location == null) {
            return;
        }
        location.setLatestEnteredTimestamp(event.getTimestamp().toNanos());
    }

    private void processLeave(ITmfStateSystemBuilder ssb, ITmfEvent event) {
        Long locationId = this.getLocationId(event);
        FlowsLocation location = (FlowsLocation)this.fMapLocation.get(locationId);
        if (location == null) {
            return;
        }
        FlowsLocation acceleratorLocation = this.fRankToAcceleratorMap.get(location);
        if (acceleratorLocation != null) {
            acceleratorLocation.setLatestEnteredTimestamp(location.getLatestEnteredTimestamp());
            acceleratorLocation.setInputMessageSize(location.getInputMessageSize());
            acceleratorLocation.setOutputMessageSize(location.getOutputMessageSize());
            acceleratorLocation.processLeave(ssb, event.getTimestamp().toNanos());
            location.setInputMessageSize(0L);
            location.setOutputMessageSize(0L);
        } else {
            location.processLeave(ssb, event.getTimestamp().toNanos());
        }
    }

    private void addFlowsLocationMapping(FlowsLocation location) {
        Long groupLocationId = null;
        int eventAttributeIndex = -1;
        for (Pair<Integer, Object> attribute : this.fEventAttributes) {
            ++eventAttributeIndex;
            AttributeDefinition attributeDefinition = (AttributeDefinition)this.fAttributeDefinitions.get(attribute.getFirst());
            if (attributeDefinition == null || attributeDefinition.getType() != Otf2Type.OTF2_TYPE_LOCATION_GROUP) continue;
            groupLocationId = (Long)attribute.getSecond();
        }
        if (groupLocationId != null) {
            this.fEventAttributes.remove(eventAttributeIndex);
            for (FlowsLocation acceleratorLocation : this.fMapLocation.values()) {
                if (Objects.requireNonNull(acceleratorLocation).getLocationGroupId() != groupLocationId.longValue()) continue;
                this.fRankToAcceleratorMap.put(location, acceleratorLocation);
            }
        }
    }

    private void processMpiSend(ITmfEvent event) {
        ITmfEventField content = event.getContent();
        Long messageLength = (Long)content.getFieldValue(Long.class, new String[]{"msgLength"});
        Long locationId = this.getLocationId(event);
        FlowsLocation location = (FlowsLocation)this.fMapLocation.get(locationId);
        if (location != null && messageLength != null) {
            location.setOutputMessageSize(messageLength);
            this.addFlowsLocationMapping(location);
        }
    }

    private void processMpiRecv(ITmfEvent event) {
        ITmfEventField content = event.getContent();
        Long messageLength = (Long)content.getFieldValue(Long.class, new String[]{"msgLength"});
        Long locationId = this.getLocationId(event);
        FlowsLocation location = (FlowsLocation)this.fMapLocation.get(locationId);
        if (location != null && messageLength != null) {
            location.setInputMessageSize(messageLength);
            this.addFlowsLocationMapping(location);
        }
    }

    private void processMpiCollectiveCommunication(ITmfEvent event) {
        Long locationId = this.getLocationId(event);
        ITmfEventField content = event.getContent();
        Long receivedMessageLength = (Long)content.getFieldValue(Long.class, new String[]{"sizeReceived"});
        Long sentMessageLength = (Long)content.getFieldValue(Long.class, new String[]{"sizeSent"});
        FlowsLocation location = (FlowsLocation)this.fMapLocation.get(locationId);
        if (location == null || receivedMessageLength == null || sentMessageLength == null) {
            return;
        }
        location.setInputMessageSize(receivedMessageLength);
        location.setOutputMessageSize(sentMessageLength);
    }
}

