/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.datastore.core.tests.historytree;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.datastore.core.interval.IHTInterval;
import org.eclipse.tracecompass.datastore.core.tests.historytree.HtTestUtils;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.AbstractHistoryTree;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.HTNode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractHistoryTreeTestBase<E extends IHTInterval, N extends HTNode<E>> {
    private @Nullable File fTempFile;

    @Before
    public void setupTest() {
        try {
            this.fTempFile = File.createTempFile("tmpStateSystem", null);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void cleanup() throws IOException {
        if (this.fTempFile != null) {
            Files.delete(this.fTempFile.toPath());
        }
    }

    protected AbstractHistoryTree<E, N> setupSmallTree(int maxChildren, long treeStart) {
        AbstractHistoryTree<E, N> ht = null;
        try {
            File newFile = this.fTempFile;
            Assert.assertNotNull((Object)newFile);
            ht = this.createHistoryTree(newFile, 4096, maxChildren, 1, 1L);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull(ht);
        return Objects.requireNonNull(ht);
    }

    protected abstract AbstractHistoryTree<E, N> createHistoryTree(File var1, int var2, int var3, int var4, long var5) throws IOException;

    protected abstract AbstractHistoryTree<E, N> createHistoryTree(File var1, int var2) throws IOException;

    protected abstract E createInterval(long var1, long var3);

    protected final AbstractHistoryTree<E, N> createHistoryTreeReader() throws IOException {
        File tempFile = this.fTempFile;
        Assert.assertNotNull((Object)tempFile);
        return this.createHistoryTree(tempFile, 1);
    }

    protected AbstractHistoryTree<E, N> setupSmallTree() {
        return this.setupSmallTree(3, 1L);
    }

    protected abstract long fillValues(AbstractHistoryTree<E, N> var1, int var2, long var3);

    private long fillNextLeafNode(AbstractHistoryTree<E, N> ht, long leafNodeStart) {
        int prevCount = ht.getNodeCount();
        int prevDepth = ht.getDepth();
        HTNode node = ht.getLatestLeaf();
        long ret = this.fillValues(ht, node.getNodeFreeSpace(), leafNodeStart);
        Assert.assertEquals((long)prevCount, (long)ht.getNodeCount());
        Assert.assertEquals((long)prevDepth, (long)ht.getDepth());
        return ret;
    }

    @Test
    public void testSequentialFill() {
        AbstractHistoryTree<E, N> ht = this.setupSmallTree();
        HTNode node = ht.getLatestLeaf();
        Assert.assertEquals((long)0L, (long)node.getNodeUsagePercent());
        int initialFreeSpace = node.getNodeFreeSpace();
        int limit = node.getNodeFreeSpace() / 10;
        long start = this.fillValues(ht, limit, 1L);
        Assert.assertTrue((node.getNodeFreeSpace() > initialFreeSpace - limit ? 1 : 0) != 0);
        Assert.assertTrue((node.getNodeFreeSpace() < initialFreeSpace ? 1 : 0) != 0);
        start = this.fillValues(ht, limit, start);
        Assert.assertTrue((node.getNodeFreeSpace() > initialFreeSpace - 2 * limit ? 1 : 0) != 0);
        Assert.assertTrue((node.getNodeFreeSpace() < initialFreeSpace - limit ? 1 : 0) != 0);
        start = this.fillValues(ht, limit, start);
        Assert.assertTrue((node.getNodeFreeSpace() > initialFreeSpace - 3 * limit ? 1 : 0) != 0);
        Assert.assertTrue((node.getNodeFreeSpace() < initialFreeSpace - 2 * limit ? 1 : 0) != 0);
        this.fillValues(ht, limit, start);
        Assert.assertTrue((node.getNodeFreeSpace() > initialFreeSpace - 4 * limit ? 1 : 0) != 0);
        Assert.assertTrue((node.getNodeFreeSpace() < initialFreeSpace - 3 * limit ? 1 : 0) != 0);
        ht.closeTree(ht.getTreeEnd());
        HtTestUtils.assertTreeIntegrity(ht);
    }

    @Test
    public void testDepth() {
        AbstractHistoryTree<E, N> ht = this.setupSmallTree();
        HTNode node = ht.getLatestLeaf();
        long start = 1L;
        long time = this.fillValues(ht, node.getNodeFreeSpace(), start);
        Assert.assertEquals((long)1L, (long)ht.getNodeCount());
        Assert.assertEquals((long)1L, (long)ht.getDepth());
        ht.insert(this.createInterval(time, time + 1L));
        ++time;
        Assert.assertEquals((long)3L, (long)ht.getNodeCount());
        Assert.assertEquals((long)2L, (long)ht.getDepth());
        node = ht.getLatestLeaf();
        time = this.fillValues(ht, node.getNodeFreeSpace(), time);
        ht.insert(this.createInterval(time, time + 1L));
        ++time;
        Assert.assertEquals((long)4L, (long)ht.getNodeCount());
        Assert.assertEquals((long)2L, (long)ht.getDepth());
        node = ht.getLatestLeaf();
        time = this.fillValues(ht, node.getNodeFreeSpace(), time);
        ht.insert(this.createInterval(time, time + 1L));
        ++time;
        Assert.assertEquals((long)7L, (long)ht.getNodeCount());
        Assert.assertEquals((long)3L, (long)ht.getDepth());
        while (ht.getDepth() < 4) {
            time = this.fillNextLeafNode(ht, time);
            ht.insert(this.createInterval(time, time + 1L));
        }
        Assert.assertEquals((long)4L, (long)ht.getDepth());
        ht.closeTree(ht.getTreeEnd());
        HtTestUtils.assertTreeIntegrity(ht);
    }

    @Test
    public void testNodeSequenceNumbers() throws ClosedChannelException {
        long time = 1L;
        AbstractHistoryTree<E, N> ht = this.setupSmallTree(2, time);
        time = this.fillNextLeafNode(ht, time);
        List branch = ht.getLatestBranch();
        Assert.assertEquals((long)1L, (long)branch.size());
        Assert.assertEquals((long)0L, (long)((HTNode)branch.get(0)).getSequenceNumber());
        Assert.assertEquals((long)-1L, (long)((HTNode)branch.get(0)).getParentSequenceNumber());
        ht.insert(this.createInterval(time, time + 1L));
        time = this.fillNextLeafNode(ht, time + 1L);
        Assert.assertEquals((long)3L, (long)ht.getNodeCount());
        Assert.assertEquals((long)2L, (long)ht.getDepth());
        HTNode node = ht.getNode(0);
        Assert.assertEquals((long)0L, (long)node.getSequenceNumber());
        Assert.assertEquals((long)1L, (long)node.getParentSequenceNumber());
        branch = ht.getLatestBranch();
        Assert.assertEquals((long)2L, (long)branch.size());
        Assert.assertEquals((long)1L, (long)((HTNode)branch.get(0)).getSequenceNumber());
        Assert.assertEquals((long)-1L, (long)((HTNode)branch.get(0)).getParentSequenceNumber());
        Assert.assertEquals((long)2L, (long)((HTNode)branch.get(1)).getSequenceNumber());
        Assert.assertEquals((long)1L, (long)((HTNode)branch.get(1)).getParentSequenceNumber());
        ht.insert(this.createInterval(time, time + 1L));
        this.fillNextLeafNode(ht, time + 1L);
        Assert.assertEquals((long)6L, (long)ht.getNodeCount());
        Assert.assertEquals((long)3L, (long)ht.getDepth());
        node = ht.getNode(0);
        Assert.assertEquals((long)0L, (long)node.getSequenceNumber());
        Assert.assertEquals((long)1L, (long)node.getParentSequenceNumber());
        node = ht.getNode(1);
        Assert.assertEquals((long)1L, (long)node.getSequenceNumber());
        Assert.assertEquals((long)3L, (long)node.getParentSequenceNumber());
        node = ht.getNode(2);
        Assert.assertEquals((long)2L, (long)node.getSequenceNumber());
        Assert.assertEquals((long)1L, (long)node.getParentSequenceNumber());
        branch = ht.getLatestBranch();
        Assert.assertEquals((long)3L, (long)branch.size());
        Assert.assertEquals((long)3L, (long)((HTNode)branch.get(0)).getSequenceNumber());
        Assert.assertEquals((long)-1L, (long)((HTNode)branch.get(0)).getParentSequenceNumber());
        Assert.assertEquals((long)4L, (long)((HTNode)branch.get(1)).getSequenceNumber());
        Assert.assertEquals((long)3L, (long)((HTNode)branch.get(1)).getParentSequenceNumber());
        Assert.assertEquals((long)5L, (long)((HTNode)branch.get(2)).getSequenceNumber());
        Assert.assertEquals((long)4L, (long)((HTNode)branch.get(2)).getParentSequenceNumber());
        ht.closeTree(ht.getTreeEnd());
        HtTestUtils.assertTreeIntegrity(ht);
    }

    @Test
    public void testReadTree() throws IOException {
        long time = 1L;
        AbstractHistoryTree<E, N> ht = this.setupSmallTree();
        time = this.fillNextLeafNode(ht, time);
        ht.insert(this.createInterval(time, time + 1L));
        time = this.fillNextLeafNode(ht, time + 1L);
        ht.insert(this.createInterval(time, time + 1L));
        time = this.fillNextLeafNode(ht, time + 1L);
        Assert.assertEquals((long)4L, (long)ht.getNodeCount());
        Assert.assertEquals((long)2L, (long)ht.getDepth());
        ht.insert(this.createInterval(time, time + 1L));
        time = this.fillNextLeafNode(ht, time + 1L);
        Assert.assertEquals((long)7L, (long)ht.getNodeCount());
        Assert.assertEquals((long)3L, (long)ht.getDepth());
        ht.closeTree(time + 1L);
        ArrayList<HTNode> expectedNodes = new ArrayList<HTNode>(ht.getNodeCount());
        int i = 0;
        while (i < ht.getNodeCount()) {
            expectedNodes.add(ht.getNode(i));
            ++i;
        }
        ht.closeFile();
        ht = this.createHistoryTreeReader();
        Assert.assertEquals((long)7L, (long)ht.getNodeCount());
        Assert.assertEquals((long)3L, (long)ht.getDepth());
        i = 0;
        while (i < ht.getNodeCount()) {
            Assert.assertEquals(expectedNodes.get(i), (Object)ht.readNode(i));
            ++i;
        }
        HtTestUtils.assertTreeIntegrity(ht);
    }

    @Test
    public void testTreeEnd() {
        long time = 1L;
        AbstractHistoryTree<E, N> ht = this.setupSmallTree();
        Assert.assertEquals((long)time, (long)ht.getTreeEnd());
        time = this.fillNextLeafNode(ht, time);
        Assert.assertEquals((long)time, (long)ht.getTreeEnd());
        E object = this.createInterval(time - 10L, time - 5L);
        ht.insert(object);
        Assert.assertEquals((long)time, (long)ht.getTreeEnd());
        ht.closeTree(ht.getTreeEnd());
        HtTestUtils.assertTreeIntegrity(ht);
    }
}

