/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.validation;

import java.util.ArrayList;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.correction.RemoveUnknownElementQuickFixProposal;
import org.eclipse.wst.xml.ui.internal.correction.RenameInFileQuickAssistProposal;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;

class MarkupQuickAssistProcessor
implements IQuickAssistProcessor {
    private int fProblemId;
    private Object fAdditionalFixInfo = null;

    MarkupQuickAssistProcessor() {
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return false;
    }

    public boolean canFix(Annotation annotation) {
        boolean result = false;
        switch (this.fProblemId) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                result = true;
            }
        }
        return result;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        ArrayList<Object> proposals = new ArrayList<Object>();
        switch (this.fProblemId) {
            case 1: {
                proposals.add(new CompletionProposal("", invocationContext.getOffset(), invocationContext.getLength(), 0, this.getImage(), XMLUIMessages.QuickFixProcessorXML_0, null, ""));
                break;
            }
            case 2: {
                String tagName = (String)((Object[])this.fAdditionalFixInfo)[0];
                String tagClose = (String)((Object[])this.fAdditionalFixInfo)[1];
                int tagCloseOffset = (Integer)((Object[])this.fAdditionalFixInfo)[2];
                int startTagEndOffset = (Integer)((Object[])this.fAdditionalFixInfo)[3];
                int firstChildStartOffset = (Integer)((Object[])this.fAdditionalFixInfo)[4];
                int endOffset = (Integer)((Object[])this.fAdditionalFixInfo)[5];
                proposals.add(new CompletionProposal(tagClose, tagCloseOffset, 0, 0, this.getImage(), XMLUIMessages.QuickFixProcessorXML_1, null, ""));
                proposals.add(new CompletionProposal("", invocationContext.getOffset(), startTagEndOffset - invocationContext.getOffset(), 0, this.getImage(), XMLUIMessages.QuickFixProcessorXML_2, null, ""));
                proposals.add(new CompletionProposal("</" + tagName + ">", firstChildStartOffset, 0, 0, this.getImage(), XMLUIMessages.QuickFixProcessorXML_3, null, ""));
                proposals.add(new CompletionProposal("</" + tagName + ">", endOffset, 0, 0, this.getImage(), XMLUIMessages.QuickFixProcessorXML_4, null, ""));
                break;
            }
            case 3: {
                proposals.add(new CompletionProposal("", invocationContext.getOffset(), invocationContext.getLength(), 0, this.getImage(), XMLUIMessages.QuickFixProcessorXML_5, null, ""));
                break;
            }
            case 4: {
                String defaultAttrValue = (String)((Object[])this.fAdditionalFixInfo)[0];
                int insertOffset = (Integer)((Object[])this.fAdditionalFixInfo)[1];
                proposals.add(new CompletionProposal("\"" + defaultAttrValue + "\"", invocationContext.getOffset() + invocationContext.getLength() + insertOffset, 0, defaultAttrValue.length() + 2, this.getImage(), XMLUIMessages.QuickFixProcessorXML_6, null, ""));
                proposals.add(new CompletionProposal("", invocationContext.getOffset(), invocationContext.getLength(), 0, this.getImage(), XMLUIMessages.QuickFixProcessorXML_7, null, ""));
                break;
            }
            case 5: {
                String defaultAttrValue = (String)this.fAdditionalFixInfo;
                proposals.add(new CompletionProposal("=\"" + defaultAttrValue + "\"", invocationContext.getOffset() + invocationContext.getLength(), 0, defaultAttrValue.length() + 3, this.getImage(), XMLUIMessages.QuickFixProcessorXML_6, null, ""));
                proposals.add(new CompletionProposal("", invocationContext.getOffset(), invocationContext.getLength(), 0, this.getImage(), XMLUIMessages.QuickFixProcessorXML_7, null, ""));
                break;
            }
            case 6: {
                proposals.add(new CompletionProposal("", invocationContext.getOffset(), invocationContext.getLength(), 0, this.getImage(), XMLUIMessages.QuickFixProcessorXML_8, null, ""));
                break;
            }
            case 7: {
                proposals.add(new CompletionProposal("", invocationContext.getOffset(), invocationContext.getLength(), 0, this.getImage(), XMLUIMessages.QuickFixProcessorXML_9, null, ""));
                break;
            }
            case 8: {
                proposals.add(new CompletionProposal("", invocationContext.getOffset(), invocationContext.getLength(), 0, this.getImage(), XMLUIMessages.QuickFixProcessorXML_10, null, ""));
                break;
            }
            case 9: {
                proposals.add(new RemoveUnknownElementQuickFixProposal(this.fAdditionalFixInfo, this.getImage(), XMLUIMessages.QuickFixProcessorXML_11));
                proposals.add(new RenameInFileQuickAssistProposal());
                break;
            }
            case 10: {
                proposals.add(new CompletionProposal("", invocationContext.getOffset(), invocationContext.getLength(), 0, this.getImage(), XMLUIMessages.QuickFixProcessorXML_7, null, ""));
                proposals.add(new RenameInFileQuickAssistProposal());
                break;
            }
            case 11: {
                proposals.add(new CompletionProposal("", invocationContext.getOffset(), invocationContext.getLength(), 0, this.getImage(), XMLUIMessages.QuickFixProcessorXML_12, null, ""));
                break;
            }
            case 12: {
                String requiredAttr = (String)((Object[])this.fAdditionalFixInfo)[0];
                int insertOffset = (Integer)((Object[])this.fAdditionalFixInfo)[1];
                proposals.add(new CompletionProposal(requiredAttr, invocationContext.getOffset() + insertOffset, 0, requiredAttr.length(), this.getImage(), XMLUIMessages.QuickFixProcessorXML_13, null, ""));
                break;
            }
            case 13: {
                String attrValue = (String)this.fAdditionalFixInfo;
                proposals.add(new CompletionProposal("\"" + attrValue + "\"", invocationContext.getOffset(), invocationContext.getLength(), attrValue.length() + 2, this.getImage(), XMLUIMessages.QuickFixProcessorXML_14, null, ""));
                break;
            }
            case 14: {
                proposals.add(new CompletionProposal(">", invocationContext.getOffset() + invocationContext.getLength(), 0, 1, this.getImage(), XMLUIMessages.QuickFixProcessorXML_15, null, ""));
            }
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    public String getErrorMessage() {
        return null;
    }

    private Image getImage() {
        return XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/correction_change.gif");
    }

    public void setProblemId(int problemId) {
        this.fProblemId = problemId;
    }

    public void setAdditionalFixInfo(Object fixInfo) {
        this.fAdditionalFixInfo = fixInfo;
    }
}

