/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.staticstring;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMemberMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.types.StaticLengthStringDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.utils.JsonMetadataStrings;

public final class StaticLengthStringParser
extends AbstractScopedCommonTreeParser {
    public static final StaticLengthStringParser INSTANCE = new StaticLengthStringParser();

    private StaticLengthStringParser() {
    }

    @Override
    public IDeclaration parse(ICTFMetadataNode node, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(node instanceof JsonStructureFieldMemberMetadataNode)) {
            throw new ParseException("Static-length string only supported in JSON metadata");
        }
        JsonStructureFieldMemberMetadataNode member = (JsonStructureFieldMemberMetadataNode)node;
        JsonElement fieldClassElement = member.getFieldClass();
        if (fieldClassElement == null || !fieldClassElement.isJsonObject()) {
            throw new ParseException(this.getClass().getName() + " fieldclass must be a json object.");
        }
        JsonObject fieldClass = fieldClassElement.getAsJsonObject();
        JsonElement lengthField = fieldClass.get("length");
        if (lengthField == null) {
            throw new ParseException("static-length string requires length-field-location property");
        }
        JsonElement encodingField = fieldClass.get("encoding");
        int length = lengthField.getAsInt();
        if ((double)length > 1000000.0) {
            throw new ParseException("static-length string is over 1 million characters long, assuming an error.");
        }
        Charset encoding = encodingField != null ? JsonMetadataStrings.ENCODINGS.getOrDefault(encodingField.getAsString(), StandardCharsets.UTF_8) : StandardCharsets.UTF_8;
        return new StaticLengthStringDeclaration(length, encoding);
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final CTFTrace fTrace;

        public Param(CTFTrace trace) {
            this.fTrace = trace;
        }

        public CTFTrace getTrace() {
            return this.fTrace;
        }
    }
}

