/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.selection;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.selection.SelectionHistory;

public class StructuredSelectHistoryActionDelegate
implements IEditorActionDelegate,
IActionDelegate2,
IViewActionDelegate {
    private IEditorPart fEditor;
    private SelectionHistory fHistory;

    public void dispose() {
        this.fEditor = null;
        this.fHistory = null;
    }

    public void init(IAction action) {
        if (action != null) {
            action.setText(SSEUIMessages.StructureSelectHistory_label);
            action.setToolTipText(SSEUIMessages.StructureSelectHistory_tooltip);
            action.setDescription(SSEUIMessages.StructureSelectHistory_description);
        }
    }

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        IRegion old = this.fHistory.getLast();
        if (old != null) {
            try {
                this.fHistory.ignoreSelectionChanges();
                if (this.fEditor instanceof ITextEditor) {
                    ((ITextEditor)this.fEditor).selectAndReveal(old.getOffset(), old.getLength());
                }
            }
            finally {
                this.fHistory.listenToSelectionChanges();
            }
        }
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.fEditor = targetEditor;
        this.fHistory = this.fEditor != null ? (SelectionHistory)this.fEditor.getAdapter(SelectionHistory.class) : null;
        if (this.fHistory != null) {
            this.fHistory.setHistoryAction(action);
        }
    }
}

