/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.model.config;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfigurationSource;
import org.eclipse.tracecompass.tmf.core.config.TmfConfigurationSourceManager;
import org.eclipse.tracecompass.tmf.tests.stubs.model.config.TestConfigurationSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TmfConfigurationSourceManagerTest {
    private static final String UNKNOWN_TYPE = "test-test-test";
    private static TmfConfigurationSourceManager sfInstance;

    @Before
    public void setUp() {
        sfInstance = TmfConfigurationSourceManager.getInstance();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testConfigurationSourceTypes() {
        @NonNull List sources = sfInstance.getConfigurationSourceTypes();
        Assert.assertFalse((boolean)sources.isEmpty());
        Assert.assertFalse((boolean)sources.stream().anyMatch(config -> config.getId().equals(UNKNOWN_TYPE)));
        Assert.assertTrue((boolean)sources.stream().anyMatch(config -> config.getId().equals("org.eclipse.tracecompass.tmf.tests.stubs.model.config.testsourcetype")));
    }

    @Test
    public void testConfigurationSource() {
        ITmfConfigurationSource source = sfInstance.getConfigurationSource(UNKNOWN_TYPE);
        Assert.assertNull((Object)source);
        source = sfInstance.getConfigurationSource("org.eclipse.tracecompass.tmf.tests.stubs.model.config.testsourcetype");
        Assert.assertNotNull((Object)source);
        Assert.assertTrue((boolean)(source instanceof TestConfigurationSource));
    }
}

