/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.pcap.core.tests.event;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.packet.Packet;
import org.eclipse.tracecompass.internal.pcap.core.protocol.ipv4.IPv4Packet;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.internal.tmf.pcap.core.event.PcapEventField;
import org.eclipse.tracecompass.internal.tmf.pcap.core.event.PcapRootEventField;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class PcapEventFieldTest {
    private static final @NonNull String EMPTY_STRING = "";
    private static PcapEventField fRegularField;
    private static PcapRootEventField fRootField;

    @BeforeClass
    public static void setUp() throws IOException, BadPcapFileException, BadPacketException {
        ByteBuffer bb = ByteBuffer.allocate(25);
        bb.order(ByteOrder.BIG_ENDIAN);
        bb.put((byte)70);
        bb.put((byte)-102);
        bb.put((byte)0);
        bb.put((byte)-1);
        bb.put((byte)15);
        bb.put((byte)-16);
        bb.put((byte)30);
        bb.put((byte)-31);
        bb.put((byte)-96);
        bb.put((byte)-2);
        bb.put((byte)51);
        bb.put((byte)68);
        bb.put((byte)-64);
        bb.put((byte)-88);
        bb.put((byte)1);
        bb.put((byte)0);
        bb.put((byte)-63);
        bb.put((byte)-87);
        bb.put((byte)2);
        bb.put((byte)1);
        bb.put((byte)-94);
        bb.put((byte)86);
        bb.put((byte)-94);
        bb.put((byte)86);
        bb.put((byte)-90);
        bb.flip();
        PcapTestTrace trace = PcapTestTrace.MOSTLY_TCP;
        Assume.assumeTrue((boolean)trace.exists());
        Throwable throwable = null;
        Object var3_4 = null;
        try (PcapFile file = trace.getTrace();){
            IPv4Packet packet = new IPv4Packet(file, null, bb);
            ITmfEventField[] fieldArray = PcapEventFieldTest.generatePacketFields((Packet)packet);
            fRegularField = new PcapEventField("Regular Field", (Object)EMPTY_STRING, fieldArray, (Packet)packet);
            fRootField = new PcapRootEventField(fieldArray, (Packet)packet);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void copyConstructorTest() {
        PcapEventField oldField = fRegularField;
        if (oldField == null) {
            Assert.fail((String)"The field has not been initialized!");
            return;
        }
        PcapEventField newField = new PcapEventField(oldField);
        Assert.assertEquals((long)fRegularField.hashCode(), (long)newField.hashCode());
        Assert.assertEquals((Object)fRegularField, (Object)newField);
    }

    @Test
    public void regularFieldValueRequestTest() {
        ITmfEventField field = fRootField.getField(new String[]{"Internet Protocol Version 4"});
        if (field == null) {
            Assert.fail((String)"The field is null!");
            return;
        }
        ITmfEventField subfield = field.getField(new String[]{"Source IP Address"});
        if (subfield == null) {
            Assert.fail((String)"The subfield is null!");
            return;
        }
        String string = subfield.getValue().toString();
        Assert.assertEquals((Object)"192.168.1.0", (Object)string);
    }

    @Test
    public void customFieldValueRequestTest() {
        ITmfEventField field = fRootField.getField(new String[]{":protocol:"});
        if (field == null) {
            Assert.fail((String)"The field is null!");
            return;
        }
        String string = field.getValue().toString();
        Assert.assertEquals((Object)"IPV4", (Object)string);
        field = fRootField.getField(new String[]{":packetsource:"});
        if (field == null) {
            Assert.fail((String)"The field is null!");
            return;
        }
        string = field.getValue().toString();
        Assert.assertEquals((Object)"192.168.1.0", (Object)string);
        field = fRootField.getField(new String[]{":packetdestination:"});
        if (field == null) {
            Assert.fail((String)"The field is null!");
            return;
        }
        string = field.getValue().toString();
        Assert.assertEquals((Object)"193.169.2.1", (Object)string);
    }

    @Test
    public void regularToStringTest() {
        Assert.assertEquals((Object)"Src: 192.168.1.0 , Dst: 193.169.2.1", (Object)fRegularField.toString());
    }

    @Test
    public void rootToStringTest() {
        Assert.assertEquals((Object)"192.168.1.0 > 193.169.2.1 Id=4080 Len=1", (Object)fRootField.toString());
    }

    private static ITmfEventField @NonNull [] generatePacketFields(Packet packet) {
        ArrayList<PcapEventField> fieldList = new ArrayList<PcapEventField>();
        ArrayList<TmfEventField> subfieldList = new ArrayList<TmfEventField>();
        Packet localPacket = packet;
        while (localPacket != null) {
            subfieldList.clear();
            for (Map.Entry entry : localPacket.getFields().entrySet()) {
                @Nullable String key = (String)entry.getKey();
                @Nullable String value = (String)entry.getValue();
                subfieldList.add(new TmfEventField(key, (Object)value, null));
            }
            ITmfEventField[] subfieldArray = subfieldList.toArray(new ITmfEventField[subfieldList.size()]);
            fieldList.add(new PcapEventField(localPacket.getProtocol().getName(), (Object)EMPTY_STRING, subfieldArray, localPacket));
            localPacket = localPacket.getChildPacket();
        }
        return fieldList.toArray(new ITmfEventField[fieldList.size()]);
    }
}

