/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.utilities;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.wst.common.internal.emf.utilities.Association;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class CopyGroup {
    protected String defaultIdSuffix;
    protected ResourceSet copyContext;
    protected List resources;
    protected List refObjects;
    protected List copiedResources;
    protected List copiedRefObjects;
    protected boolean preserveIds = false;

    public boolean add(EObject aRefObject) {
        return this.add(aRefObject, null);
    }

    public boolean add(EObject aRefObject, String idSuffix) {
        if (aRefObject != null && !this.containsRefObject(aRefObject)) {
            this.getRefObjects().add(this.createAssociation(aRefObject, idSuffix));
            return true;
        }
        return false;
    }

    public void add(Resource aResource) {
        this.add(aResource, null);
    }

    public void add(Resource aResource, String newUri) {
        if (aResource != null) {
            this.getResources().add(this.createAssociation(aResource, newUri));
        }
    }

    public void addCopied(EObject aRefObject) {
        if (aRefObject != null) {
            this.getCopiedRefObjects().add(aRefObject);
        }
    }

    public void addCopied(Resource aResource) {
        if (aResource != null) {
            this.getCopiedResources().add(aResource);
            if (this.getCopyContext() != null) {
                this.getCopyContext().getResources().add((Object)aResource);
            }
        }
    }

    protected boolean contains(List associations, Object anObject) {
        if (anObject == null) {
            return false;
        }
        int size = associations.size();
        int i = 0;
        while (i < size) {
            Association assoc = (Association)associations.get(i);
            if (assoc.getKey() == anObject) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsRefObject(EObject aRefObject) {
        return this.contains(this.getRefObjects(), aRefObject);
    }

    public boolean containsResource(Resource aResource) {
        return this.contains(this.getResources(), aResource);
    }

    private Association createAssociation(Object key, Object value) {
        return new Association(key, value);
    }

    public List getCopiedRefObjects() {
        if (this.copiedRefObjects == null) {
            this.copiedRefObjects = new ArrayList();
        }
        return this.copiedRefObjects;
    }

    public List getCopiedResources() {
        if (this.copiedResources == null) {
            this.copiedResources = new ArrayList();
        }
        return this.copiedResources;
    }

    public ResourceSet getCopyContext() {
        return this.copyContext;
    }

    public String getDefaultIdSuffix() {
        return this.defaultIdSuffix;
    }

    public boolean getPreserveIds() {
        return this.preserveIds;
    }

    public List getRefObjects() {
        if (this.refObjects == null) {
            this.refObjects = new ArrayList();
        }
        return this.refObjects;
    }

    public List getResources() {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        return this.resources;
    }

    public List primGetRefObjects() {
        return this.refObjects;
    }

    public List primGetResources() {
        return this.resources;
    }

    public boolean remove(EObject aRefObject) {
        if (aRefObject != null && this.primGetRefObjects() != null) {
            Iterator it = this.primGetRefObjects().iterator();
            while (it.hasNext()) {
                Association association = (Association)it.next();
                if (association.getKey() != aRefObject) continue;
                return this.primGetRefObjects().remove(association);
            }
        }
        return false;
    }

    public boolean remove(Resource aResource) {
        if (aResource != null && this.primGetResources() != null) {
            Iterator it = this.primGetResources().iterator();
            while (it.hasNext()) {
                Association association = (Association)it.next();
                if (association.getKey() != aResource) continue;
                return this.primGetResources().remove(association);
            }
        }
        return false;
    }

    public void setCopyContext(ResourceSet newCopyContext) {
        this.copyContext = newCopyContext;
    }

    public void setDefaultIdSuffix(String newDefaultIdSuffix) {
        this.defaultIdSuffix = newDefaultIdSuffix;
    }

    public void setPreserveIds(boolean value) {
        this.preserveIds = value;
    }

    public void postCopy(EtoolsCopyUtility copyUtil) {
    }
}

