/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.properties;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.JpaModelManager;
import org.eclipse.jpt.core.internal.facet.JpaFacetDataModelProperties;
import org.eclipse.jpt.core.internal.facet.JpaFacetDataModelProvider;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.JptDbPlugin;
import org.eclipse.jpt.db.ui.internal.DTPUiTools;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.properties.DataModelPropertyPage;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class JpaProjectPropertiesPage
extends DataModelPropertyPage
implements JpaFacetDataModelProperties {
    private PlatformGroup platformGroup;
    private ConnectionGroup connectionGroup;
    private PersistentClassManagementGroup persistentClassManagementGroup;

    public JpaProjectPropertiesPage() {
        super(DataModelFactory.createDataModel((IDataModelProvider)new JpaFacetDataModelProvider()));
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.platformGroup = new PlatformGroup(composite);
        this.connectionGroup = new ConnectionGroup(composite);
        this.persistentClassManagementGroup = new PersistentClassManagementGroup(composite);
        this.setRuntime();
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jpt.ui.properties_javaPersistence");
        return composite;
    }

    private void setRuntime() {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)this.getJpaProject().getProject());
        }
        catch (CoreException ce) {
            JptUiPlugin.log(ce);
            return;
        }
        IRuntime runtime = facetedProject.getPrimaryRuntime();
        this.model.setProperty("JpaFacetDataModelProperties.RUNTIME", (Object)runtime);
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"JpaFacetDataModelProperties.PLATFORM_ID", "JpaFacetDataModelProperties.CONNECTION", "JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA", "JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", "JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES"};
    }

    protected JpaProject getJpaProject() {
        return (JpaProject)this.getElement().getAdapter(JpaProject.class);
    }

    Combo createCombo(Composite container, int span, boolean fillHorizontal) {
        Combo combo = new Combo(container, 2060);
        GridData gd = fillHorizontal ? new GridData(768) : new GridData();
        gd.horizontalSpan = span;
        combo.setLayoutData((Object)gd);
        return combo;
    }

    Button createButton(Composite container, int span, String text, int style) {
        Button button = new Button(container, style);
        button.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        button.setLayoutData((Object)gd);
        return button;
    }

    protected void performDefaults() {
        this.platformGroup.performDefaults();
        this.connectionGroup.performDefaults();
        this.persistentClassManagementGroup.performDefaults();
    }

    public boolean performOk() {
        boolean discover;
        String projectUserOverrideDefaultSchema;
        String connection;
        JpaProject jpaProject = this.getJpaProject();
        if (jpaProject == null) {
            return true;
        }
        boolean change = false;
        boolean platformChange = false;
        IProject project = jpaProject.getProject();
        String platform = this.model.getStringProperty("JpaFacetDataModelProperties.PLATFORM_ID");
        if (!platform.equals(jpaProject.getJpaPlatform().getId())) {
            change = true;
            platformChange = true;
            JptCorePlugin.setJpaPlatformId((IProject)project, (String)platform);
        }
        if (!(connection = this.model.getStringProperty("JpaFacetDataModelProperties.CONNECTION")).equals(jpaProject.getDataSource().getConnectionProfileName())) {
            change = true;
            jpaProject.getDataSource().setConnectionProfileName(connection);
            JptCorePlugin.setConnectionProfileName((IProject)project, (String)connection);
        }
        String userOverrideDefaultSchema = null;
        if (this.model.getBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA")) {
            userOverrideDefaultSchema = this.model.getStringProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA");
        }
        if (!StringTools.stringsAreEqualIgnoreCase((String)userOverrideDefaultSchema, (String)(projectUserOverrideDefaultSchema = jpaProject.getUserOverrideDefaultSchemaName()))) {
            change = true;
            jpaProject.setUserOverrideDefaultSchemaName(userOverrideDefaultSchema);
            JptCorePlugin.setUserOverrideDefaultSchemaName((IProject)project, (String)userOverrideDefaultSchema);
        }
        if ((discover = this.model.getBooleanProperty("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES")) != jpaProject.discoversAnnotatedClasses()) {
            change = true;
            jpaProject.setDiscoversAnnotatedClasses(discover);
            JptCorePlugin.setDiscoverAnnotatedClasses((IProject)project, (boolean)discover);
        }
        if (platformChange) {
            JpaModelManager.instance().rebuildJpaProject(project);
        }
        if (change) {
            JpaProjectPropertiesPage.buildProject(project);
        }
        return true;
    }

    private static void buildProject(final IProject project) {
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    project.build(6, pm);
                }
                catch (CoreException ce) {
                    JptUiPlugin.log(ce);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, false, r);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    private final class ConnectionGroup {
        final Combo connectionCombo;
        private Link connectionLink;
        private Link connectLink;
        private final Button overrideDefaultSchemaButton;
        private final Label defaultSchemaLabel;
        private final Combo defaultSchemaCombo;

        public ConnectionGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setText(JptUiMessages.JpaFacetWizardPage_connectionLabel);
            group.setLayout((Layout)new GridLayout(3, false));
            group.setLayoutData((Object)new GridData(768));
            this.connectionCombo = JpaProjectPropertiesPage.this.createCombo((Composite)group, 3, true);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, "org.eclipse.jpt.ui.properties_javaPersistenceConnection");
            JpaProjectPropertiesPage.this.synchHelper.synchCombo(this.connectionCombo, "JpaFacetDataModelProperties.CONNECTION", null);
            this.connectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionGroup.this.updateConnectLink();
                }
            });
            this.connectionLink = new Link((Composite)group, 0);
            GridData data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            this.connectionLink.setLayoutData((Object)data);
            this.connectionLink.setText(JptUiMessages.JpaFacetWizardPage_connectionLink);
            this.connectionLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionGroup.this.openNewConnectionWizard();
                }
            });
            this.connectLink = new Link((Composite)group, 0);
            data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            this.connectLink.setLayoutData((Object)data);
            this.connectLink.setText(JptUiMessages.JpaFacetWizardPage_connectLink);
            this.connectLink.setEnabled(false);
            this.connectLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionGroup.this.openConnectionProfile();
                }
            });
            this.overrideDefaultSchemaButton = JpaProjectPropertiesPage.this.createButton((Composite)group, 3, JptUiMessages.JpaFacetWizardPage_overrideDefaultSchemaLabel, 32);
            JpaProjectPropertiesPage.this.synchHelper.synchCheckbox(this.overrideDefaultSchemaButton, "JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA", new Control[0]);
            this.defaultSchemaLabel = new Label((Composite)group, 16384);
            this.defaultSchemaLabel.setText(JptUiMessages.JpaFacetWizardPage_defaultSchemaLabel);
            GridData gd = new GridData();
            gd.horizontalSpan = 1;
            this.defaultSchemaLabel.setLayoutData((Object)gd);
            this.defaultSchemaCombo = JpaProjectPropertiesPage.this.createCombo((Composite)group, 1, true);
            JpaProjectPropertiesPage.this.synchHelper.synchCombo(this.defaultSchemaCombo, "JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", new Control[]{this.defaultSchemaLabel});
            this.performDefaults();
        }

        void openNewConnectionWizard() {
            String connectionName = DTPUiTools.createNewProfile();
            if (connectionName != null) {
                JpaProjectPropertiesPage.this.model.setProperty("JpaFacetDataModelProperties.CONNECTION", (Object)connectionName);
            }
        }

        private void openConnectionProfile() {
            ConnectionProfile connection = this.getConnectionProfile();
            connection.connect();
            JpaProjectPropertiesPage.this.model.setBooleanProperty("JpaFacetDataModelProperties.CONNECTION_ACTIVE", connection.isActive());
            this.updateConnectLink();
        }

        private void updateConnectLink() {
            ConnectionProfile connectionProfile = this.getConnectionProfile();
            this.connectLink.setEnabled(!connectionProfile.isNull() && !connectionProfile.isConnected());
        }

        private ConnectionProfile getConnectionProfile() {
            return JptDbPlugin.instance().getConnectionProfileRepository().connectionProfileNamed(JpaProjectPropertiesPage.this.model.getStringProperty("JpaFacetDataModelProperties.CONNECTION"));
        }

        void performDefaults() {
            String connectionName = JpaProjectPropertiesPage.this.getJpaProject().getDataSource().getConnectionProfileName();
            JpaProjectPropertiesPage.this.model.setProperty("JpaFacetDataModelProperties.CONNECTION", (Object)connectionName);
            String defaultSchema = JpaProjectPropertiesPage.this.getJpaProject().getUserOverrideDefaultSchemaName();
            JpaProjectPropertiesPage.this.model.setProperty("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA", (Object)(defaultSchema != null ? 1 : 0));
            JpaProjectPropertiesPage.this.model.setProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", (Object)defaultSchema);
        }
    }

    private final class PersistentClassManagementGroup {
        final Button discoverClassesButton;
        final Button listClassesButton;

        public PersistentClassManagementGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setText(JptUiMessages.JpaFacetWizardPage_persistentClassManagementLabel);
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(768));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, "org.eclipse.jpt.ui.dialog_addJavaPersistence_classpath");
            this.discoverClassesButton = JpaProjectPropertiesPage.this.createButton((Composite)group, 1, JptUiMessages.JpaFacetWizardPage_discoverClassesButton, 16);
            JpaProjectPropertiesPage.this.synchHelper.synchRadio(this.discoverClassesButton, "JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES", null);
            this.listClassesButton = JpaProjectPropertiesPage.this.createButton((Composite)group, 1, JptUiMessages.JpaFacetWizardPage_listClassesButton, 16);
            JpaProjectPropertiesPage.this.synchHelper.synchRadio(this.listClassesButton, "JpaFacetDataModelProperties.LIST_ANNOTATED_CLASSES", null);
            this.performDefaults();
        }

        void performDefaults() {
            boolean discoverClasses = JpaProjectPropertiesPage.this.getJpaProject().discoversAnnotatedClasses();
            JpaProjectPropertiesPage.this.model.setProperty("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES", (Object)discoverClasses);
        }
    }

    private final class PlatformGroup {
        final Combo platformCombo;

        public PlatformGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setText(JptUiMessages.JpaFacetWizardPage_platformLabel);
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(768));
            this.platformCombo = JpaProjectPropertiesPage.this.createCombo((Composite)group, 1, true);
            JpaProjectPropertiesPage.this.synchHelper.synchCombo(this.platformCombo, "JpaFacetDataModelProperties.PLATFORM_ID", null);
            this.performDefaults();
        }

        void performDefaults() {
            String platformId = JpaProjectPropertiesPage.this.getJpaProject().getJpaPlatform().getId();
            JpaProjectPropertiesPage.this.model.setProperty("JpaFacetDataModelProperties.PLATFORM_ID", (Object)platformId);
        }
    }
}

