/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.palette;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteTemplateEntry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wst.common.snippets.core.ISnippetCategory;
import org.eclipse.wst.common.snippets.core.ISnippetItem;
import org.eclipse.wst.common.snippets.core.ISnippetVariable;
import org.eclipse.wst.common.snippets.internal.palette.SnippetImageDescriptorHelper;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteDrawer;

public class SnippetPaletteItem
extends PaletteTemplateEntry
implements ISnippetItem {
    protected SnippetPaletteDrawer fCategory;
    protected String fCategoryName;
    protected String fClassName;
    protected String fContentString;
    protected String fEditorClassName;
    protected String[] fFilters = new String[0];
    protected String fIconName;
    protected String fId;
    protected String fLargeIconName;
    protected Object fSourceDescriptor;
    protected Object fSourceType = "USER";
    protected List fVariables = new ArrayList(0);

    public SnippetPaletteItem(String label) {
        super(label, label, null, null, null);
    }

    public void addVariable(ISnippetVariable variable) {
        this.fVariables.add(variable);
    }

    public ISnippetCategory getCategory() {
        return this.fCategory;
    }

    public String getCategoryName() {
        if (this.fCategory == null) {
            return this.fCategoryName;
        }
        return this.fCategory.getId();
    }

    public String getClassName() {
        return this.fClassName;
    }

    public String getContentString() {
        return this.fContentString;
    }

    public String getEditorClassName() {
        return this.fEditorClassName;
    }

    public String[] getFilters() {
        return this.fFilters;
    }

    public String getSmallIconName() {
        return this.fIconName;
    }

    public String getId() {
        return this.fId;
    }

    public ImageDescriptor getLargeIcon() {
        ImageDescriptor icon = super.getLargeIcon();
        if (icon == null) {
            icon = SnippetImageDescriptorHelper.getInstance().getImageDescriptor(this, true);
            this.setLargeIcon(icon);
        }
        return icon;
    }

    public String getLargeIconName() {
        return this.fLargeIconName;
    }

    public ImageDescriptor getSmallIcon() {
        ImageDescriptor icon = super.getSmallIcon();
        if (icon == null) {
            icon = SnippetImageDescriptorHelper.getInstance().getImageDescriptor(this);
            this.setSmallIcon(icon);
        }
        return icon;
    }

    public Object getSourceDescriptor() {
        return this.fSourceDescriptor;
    }

    public Object getSourceType() {
        return this.fSourceType;
    }

    public ISnippetVariable[] getVariables() {
        return this.fVariables.toArray(new ISnippetVariable[this.fVariables.size()]);
    }

    public void removeVariable(ISnippetVariable variable) {
        this.fVariables.remove(variable);
    }

    public void setCategory(ISnippetCategory category) {
        this.fCategory = (SnippetPaletteDrawer)category;
        super.setParent((PaletteContainer)category);
        if (this.fCategory == null) {
            this.setCategoryName(null);
        } else {
            this.setCategoryName(this.fCategory.getId());
        }
    }

    public void setCategoryName(String categoryName) {
        this.fCategoryName = categoryName;
    }

    public void setClassName(String className) {
        this.fClassName = className;
    }

    public void setContentString(String contentString) {
        this.fContentString = contentString;
    }

    public void setEditorClassName(String editorClassName) {
        this.fEditorClassName = editorClassName;
    }

    public void setFilters(String[] filters) {
        this.fFilters = filters;
    }

    public void setIconName(String iconName) {
        this.fIconName = iconName;
    }

    public void setId(String id) {
        this.fId = id;
    }

    public void setLargeIconName(String largeIconName) {
        this.fLargeIconName = largeIconName;
    }

    public void setParent(PaletteContainer newParent) {
        this.setCategory((ISnippetCategory)newParent);
    }

    public void setSourceDescriptor(Object sourceDescriptor) {
        this.fSourceDescriptor = sourceDescriptor;
    }

    public void setSourceType(Object sourceType) {
        this.fSourceType = sourceType;
    }

    protected void setVariables(ISnippetVariable[] variables) {
        this.fVariables = new ArrayList(variables.length);
        this.fVariables.addAll(Arrays.asList(variables));
    }
}

