/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences.cleanup;

import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wst.jsdt.internal.ui.fix.ICleanUp;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.CleanUpPreview;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ModifyDialogTabPage;

public abstract class CleanUpTabPage
extends ModifyDialogTabPage {
    private final Map fValues;
    private JavaPreview fCleanUpPreview;
    private final boolean fIsSaveAction;
    private int fCount;
    private int fSelectedCount;

    public CleanUpTabPage(ModifyDialogTabPage.IModificationListener listener, Map values, boolean isSaveAction) {
        super(listener, values);
        this.fValues = values;
        this.fIsSaveAction = isSaveAction;
        this.fCount = 0;
        this.fSelectedCount = 0;
    }

    public boolean isSaveAction() {
        return this.fIsSaveAction;
    }

    public int getCleanUpCount() {
        return this.fCount;
    }

    public int getSelectedCleanUpCount() {
        return this.fSelectedCount;
    }

    protected abstract ICleanUp[] createPreviewCleanUps(Map var1);

    protected JavaPreview doCreateJavaPreview(Composite parent) {
        this.fCleanUpPreview = new CleanUpPreview(parent, this.createPreviewCleanUps(this.fValues));
        return this.fCleanUpPreview;
    }

    protected void doUpdatePreview() {
        this.fCleanUpPreview.setWorkingValues(this.fValues);
        this.fCleanUpPreview.update();
    }

    protected void initializePage() {
        this.fCleanUpPreview.update();
    }

    protected void registerPreference(final ModifyDialogTabPage.CheckboxPreference preference) {
        ++this.fCount;
        preference.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                if (preference.getChecked()) {
                    CleanUpTabPage cleanUpTabPage = CleanUpTabPage.this;
                    cleanUpTabPage.fSelectedCount = cleanUpTabPage.fSelectedCount + 1;
                } else {
                    CleanUpTabPage cleanUpTabPage = CleanUpTabPage.this;
                    cleanUpTabPage.fSelectedCount = cleanUpTabPage.fSelectedCount - 1;
                }
            }
        });
        if (preference.getChecked()) {
            ++this.fSelectedCount;
        }
    }

    protected void registerSlavePreference(ModifyDialogTabPage.CheckboxPreference master, ModifyDialogTabPage.RadioPreference[] slaves) {
        this.internalRegisterSlavePreference(master, slaves);
        this.registerPreference(master);
    }

    protected void registerSlavePreference(final ModifyDialogTabPage.CheckboxPreference master, final ModifyDialogTabPage.CheckboxPreference[] slaves) {
        this.internalRegisterSlavePreference(master, slaves);
        this.fCount += slaves.length;
        master.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                if (master.getChecked()) {
                    int i = 0;
                    while (i < slaves.length) {
                        if (slaves[i].getChecked()) {
                            CleanUpTabPage cleanUpTabPage = CleanUpTabPage.this;
                            cleanUpTabPage.fSelectedCount = cleanUpTabPage.fSelectedCount + 1;
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < slaves.length) {
                        if (slaves[i].getChecked()) {
                            CleanUpTabPage cleanUpTabPage = CleanUpTabPage.this;
                            cleanUpTabPage.fSelectedCount = cleanUpTabPage.fSelectedCount - 1;
                        }
                        ++i;
                    }
                }
            }
        });
        int i = 0;
        while (i < slaves.length) {
            final ModifyDialogTabPage.CheckboxPreference slave = slaves[i];
            slave.addObserver(new Observer(){

                public void update(Observable o, Object arg) {
                    if (slave.getChecked()) {
                        CleanUpTabPage cleanUpTabPage = CleanUpTabPage.this;
                        cleanUpTabPage.fSelectedCount = cleanUpTabPage.fSelectedCount + 1;
                    } else {
                        CleanUpTabPage cleanUpTabPage = CleanUpTabPage.this;
                        cleanUpTabPage.fSelectedCount = cleanUpTabPage.fSelectedCount - 1;
                    }
                }
            });
            ++i;
        }
        if (master.getChecked()) {
            i = 0;
            while (i < slaves.length) {
                if (slaves[i].getChecked()) {
                    ++this.fSelectedCount;
                }
                ++i;
            }
        }
    }

    private void internalRegisterSlavePreference(final ModifyDialogTabPage.CheckboxPreference master, final ModifyDialogTabPage.ButtonPreference[] slaves) {
        master.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                int i = 0;
                while (i < slaves.length) {
                    slaves[i].setEnabled(master.getChecked());
                    ++i;
                }
            }
        });
        int i = 0;
        while (i < slaves.length) {
            slaves[i].setEnabled(master.getChecked());
            ++i;
        }
    }

    protected void intent(Composite group) {
        Label l = new Label(group, 0);
        GridData gd = new GridData();
        gd.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(4);
        l.setLayoutData((Object)gd);
    }
}

