/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public class UnimplementedMethodsCompletionProposal
extends ASTRewriteCorrectionProposal {
    private ASTNode fTypeNode;
    private IFunctionBinding[] fMethodsToOverride;

    public UnimplementedMethodsCompletionProposal(IJavaScriptUnit cu, ASTNode typeNode, int relevance) {
        super("", cu, (ASTRewrite)null, relevance, (Image)null);
        this.setDisplayName(CorrectionMessages.UnimplementedMethodsCompletionProposal_description);
        this.setImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif"));
        this.fTypeNode = typeNode;
        this.fMethodsToOverride = null;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        ListRewrite listRewrite;
        ITypeBinding binding;
        AnonymousClassDeclaration decl;
        AST ast = this.fTypeNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        if (this.fTypeNode instanceof AnonymousClassDeclaration) {
            decl = (AnonymousClassDeclaration)this.fTypeNode;
            binding = decl.resolveBinding();
            listRewrite = rewrite.getListRewrite((ASTNode)decl, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
        } else {
            decl = (AbstractTypeDeclaration)this.fTypeNode;
            binding = decl.resolveBinding();
            listRewrite = rewrite.getListRewrite((ASTNode)decl, decl.getBodyDeclarationsProperty());
        }
        IFunctionBinding[] methods = StubUtility2.getUnimplementedMethods(binding);
        this.fMethodsToOverride = methods;
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(this.getCompilationUnit().getJavaScriptProject());
        if (binding.isAnonymous()) {
            settings.createComments = false;
        }
        ImportRewrite imports = this.createImportRewrite((JavaScriptUnit)this.fTypeNode.getRoot());
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((JavaScriptUnit)this.fTypeNode.getRoot(), this.fTypeNode.getStartPosition(), imports);
        int i = 0;
        while (i < methods.length) {
            FunctionDeclaration newMethodDecl = StubUtility2.createImplementationStub(this.getCompilationUnit(), rewrite, imports, ast, methods[i], binding.getName(), settings, false, context);
            listRewrite.insertLast((ASTNode)newMethodDecl, null);
            ++i;
        }
        return rewrite;
    }

    public String getAdditionalProposalInfo() {
        try {
            this.getChange();
            StringBuffer buf = new StringBuffer();
            buf.append("<b>");
            buf.append(Messages.format(CorrectionMessages.UnimplementedMethodsCompletionProposal_info, String.valueOf(this.fMethodsToOverride.length)));
            buf.append("</b><ul>");
            int i = 0;
            while (i < this.fMethodsToOverride.length) {
                buf.append("<li>");
                buf.append(BindingLabelProvider.getBindingLabel((IBinding)this.fMethodsToOverride[i], JavaScriptElementLabels.ALL_FULLY_QUALIFIED));
                buf.append("</li>");
                ++i;
            }
            buf.append("</ul>");
            return buf.toString();
        }
        catch (CoreException e) {
            JavaScriptPlugin.log(e);
            return null;
        }
    }
}

