/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.reconciler.AbstractReconcileStep;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilableModel;
import org.eclipse.jface.text.reconciler.IReconcileResult;
import org.eclipse.jface.text.reconciler.IReconcileStep;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.internal.IReleasable;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.reconcile.DocumentAdapter;
import org.eclipse.wst.sse.ui.internal.reconcile.ReconcileAnnotationKey;

public abstract class StructuredReconcileStep
extends AbstractReconcileStep
implements IReleasable {
    protected static final boolean DEBUG;
    protected final IReconcileResult[] EMPTY_RECONCILE_RESULT_SET = new IReconcileResult[0];
    private HashSet fPartitionTypes = new HashSet();

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/reconcilerjob");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public ReconcileAnnotationKey createKey(IStructuredDocumentRegion sdRegion, int scope) {
        ITypedRegion tr = this.getPartition(sdRegion);
        String partitionType = tr != null ? tr.getType() : "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE";
        return this.createKey(partitionType, scope);
    }

    protected ITypedRegion getPartition(IStructuredDocumentRegion sdRegion) {
        ITypedRegion tr = null;
        if (!sdRegion.isDeleted()) {
            tr = this.getPartition((IDocument)sdRegion.getParentDocument(), sdRegion.getStartOffset());
        }
        return tr;
    }

    private ITypedRegion getPartition(IDocument doc, int offset) {
        ITypedRegion tr;
        block3: {
            tr = null;
            if (doc != null) {
                try {
                    tr = TextUtilities.getPartition((IDocument)doc, (String)"org.eclipse.wst.sse.core.default_structured_text_partitioning", (int)offset, (boolean)false);
                }
                catch (BadLocationException e) {
                    if (!DEBUG) break block3;
                    Logger.logException("problem getting partition at: " + offset, e);
                }
            }
        }
        return tr;
    }

    public ReconcileAnnotationKey createKey(String partitionType, int scope) {
        this.fPartitionTypes.add(partitionType);
        return new ReconcileAnnotationKey((IReconcileStep)this, partitionType, scope);
    }

    protected IDocument getDocument() {
        IDocument doc = null;
        IReconcilableModel rModel = this.getModel();
        if (rModel instanceof DocumentAdapter) {
            doc = ((DocumentAdapter)rModel).getDocument();
        }
        return doc;
    }

    public IReconcilableModel getModel() {
        return this.getInputModel();
    }

    public String getPartitionType(IDocument doc, int offset) {
        ITypedRegion tr = this.getPartition(doc, offset);
        return tr != null ? tr.getType() : "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE";
    }

    public String[] getPartitionTypes() {
        HashSet tempResults = new HashSet();
        tempResults.addAll(this.fPartitionTypes);
        return tempResults.toArray(new String[tempResults.size()]);
    }

    protected IStructuredDocument getStructuredDocument() {
        IStructuredDocument sDoc = null;
        IDocument doc = this.getDocument();
        if (doc instanceof IStructuredDocument) {
            sDoc = (IStructuredDocument)this.getDocument();
        }
        return sDoc;
    }

    protected IReconcileResult[] merge(IReconcileResult[] results1, IReconcileResult[] results2) {
        if (results1 == null) {
            return results2;
        }
        if (results2 == null) {
            return results1;
        }
        ArrayList<IReconcileResult> results = new ArrayList<IReconcileResult>();
        results.addAll(Arrays.asList(results1));
        int i = 0;
        while (i < results2.length) {
            results.add(results2[i]);
            ++i;
        }
        return results.toArray(new IReconcileResult[results.size()]);
    }

    protected IReconcileResult[] reconcileModel(DirtyRegion dirtyRegion, IRegion subRegion) {
        return this.EMPTY_RECONCILE_RESULT_SET;
    }

    public void release() {
    }
}

