/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.Messages;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.UpgradeStatus;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.VersionUpgradeOperation;

public class UpgradeOperation
extends AbstractOperation {
    private final List _stepOperations = new ArrayList();

    public UpgradeOperation(String label) {
        super(label);
    }

    public void addVersionUpgrade(VersionUpgradeOperation operation) {
        this._stepOperations.add(operation);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        boolean upgraded = false;
        for (VersionUpgradeOperation op : this._stepOperations) {
            UpgradeStatus status = (UpgradeStatus)op.execute(monitor, info);
            if (status.getSeverity() != 0) {
                return status;
            }
            if (!status.isUpgradeOccurred()) continue;
            upgraded = true;
        }
        return new UpgradeStatus(0, upgraded, Messages.UpgradeOperation_Success);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        for (VersionUpgradeOperation op : this._stepOperations) {
            IStatus status = op.redo(monitor, info);
            if (status.getSeverity() == 0) continue;
            return status;
        }
        return new UpgradeStatus(0, true, Messages.UpgradeOperation_Success);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        for (VersionUpgradeOperation op : this._stepOperations) {
            IStatus status = op.undo(monitor, info);
            if (status.getSeverity() == 0) continue;
            return status;
        }
        return Status.OK_STATUS;
    }

    public IStatus commit() throws ExecutionException {
        for (VersionUpgradeOperation op : this._stepOperations) {
            IStatus status;
            if (!op.canCommit() || (status = op.commit()).getSeverity() == 0) continue;
            return status;
        }
        return Status.OK_STATUS;
    }

    public boolean canExecute() {
        for (IUndoableOperation op : this._stepOperations) {
            if (op.canExecute()) continue;
            return false;
        }
        return true;
    }

    public boolean canRedo() {
        for (IUndoableOperation op : this._stepOperations) {
            if (op.canRedo()) continue;
            return false;
        }
        return true;
    }

    public boolean canUndo() {
        for (IUndoableOperation op : this._stepOperations) {
            if (op.canUndo()) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        for (IUndoableOperation op : this._stepOperations) {
            op.dispose();
        }
    }
}

